// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about a specified Amazon Route 53 hosted zone, including the four name servers assigned to the hosted zone. A hosted zone represents a collection of records that can be managed together, belonging to a single parent domain name.
 */
public class AwsRoute53HostedZoneDetails private constructor(builder: Builder) {
    /**
     * An object that contains information about the specified hosted zone.
     */
    public val hostedZone: aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneObjectDetails? = builder.hostedZone
    /**
     * An object that contains a list of the authoritative name servers for a hosted zone or for a reusable delegation set.
     */
    public val nameServers: List<String>? = builder.nameServers
    /**
     * An array that contains one `QueryLoggingConfig` element for each DNS query logging configuration that is associated with the current Amazon Web Services account.
     */
    public val queryLoggingConfig: aws.sdk.kotlin.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails? = builder.queryLoggingConfig
    /**
     * An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are associated with the specified hosted zone.
     */
    public val vpcs: List<AwsRoute53HostedZoneVpcDetails>? = builder.vpcs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRoute53HostedZoneDetails(")
        append("hostedZone=$hostedZone,")
        append("nameServers=$nameServers,")
        append("queryLoggingConfig=$queryLoggingConfig,")
        append("vpcs=$vpcs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostedZone?.hashCode() ?: 0
        result = 31 * result + (nameServers?.hashCode() ?: 0)
        result = 31 * result + (queryLoggingConfig?.hashCode() ?: 0)
        result = 31 * result + (vpcs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRoute53HostedZoneDetails

        if (hostedZone != other.hostedZone) return false
        if (nameServers != other.nameServers) return false
        if (queryLoggingConfig != other.queryLoggingConfig) return false
        if (vpcs != other.vpcs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains information about the specified hosted zone.
         */
        public var hostedZone: aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneObjectDetails? = null
        /**
         * An object that contains a list of the authoritative name servers for a hosted zone or for a reusable delegation set.
         */
        public var nameServers: List<String>? = null
        /**
         * An array that contains one `QueryLoggingConfig` element for each DNS query logging configuration that is associated with the current Amazon Web Services account.
         */
        public var queryLoggingConfig: aws.sdk.kotlin.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails? = null
        /**
         * An object that contains information about the Amazon Virtual Private Clouds (Amazon VPCs) that are associated with the specified hosted zone.
         */
        public var vpcs: List<AwsRoute53HostedZoneVpcDetails>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneDetails) : this() {
            this.hostedZone = x.hostedZone
            this.nameServers = x.nameServers
            this.queryLoggingConfig = x.queryLoggingConfig
            this.vpcs = x.vpcs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneDetails = AwsRoute53HostedZoneDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneObjectDetails] inside the given [block]
         */
        public fun hostedZone(block: aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneObjectDetails.Builder.() -> kotlin.Unit) {
            this.hostedZone = aws.sdk.kotlin.services.securityhub.model.AwsRoute53HostedZoneObjectDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails] inside the given [block]
         */
        public fun queryLoggingConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails.Builder.() -> kotlin.Unit) {
            this.queryLoggingConfig = aws.sdk.kotlin.services.securityhub.model.AwsRoute53QueryLoggingConfigDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
