// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about the logging status of the cluster.
 */
public class AwsRedshiftClusterLoggingStatus private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket where the log files are stored.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The message indicating that the logs failed to be delivered.
     */
    public val lastFailureMessage: kotlin.String? = builder.lastFailureMessage
    /**
     * The last time when logs failed to be delivered.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val lastFailureTime: kotlin.String? = builder.lastFailureTime
    /**
     * The last time that logs were delivered successfully.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val lastSuccessfulDeliveryTime: kotlin.String? = builder.lastSuccessfulDeliveryTime
    /**
     * Indicates whether logging is enabled.
     */
    public val loggingEnabled: kotlin.Boolean? = builder.loggingEnabled
    /**
     * Provides the prefix applied to the log file names.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRedshiftClusterLoggingStatus(")
        append("bucketName=$bucketName,")
        append("lastFailureMessage=$lastFailureMessage,")
        append("lastFailureTime=$lastFailureTime,")
        append("lastSuccessfulDeliveryTime=$lastSuccessfulDeliveryTime,")
        append("loggingEnabled=$loggingEnabled,")
        append("s3KeyPrefix=$s3KeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (lastFailureMessage?.hashCode() ?: 0)
        result = 31 * result + (lastFailureTime?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulDeliveryTime?.hashCode() ?: 0)
        result = 31 * result + (loggingEnabled?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRedshiftClusterLoggingStatus

        if (bucketName != other.bucketName) return false
        if (lastFailureMessage != other.lastFailureMessage) return false
        if (lastFailureTime != other.lastFailureTime) return false
        if (lastSuccessfulDeliveryTime != other.lastSuccessfulDeliveryTime) return false
        if (loggingEnabled != other.loggingEnabled) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the S3 bucket where the log files are stored.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The message indicating that the logs failed to be delivered.
         */
        public var lastFailureMessage: kotlin.String? = null
        /**
         * The last time when logs failed to be delivered.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var lastFailureTime: kotlin.String? = null
        /**
         * The last time that logs were delivered successfully.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var lastSuccessfulDeliveryTime: kotlin.String? = null
        /**
         * Indicates whether logging is enabled.
         */
        public var loggingEnabled: kotlin.Boolean? = null
        /**
         * Provides the prefix applied to the log file names.
         */
        public var s3KeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus) : this() {
            this.bucketName = x.bucketName
            this.lastFailureMessage = x.lastFailureMessage
            this.lastFailureTime = x.lastFailureTime
            this.lastSuccessfulDeliveryTime = x.lastSuccessfulDeliveryTime
            this.loggingEnabled = x.loggingEnabled
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus = AwsRedshiftClusterLoggingStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
