// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an Amazon Redshift cluster.
 */
public class AwsRedshiftClusterDetails private constructor(builder: Builder) {
    /**
     * Indicates whether major version upgrades are applied automatically to the cluster during the maintenance window.
     */
    public val allowVersionUpgrade: kotlin.Boolean? = builder.allowVersionUpgrade
    /**
     * The number of days that automatic cluster snapshots are retained.
     */
    public val automatedSnapshotRetentionPeriod: kotlin.Int? = builder.automatedSnapshotRetentionPeriod
    /**
     * The name of the Availability Zone in which the cluster is located.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The availability status of the cluster for queries. Possible values are the following:
     * + `Available` - The cluster is available for queries.
     * + `Unavailable` - The cluster is not available for queries.
     * + `Maintenance` - The cluster is intermittently available for queries due to maintenance activities.
     * + `Modifying` -The cluster is intermittently available for queries due to changes that modify the cluster.
     * + `Failed` - The cluster failed and is not available for queries.
     */
    public val clusterAvailabilityStatus: kotlin.String? = builder.clusterAvailabilityStatus
    /**
     * Indicates when the cluster was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val clusterCreateTime: kotlin.String? = builder.clusterCreateTime
    /**
     * The unique identifier of the cluster.
     */
    public val clusterIdentifier: kotlin.String? = builder.clusterIdentifier
    /**
     * The nodes in the cluster.
     */
    public val clusterNodes: List<AwsRedshiftClusterClusterNode>? = builder.clusterNodes
    /**
     * The list of cluster parameter groups that are associated with this cluster.
     */
    public val clusterParameterGroups: List<AwsRedshiftClusterClusterParameterGroup>? = builder.clusterParameterGroups
    /**
     * The public key for the cluster.
     */
    public val clusterPublicKey: kotlin.String? = builder.clusterPublicKey
    /**
     * The specific revision number of the database in the cluster.
     */
    public val clusterRevisionNumber: kotlin.String? = builder.clusterRevisionNumber
    /**
     * A list of cluster security groups that are associated with the cluster.
     */
    public val clusterSecurityGroups: List<AwsRedshiftClusterClusterSecurityGroup>? = builder.clusterSecurityGroups
    /**
     * Information about the destination Region and retention period for the cross-Region snapshot copy.
     */
    public val clusterSnapshotCopyStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus? = builder.clusterSnapshotCopyStatus
    /**
     * The current status of the cluster.
     *
     * Valid values: `available` | `available, prep-for-resize` | `available, resize-cleanup` |` cancelling-resize` | `creating` | `deleting` | `final-snapshot` | `hardware-failure` | `incompatible-hsm` |` incompatible-network` | `incompatible-parameters` | `incompatible-restore` | `modifying` | `paused` | `rebooting` | `renaming` | `resizing` | `rotating-keys` | `storage-full` | `updating-hsm`
     */
    public val clusterStatus: kotlin.String? = builder.clusterStatus
    /**
     * The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.
     */
    public val clusterSubnetGroupName: kotlin.String? = builder.clusterSubnetGroupName
    /**
     * The version ID of the Amazon Redshift engine that runs on the cluster.
     */
    public val clusterVersion: kotlin.String? = builder.clusterVersion
    /**
     * The name of the initial database that was created when the cluster was created.
     *
     * The same name is returned for the life of the cluster.
     *
     * If an initial database is not specified, a database named `devdev` is created by default.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * List of time windows during which maintenance was deferred.
     */
    public val deferredMaintenanceWindows: List<AwsRedshiftClusterDeferredMaintenanceWindow>? = builder.deferredMaintenanceWindows
    /**
     * Information about the status of the Elastic IP (EIP) address.
     */
    public val elasticIpStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterElasticIpStatus? = builder.elasticIpStatus
    /**
     * The number of nodes that you can use the elastic resize method to resize the cluster to.
     */
    public val elasticResizeNumberOfNodeOptions: kotlin.String? = builder.elasticResizeNumberOfNodeOptions
    /**
     * Indicates whether the data in the cluster is encrypted at rest.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The connection endpoint.
     */
    public val endpoint: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterEndpoint? = builder.endpoint
    /**
     * Indicates whether to create the cluster with enhanced VPC routing enabled.
     */
    public val enhancedVpcRouting: kotlin.Boolean? = builder.enhancedVpcRouting
    /**
     * Indicates when the next snapshot is expected to be taken. The cluster must have a valid snapshot schedule and have backups enabled.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val expectedNextSnapshotScheduleTime: kotlin.String? = builder.expectedNextSnapshotScheduleTime
    /**
     * The status of the next expected snapshot.
     *
     * Valid values: `OnTrack` | `Pending`
     */
    public val expectedNextSnapshotScheduleTimeStatus: kotlin.String? = builder.expectedNextSnapshotScheduleTimeStatus
    /**
     * Information about whether the Amazon Redshift cluster finished applying any changes to hardware security module (HSM) settings that were specified in a modify cluster command.
     */
    public val hsmStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterHsmStatus? = builder.hsmStatus
    /**
     * A list of IAM roles that the cluster can use to access other Amazon Web Services services.
     */
    public val iamRoles: List<AwsRedshiftClusterIamRole>? = builder.iamRoles
    /**
     * The identifier of the KMS encryption key that is used to encrypt data in the cluster.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Information about the logging status of the cluster.
     */
    public val loggingStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus? = builder.loggingStatus
    /**
     * The name of the maintenance track for the cluster.
     */
    public val maintenanceTrackName: kotlin.String? = builder.maintenanceTrackName
    /**
     * The default number of days to retain a manual snapshot.
     *
     * If the value is `-1`, the snapshot is retained indefinitely.
     *
     * This setting doesn't change the retention period of existing snapshots.
     *
     * Valid values: Either `-1` or an integer between 1 and 3,653
     */
    public val manualSnapshotRetentionPeriod: kotlin.Int? = builder.manualSnapshotRetentionPeriod
    /**
     * The master user name for the cluster. This name is used to connect to the database that is specified in as the value of `DBName`.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Indicates the start of the next maintenance window.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val nextMaintenanceWindowStartTime: kotlin.String? = builder.nextMaintenanceWindowStartTime
    /**
     * The node type for the nodes in the cluster.
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The number of compute nodes in the cluster.
     */
    public val numberOfNodes: kotlin.Int? = builder.numberOfNodes
    /**
     * A list of cluster operations that are waiting to start.
     */
    public val pendingActions: List<String>? = builder.pendingActions
    /**
     * A list of changes to the cluster that are currently pending.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues? = builder.pendingModifiedValues
    /**
     * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
     *
     * Format: ` <i><day></i>:HH:MM-<i><day></i>:HH:MM`
     *
     * For the day values, use `mon` | `tue` | `wed` | `thu` | `fri` | `sat` | `sun`
     *
     * For example, `sun:09:32-sun:10:02`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Whether the cluster can be accessed from a public network.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Information about the resize operation for the cluster.
     */
    public val resizeInfo: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterResizeInfo? = builder.resizeInfo
    /**
     * Information about the status of a cluster restore action. Only applies to a cluster that was created by restoring a snapshot.
     */
    public val restoreStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterRestoreStatus? = builder.restoreStatus
    /**
     * A unique identifier for the cluster snapshot schedule.
     */
    public val snapshotScheduleIdentifier: kotlin.String? = builder.snapshotScheduleIdentifier
    /**
     * The current state of the cluster snapshot schedule.
     *
     * Valid values: `MODIFYING` | `ACTIVE` | `FAILED`
     */
    public val snapshotScheduleState: kotlin.String? = builder.snapshotScheduleState
    /**
     * The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId
    /**
     * The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
     */
    public val vpcSecurityGroups: List<AwsRedshiftClusterVpcSecurityGroup>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRedshiftClusterDetails(")
        append("allowVersionUpgrade=$allowVersionUpgrade,")
        append("automatedSnapshotRetentionPeriod=$automatedSnapshotRetentionPeriod,")
        append("availabilityZone=$availabilityZone,")
        append("clusterAvailabilityStatus=$clusterAvailabilityStatus,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("clusterIdentifier=$clusterIdentifier,")
        append("clusterNodes=$clusterNodes,")
        append("clusterParameterGroups=$clusterParameterGroups,")
        append("clusterPublicKey=$clusterPublicKey,")
        append("clusterRevisionNumber=$clusterRevisionNumber,")
        append("clusterSecurityGroups=$clusterSecurityGroups,")
        append("clusterSnapshotCopyStatus=$clusterSnapshotCopyStatus,")
        append("clusterStatus=$clusterStatus,")
        append("clusterSubnetGroupName=$clusterSubnetGroupName,")
        append("clusterVersion=$clusterVersion,")
        append("dbName=$dbName,")
        append("deferredMaintenanceWindows=$deferredMaintenanceWindows,")
        append("elasticIpStatus=$elasticIpStatus,")
        append("elasticResizeNumberOfNodeOptions=$elasticResizeNumberOfNodeOptions,")
        append("encrypted=$encrypted,")
        append("endpoint=$endpoint,")
        append("enhancedVpcRouting=$enhancedVpcRouting,")
        append("expectedNextSnapshotScheduleTime=$expectedNextSnapshotScheduleTime,")
        append("expectedNextSnapshotScheduleTimeStatus=$expectedNextSnapshotScheduleTimeStatus,")
        append("hsmStatus=$hsmStatus,")
        append("iamRoles=$iamRoles,")
        append("kmsKeyId=$kmsKeyId,")
        append("loggingStatus=$loggingStatus,")
        append("maintenanceTrackName=$maintenanceTrackName,")
        append("manualSnapshotRetentionPeriod=$manualSnapshotRetentionPeriod,")
        append("masterUsername=$masterUsername,")
        append("nextMaintenanceWindowStartTime=$nextMaintenanceWindowStartTime,")
        append("nodeType=$nodeType,")
        append("numberOfNodes=$numberOfNodes,")
        append("pendingActions=$pendingActions,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("resizeInfo=$resizeInfo,")
        append("restoreStatus=$restoreStatus,")
        append("snapshotScheduleIdentifier=$snapshotScheduleIdentifier,")
        append("snapshotScheduleState=$snapshotScheduleState,")
        append("vpcId=$vpcId,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowVersionUpgrade?.hashCode() ?: 0
        result = 31 * result + (automatedSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (clusterAvailabilityStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (clusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clusterNodes?.hashCode() ?: 0)
        result = 31 * result + (clusterParameterGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterPublicKey?.hashCode() ?: 0)
        result = 31 * result + (clusterRevisionNumber?.hashCode() ?: 0)
        result = 31 * result + (clusterSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (clusterSnapshotCopyStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterStatus?.hashCode() ?: 0)
        result = 31 * result + (clusterSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (clusterVersion?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (deferredMaintenanceWindows?.hashCode() ?: 0)
        result = 31 * result + (elasticIpStatus?.hashCode() ?: 0)
        result = 31 * result + (elasticResizeNumberOfNodeOptions?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (enhancedVpcRouting?.hashCode() ?: 0)
        result = 31 * result + (expectedNextSnapshotScheduleTime?.hashCode() ?: 0)
        result = 31 * result + (expectedNextSnapshotScheduleTimeStatus?.hashCode() ?: 0)
        result = 31 * result + (hsmStatus?.hashCode() ?: 0)
        result = 31 * result + (iamRoles?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (loggingStatus?.hashCode() ?: 0)
        result = 31 * result + (maintenanceTrackName?.hashCode() ?: 0)
        result = 31 * result + (manualSnapshotRetentionPeriod ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (nextMaintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (numberOfNodes ?: 0)
        result = 31 * result + (pendingActions?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (resizeInfo?.hashCode() ?: 0)
        result = 31 * result + (restoreStatus?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (snapshotScheduleState?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRedshiftClusterDetails

        if (allowVersionUpgrade != other.allowVersionUpgrade) return false
        if (automatedSnapshotRetentionPeriod != other.automatedSnapshotRetentionPeriod) return false
        if (availabilityZone != other.availabilityZone) return false
        if (clusterAvailabilityStatus != other.clusterAvailabilityStatus) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (clusterIdentifier != other.clusterIdentifier) return false
        if (clusterNodes != other.clusterNodes) return false
        if (clusterParameterGroups != other.clusterParameterGroups) return false
        if (clusterPublicKey != other.clusterPublicKey) return false
        if (clusterRevisionNumber != other.clusterRevisionNumber) return false
        if (clusterSecurityGroups != other.clusterSecurityGroups) return false
        if (clusterSnapshotCopyStatus != other.clusterSnapshotCopyStatus) return false
        if (clusterStatus != other.clusterStatus) return false
        if (clusterSubnetGroupName != other.clusterSubnetGroupName) return false
        if (clusterVersion != other.clusterVersion) return false
        if (dbName != other.dbName) return false
        if (deferredMaintenanceWindows != other.deferredMaintenanceWindows) return false
        if (elasticIpStatus != other.elasticIpStatus) return false
        if (elasticResizeNumberOfNodeOptions != other.elasticResizeNumberOfNodeOptions) return false
        if (encrypted != other.encrypted) return false
        if (endpoint != other.endpoint) return false
        if (enhancedVpcRouting != other.enhancedVpcRouting) return false
        if (expectedNextSnapshotScheduleTime != other.expectedNextSnapshotScheduleTime) return false
        if (expectedNextSnapshotScheduleTimeStatus != other.expectedNextSnapshotScheduleTimeStatus) return false
        if (hsmStatus != other.hsmStatus) return false
        if (iamRoles != other.iamRoles) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (loggingStatus != other.loggingStatus) return false
        if (maintenanceTrackName != other.maintenanceTrackName) return false
        if (manualSnapshotRetentionPeriod != other.manualSnapshotRetentionPeriod) return false
        if (masterUsername != other.masterUsername) return false
        if (nextMaintenanceWindowStartTime != other.nextMaintenanceWindowStartTime) return false
        if (nodeType != other.nodeType) return false
        if (numberOfNodes != other.numberOfNodes) return false
        if (pendingActions != other.pendingActions) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (resizeInfo != other.resizeInfo) return false
        if (restoreStatus != other.restoreStatus) return false
        if (snapshotScheduleIdentifier != other.snapshotScheduleIdentifier) return false
        if (snapshotScheduleState != other.snapshotScheduleState) return false
        if (vpcId != other.vpcId) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether major version upgrades are applied automatically to the cluster during the maintenance window.
         */
        public var allowVersionUpgrade: kotlin.Boolean? = null
        /**
         * The number of days that automatic cluster snapshots are retained.
         */
        public var automatedSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The name of the Availability Zone in which the cluster is located.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The availability status of the cluster for queries. Possible values are the following:
         * + `Available` - The cluster is available for queries.
         * + `Unavailable` - The cluster is not available for queries.
         * + `Maintenance` - The cluster is intermittently available for queries due to maintenance activities.
         * + `Modifying` -The cluster is intermittently available for queries due to changes that modify the cluster.
         * + `Failed` - The cluster failed and is not available for queries.
         */
        public var clusterAvailabilityStatus: kotlin.String? = null
        /**
         * Indicates when the cluster was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var clusterCreateTime: kotlin.String? = null
        /**
         * The unique identifier of the cluster.
         */
        public var clusterIdentifier: kotlin.String? = null
        /**
         * The nodes in the cluster.
         */
        public var clusterNodes: List<AwsRedshiftClusterClusterNode>? = null
        /**
         * The list of cluster parameter groups that are associated with this cluster.
         */
        public var clusterParameterGroups: List<AwsRedshiftClusterClusterParameterGroup>? = null
        /**
         * The public key for the cluster.
         */
        public var clusterPublicKey: kotlin.String? = null
        /**
         * The specific revision number of the database in the cluster.
         */
        public var clusterRevisionNumber: kotlin.String? = null
        /**
         * A list of cluster security groups that are associated with the cluster.
         */
        public var clusterSecurityGroups: List<AwsRedshiftClusterClusterSecurityGroup>? = null
        /**
         * Information about the destination Region and retention period for the cross-Region snapshot copy.
         */
        public var clusterSnapshotCopyStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus? = null
        /**
         * The current status of the cluster.
         *
         * Valid values: `available` | `available, prep-for-resize` | `available, resize-cleanup` |` cancelling-resize` | `creating` | `deleting` | `final-snapshot` | `hardware-failure` | `incompatible-hsm` |` incompatible-network` | `incompatible-parameters` | `incompatible-restore` | `modifying` | `paused` | `rebooting` | `renaming` | `resizing` | `rotating-keys` | `storage-full` | `updating-hsm`
         */
        public var clusterStatus: kotlin.String? = null
        /**
         * The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.
         */
        public var clusterSubnetGroupName: kotlin.String? = null
        /**
         * The version ID of the Amazon Redshift engine that runs on the cluster.
         */
        public var clusterVersion: kotlin.String? = null
        /**
         * The name of the initial database that was created when the cluster was created.
         *
         * The same name is returned for the life of the cluster.
         *
         * If an initial database is not specified, a database named `devdev` is created by default.
         */
        public var dbName: kotlin.String? = null
        /**
         * List of time windows during which maintenance was deferred.
         */
        public var deferredMaintenanceWindows: List<AwsRedshiftClusterDeferredMaintenanceWindow>? = null
        /**
         * Information about the status of the Elastic IP (EIP) address.
         */
        public var elasticIpStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterElasticIpStatus? = null
        /**
         * The number of nodes that you can use the elastic resize method to resize the cluster to.
         */
        public var elasticResizeNumberOfNodeOptions: kotlin.String? = null
        /**
         * Indicates whether the data in the cluster is encrypted at rest.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The connection endpoint.
         */
        public var endpoint: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterEndpoint? = null
        /**
         * Indicates whether to create the cluster with enhanced VPC routing enabled.
         */
        public var enhancedVpcRouting: kotlin.Boolean? = null
        /**
         * Indicates when the next snapshot is expected to be taken. The cluster must have a valid snapshot schedule and have backups enabled.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var expectedNextSnapshotScheduleTime: kotlin.String? = null
        /**
         * The status of the next expected snapshot.
         *
         * Valid values: `OnTrack` | `Pending`
         */
        public var expectedNextSnapshotScheduleTimeStatus: kotlin.String? = null
        /**
         * Information about whether the Amazon Redshift cluster finished applying any changes to hardware security module (HSM) settings that were specified in a modify cluster command.
         */
        public var hsmStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterHsmStatus? = null
        /**
         * A list of IAM roles that the cluster can use to access other Amazon Web Services services.
         */
        public var iamRoles: List<AwsRedshiftClusterIamRole>? = null
        /**
         * The identifier of the KMS encryption key that is used to encrypt data in the cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Information about the logging status of the cluster.
         */
        public var loggingStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus? = null
        /**
         * The name of the maintenance track for the cluster.
         */
        public var maintenanceTrackName: kotlin.String? = null
        /**
         * The default number of days to retain a manual snapshot.
         *
         * If the value is `-1`, the snapshot is retained indefinitely.
         *
         * This setting doesn't change the retention period of existing snapshots.
         *
         * Valid values: Either `-1` or an integer between 1 and 3,653
         */
        public var manualSnapshotRetentionPeriod: kotlin.Int? = null
        /**
         * The master user name for the cluster. This name is used to connect to the database that is specified in as the value of `DBName`.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * Indicates the start of the next maintenance window.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var nextMaintenanceWindowStartTime: kotlin.String? = null
        /**
         * The node type for the nodes in the cluster.
         */
        public var nodeType: kotlin.String? = null
        /**
         * The number of compute nodes in the cluster.
         */
        public var numberOfNodes: kotlin.Int? = null
        /**
         * A list of cluster operations that are waiting to start.
         */
        public var pendingActions: List<String>? = null
        /**
         * A list of changes to the cluster that are currently pending.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues? = null
        /**
         * The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.
         *
         * Format: ` <i><day></i>:HH:MM-<i><day></i>:HH:MM`
         *
         * For the day values, use `mon` | `tue` | `wed` | `thu` | `fri` | `sat` | `sun`
         *
         * For example, `sun:09:32-sun:10:02`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Whether the cluster can be accessed from a public network.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Information about the resize operation for the cluster.
         */
        public var resizeInfo: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterResizeInfo? = null
        /**
         * Information about the status of a cluster restore action. Only applies to a cluster that was created by restoring a snapshot.
         */
        public var restoreStatus: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterRestoreStatus? = null
        /**
         * A unique identifier for the cluster snapshot schedule.
         */
        public var snapshotScheduleIdentifier: kotlin.String? = null
        /**
         * The current state of the cluster snapshot schedule.
         *
         * Valid values: `MODIFYING` | `ACTIVE` | `FAILED`
         */
        public var snapshotScheduleState: kotlin.String? = null
        /**
         * The identifier of the VPC that the cluster is in, if the cluster is in a VPC.
         */
        public var vpcId: kotlin.String? = null
        /**
         * The list of VPC security groups that the cluster belongs to, if the cluster is in a VPC.
         */
        public var vpcSecurityGroups: List<AwsRedshiftClusterVpcSecurityGroup>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails) : this() {
            this.allowVersionUpgrade = x.allowVersionUpgrade
            this.automatedSnapshotRetentionPeriod = x.automatedSnapshotRetentionPeriod
            this.availabilityZone = x.availabilityZone
            this.clusterAvailabilityStatus = x.clusterAvailabilityStatus
            this.clusterCreateTime = x.clusterCreateTime
            this.clusterIdentifier = x.clusterIdentifier
            this.clusterNodes = x.clusterNodes
            this.clusterParameterGroups = x.clusterParameterGroups
            this.clusterPublicKey = x.clusterPublicKey
            this.clusterRevisionNumber = x.clusterRevisionNumber
            this.clusterSecurityGroups = x.clusterSecurityGroups
            this.clusterSnapshotCopyStatus = x.clusterSnapshotCopyStatus
            this.clusterStatus = x.clusterStatus
            this.clusterSubnetGroupName = x.clusterSubnetGroupName
            this.clusterVersion = x.clusterVersion
            this.dbName = x.dbName
            this.deferredMaintenanceWindows = x.deferredMaintenanceWindows
            this.elasticIpStatus = x.elasticIpStatus
            this.elasticResizeNumberOfNodeOptions = x.elasticResizeNumberOfNodeOptions
            this.encrypted = x.encrypted
            this.endpoint = x.endpoint
            this.enhancedVpcRouting = x.enhancedVpcRouting
            this.expectedNextSnapshotScheduleTime = x.expectedNextSnapshotScheduleTime
            this.expectedNextSnapshotScheduleTimeStatus = x.expectedNextSnapshotScheduleTimeStatus
            this.hsmStatus = x.hsmStatus
            this.iamRoles = x.iamRoles
            this.kmsKeyId = x.kmsKeyId
            this.loggingStatus = x.loggingStatus
            this.maintenanceTrackName = x.maintenanceTrackName
            this.manualSnapshotRetentionPeriod = x.manualSnapshotRetentionPeriod
            this.masterUsername = x.masterUsername
            this.nextMaintenanceWindowStartTime = x.nextMaintenanceWindowStartTime
            this.nodeType = x.nodeType
            this.numberOfNodes = x.numberOfNodes
            this.pendingActions = x.pendingActions
            this.pendingModifiedValues = x.pendingModifiedValues
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.resizeInfo = x.resizeInfo
            this.restoreStatus = x.restoreStatus
            this.snapshotScheduleIdentifier = x.snapshotScheduleIdentifier
            this.snapshotScheduleState = x.snapshotScheduleState
            this.vpcId = x.vpcId
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails = AwsRedshiftClusterDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus] inside the given [block]
         */
        public fun clusterSnapshotCopyStatus(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.Builder.() -> kotlin.Unit) {
            this.clusterSnapshotCopyStatus = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterClusterSnapshotCopyStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterElasticIpStatus] inside the given [block]
         */
        public fun elasticIpStatus(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterElasticIpStatus.Builder.() -> kotlin.Unit) {
            this.elasticIpStatus = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterElasticIpStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterEndpoint] inside the given [block]
         */
        public fun endpoint(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterEndpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterEndpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterHsmStatus] inside the given [block]
         */
        public fun hsmStatus(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterHsmStatus.Builder.() -> kotlin.Unit) {
            this.hsmStatus = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterHsmStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus] inside the given [block]
         */
        public fun loggingStatus(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus.Builder.() -> kotlin.Unit) {
            this.loggingStatus = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterLoggingStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterPendingModifiedValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterResizeInfo] inside the given [block]
         */
        public fun resizeInfo(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterResizeInfo.Builder.() -> kotlin.Unit) {
            this.resizeInfo = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterResizeInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterRestoreStatus] inside the given [block]
         */
        public fun restoreStatus(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterRestoreStatus.Builder.() -> kotlin.Unit) {
            this.restoreStatus = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterRestoreStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
