// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about an Amazon RDS event notification subscription. The subscription allows Amazon RDS to post events to an SNS topic.
 */
public class AwsRdsEventSubscriptionDetails private constructor(builder: Builder) {
    /**
     * The identifier of the account that is associated with the event notification subscription.
     */
    public val custSubscriptionId: kotlin.String? = builder.custSubscriptionId
    /**
     * The identifier of the event notification subscription.
     */
    public val customerAwsId: kotlin.String? = builder.customerAwsId
    /**
     * Whether the event notification subscription is enabled.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * The list of event categories for the event notification subscription.
     */
    public val eventCategoriesList: List<String>? = builder.eventCategoriesList
    /**
     * The ARN of the event notification subscription.
     */
    public val eventSubscriptionArn: kotlin.String? = builder.eventSubscriptionArn
    /**
     * The ARN of the SNS topic to post the event notifications to.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * A list of source identifiers for the event notification subscription.
     */
    public val sourceIdsList: List<String>? = builder.sourceIdsList
    /**
     * The source type for the event notification subscription.
     */
    public val sourceType: kotlin.String? = builder.sourceType
    /**
     * The status of the event notification subscription.
     *
     * Valid values: `creating` | `modifying` | `deleting` | `active` | `no-permission` | `topic-not-exist`
     */
    public val status: kotlin.String? = builder.status
    /**
     * The datetime when the event notification subscription was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val subscriptionCreationTime: kotlin.String? = builder.subscriptionCreationTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRdsEventSubscriptionDetails(")
        append("custSubscriptionId=$custSubscriptionId,")
        append("customerAwsId=$customerAwsId,")
        append("enabled=$enabled,")
        append("eventCategoriesList=$eventCategoriesList,")
        append("eventSubscriptionArn=$eventSubscriptionArn,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIdsList=$sourceIdsList,")
        append("sourceType=$sourceType,")
        append("status=$status,")
        append("subscriptionCreationTime=$subscriptionCreationTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = custSubscriptionId?.hashCode() ?: 0
        result = 31 * result + (customerAwsId?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (eventCategoriesList?.hashCode() ?: 0)
        result = 31 * result + (eventSubscriptionArn?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIdsList?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subscriptionCreationTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRdsEventSubscriptionDetails

        if (custSubscriptionId != other.custSubscriptionId) return false
        if (customerAwsId != other.customerAwsId) return false
        if (enabled != other.enabled) return false
        if (eventCategoriesList != other.eventCategoriesList) return false
        if (eventSubscriptionArn != other.eventSubscriptionArn) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIdsList != other.sourceIdsList) return false
        if (sourceType != other.sourceType) return false
        if (status != other.status) return false
        if (subscriptionCreationTime != other.subscriptionCreationTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the account that is associated with the event notification subscription.
         */
        public var custSubscriptionId: kotlin.String? = null
        /**
         * The identifier of the event notification subscription.
         */
        public var customerAwsId: kotlin.String? = null
        /**
         * Whether the event notification subscription is enabled.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * The list of event categories for the event notification subscription.
         */
        public var eventCategoriesList: List<String>? = null
        /**
         * The ARN of the event notification subscription.
         */
        public var eventSubscriptionArn: kotlin.String? = null
        /**
         * The ARN of the SNS topic to post the event notifications to.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * A list of source identifiers for the event notification subscription.
         */
        public var sourceIdsList: List<String>? = null
        /**
         * The source type for the event notification subscription.
         */
        public var sourceType: kotlin.String? = null
        /**
         * The status of the event notification subscription.
         *
         * Valid values: `creating` | `modifying` | `deleting` | `active` | `no-permission` | `topic-not-exist`
         */
        public var status: kotlin.String? = null
        /**
         * The datetime when the event notification subscription was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var subscriptionCreationTime: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails) : this() {
            this.custSubscriptionId = x.custSubscriptionId
            this.customerAwsId = x.customerAwsId
            this.enabled = x.enabled
            this.eventCategoriesList = x.eventCategoriesList
            this.eventSubscriptionArn = x.eventSubscriptionArn
            this.snsTopicArn = x.snsTopicArn
            this.sourceIdsList = x.sourceIdsList
            this.sourceType = x.sourceType
            this.status = x.status
            this.subscriptionCreationTime = x.subscriptionCreationTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails = AwsRdsEventSubscriptionDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
