// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains the details of an Amazon RDS DB instance.
 */
public class AwsRdsDbInstanceDetails private constructor(builder: Builder) {
    /**
     * The amount of storage (in gigabytes) to initially allocate for the DB instance.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The IAM roles associated with the DB instance.
     */
    public val associatedRoles: List<AwsRdsDbInstanceAssociatedRole>? = builder.associatedRoles
    /**
     * Indicates whether minor version patches are applied automatically.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Availability Zone where the DB instance will be created.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The number of days for which to retain automated backups.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The identifier of the CA certificate for this DB instance.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * The name of the character set that this DB instance is associated with.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * Whether to copy resource tags to snapshots of the DB instance.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * Contains the name of the compute and memory capacity class of the DB instance.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.
     */
    public val dbInstancePort: kotlin.Int? = builder.dbInstancePort
    /**
     * The current status of the DB instance.
     */
    public val dbInstanceStatus: kotlin.String? = builder.dbInstanceStatus
    /**
     * The meaning of this parameter differs according to the database engine you use.
     *
     * **MySQL, MariaDB, SQL Server, PostgreSQL**
     *
     * Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.
     *
     * **Oracle**
     *
     * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * A list of the DB parameter groups to assign to the DB instance.
     */
    public val dbParameterGroups: List<AwsRdsDbParameterGroup>? = builder.dbParameterGroups
    /**
     * A list of the DB security groups to assign to the DB instance.
     */
    public val dbSecurityGroups: List<String>? = builder.dbSecurityGroups
    /**
     * Information about the subnet group that is associated with the DB instance.
     */
    public val dbSubnetGroup: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSubnetGroup? = builder.dbSubnetGroup
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in CloudTrail log entries whenever the KMS key for the DB instance is accessed.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * Indicates whether the DB instance has deletion protection enabled.
     *
     * When deletion protection is enabled, the database cannot be deleted.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory domain membership records associated with the DB instance.
     */
    public val domainMemberships: List<AwsRdsDbDomainMembership>? = builder.domainMemberships
    /**
     * A list of log types that this DB instance is configured to export to CloudWatch Logs.
     */
    public val enabledCloudWatchLogsExports: List<String>? = builder.enabledCloudWatchLogsExports
    /**
     * Specifies the connection endpoint.
     */
    public val endpoint: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint? = builder.endpoint
    /**
     * Provides the name of the database engine to use for this DB instance.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Indicates the database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring metrics data for the DB instance.
     */
    public val enhancedMonitoringResourceArn: kotlin.String? = builder.enhancedMonitoringResourceArn
    /**
     * True if mapping of IAM accounts to database accounts is enabled, and otherwise false.
     *
     * IAM database authentication can be enabled for the following database engines.
     * + For MySQL 5.6, minor version 5.6.34 or higher
     * + For MySQL 5.7, minor version 5.7.16 or higher
     * + Aurora 5.6 or higher
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * Indicates when the DB instance was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val instanceCreateTime: kotlin.String? = builder.instanceCreateTime
    /**
     * Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * If `StorageEncrypted` is true, the KMS key identifier for the encrypted DB instance.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val latestRestorableTime: kotlin.String? = builder.latestRestorableTime
    /**
     * License model information for this DB instance.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Specifies the connection endpoint.
     */
    public val listenerEndpoint: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint? = builder.listenerEndpoint
    /**
     * The master user name of the DB instance.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
     */
    public val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * The interval, in seconds, between points when enhanced monitoring metrics are collected for the DB instance.
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring metrics to CloudWatch Logs.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Whether the DB instance is a multiple Availability Zone deployment.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The list of option group memberships for this DB instance.
     */
    public val optionGroupMemberships: List<AwsRdsDbOptionGroupMembership>? = builder.optionGroupMemberships
    /**
     * Changes to the DB instance that are currently pending.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbPendingModifiedValues? = builder.pendingModifiedValues
    /**
     * Indicates whether Performance Insights is enabled for the DB instance.
     */
    public val performanceInsightsEnabled: kotlin.Boolean? = builder.performanceInsightsEnabled
    /**
     * The identifier of the KMS key used to encrypt the Performance Insights data.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data.
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The range of time each day when automated backups are created, if automated backups are enabled.
     *
     * Uses the format `HH:MM-HH:MM`. For example, `04:52-05:22`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     *
     * Uses the format `<day>:HH:MM-<day>:HH:MM`.
     *
     * For the day values, use `mon`|`tue`|`wed`|`thu`|`fri`|`sat`|`sun`.
     *
     * For example, `sun:09:32-sun:10:02`.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    public val processorFeatures: List<AwsRdsDbProcessorFeature>? = builder.processorFeatures
    /**
     * The order in which to promote an Aurora replica to the primary instance after a failure of the existing primary instance.
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * Specifies the accessibility options for the DB instance.
     *
     * A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address.
     *
     * A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.
     */
    public val readReplicaDbClusterIdentifiers: List<String>? = builder.readReplicaDbClusterIdentifiers
    /**
     * List of identifiers of the read replicas associated with this DB instance.
     */
    public val readReplicaDbInstanceIdentifiers: List<String>? = builder.readReplicaDbInstanceIdentifiers
    /**
     * If this DB instance is a read replica, contains the identifier of the source DB instance.
     */
    public val readReplicaSourceDbInstanceIdentifier: kotlin.String? = builder.readReplicaSourceDbInstanceIdentifier
    /**
     * For a DB instance with multi-Availability Zone support, the name of the secondary Availability Zone.
     */
    public val secondaryAvailabilityZone: kotlin.String? = builder.secondaryAvailabilityZone
    /**
     * The status of a read replica. If the instance isn't a read replica, this is empty.
     */
    public val statusInfos: List<AwsRdsDbStatusInfo>? = builder.statusInfos
    /**
     * Specifies whether the DB instance is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * The storage type for the DB instance.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The ARN from the key store with which the instance is associated for TDE encryption.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The time zone of the DB instance.
     */
    public val timezone: kotlin.String? = builder.timezone
    /**
     * A list of VPC security groups that the DB instance belongs to.
     */
    public val vpcSecurityGroups: List<AwsRdsDbInstanceVpcSecurityGroup>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsRdsDbInstanceDetails(")
        append("allocatedStorage=$allocatedStorage,")
        append("associatedRoles=$associatedRoles,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbInstancePort=$dbInstancePort,")
        append("dbInstanceStatus=$dbInstanceStatus,")
        append("dbName=$dbName,")
        append("dbParameterGroups=$dbParameterGroups,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("dbiResourceId=$dbiResourceId,")
        append("deletionProtection=$deletionProtection,")
        append("domainMemberships=$domainMemberships,")
        append("enabledCloudWatchLogsExports=$enabledCloudWatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("enhancedMonitoringResourceArn=$enhancedMonitoringResourceArn,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("instanceCreateTime=$instanceCreateTime,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("licenseModel=$licenseModel,")
        append("listenerEndpoint=$listenerEndpoint,")
        append("masterUsername=$masterUsername,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("optionGroupMemberships=$optionGroupMemberships,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("performanceInsightsEnabled=$performanceInsightsEnabled,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("processorFeatures=$processorFeatures,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("readReplicaDbClusterIdentifiers=$readReplicaDbClusterIdentifiers,")
        append("readReplicaDbInstanceIdentifiers=$readReplicaDbInstanceIdentifiers,")
        append("readReplicaSourceDbInstanceIdentifier=$readReplicaSourceDbInstanceIdentifier,")
        append("secondaryAvailabilityZone=$secondaryAvailabilityZone,")
        append("statusInfos=$statusInfos,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("timezone=$timezone,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (associatedRoles?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstancePort ?: 0)
        result = 31 * result + (dbInstanceStatus?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domainMemberships?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudWatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (enhancedMonitoringResourceArn?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (instanceCreateTime?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (listenerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (optionGroupMemberships?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsEnabled?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (readReplicaDbClusterIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readReplicaDbInstanceIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readReplicaSourceDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (secondaryAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (statusInfos?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsRdsDbInstanceDetails

        if (allocatedStorage != other.allocatedStorage) return false
        if (associatedRoles != other.associatedRoles) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbInstancePort != other.dbInstancePort) return false
        if (dbInstanceStatus != other.dbInstanceStatus) return false
        if (dbName != other.dbName) return false
        if (dbParameterGroups != other.dbParameterGroups) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domainMemberships != other.domainMemberships) return false
        if (enabledCloudWatchLogsExports != other.enabledCloudWatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (enhancedMonitoringResourceArn != other.enhancedMonitoringResourceArn) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (instanceCreateTime != other.instanceCreateTime) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (licenseModel != other.licenseModel) return false
        if (listenerEndpoint != other.listenerEndpoint) return false
        if (masterUsername != other.masterUsername) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (optionGroupMemberships != other.optionGroupMemberships) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (performanceInsightsEnabled != other.performanceInsightsEnabled) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (processorFeatures != other.processorFeatures) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (readReplicaDbClusterIdentifiers != other.readReplicaDbClusterIdentifiers) return false
        if (readReplicaDbInstanceIdentifiers != other.readReplicaDbInstanceIdentifiers) return false
        if (readReplicaSourceDbInstanceIdentifier != other.readReplicaSourceDbInstanceIdentifier) return false
        if (secondaryAvailabilityZone != other.secondaryAvailabilityZone) return false
        if (statusInfos != other.statusInfos) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (timezone != other.timezone) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of storage (in gigabytes) to initially allocate for the DB instance.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The IAM roles associated with the DB instance.
         */
        public var associatedRoles: List<AwsRdsDbInstanceAssociatedRole>? = null
        /**
         * Indicates whether minor version patches are applied automatically.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Availability Zone where the DB instance will be created.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The number of days for which to retain automated backups.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The identifier of the CA certificate for this DB instance.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * The name of the character set that this DB instance is associated with.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * Whether to copy resource tags to snapshots of the DB instance.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * Contains the name of the compute and memory capacity class of the DB instance.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.
         */
        public var dbInstancePort: kotlin.Int? = null
        /**
         * The current status of the DB instance.
         */
        public var dbInstanceStatus: kotlin.String? = null
        /**
         * The meaning of this parameter differs according to the database engine you use.
         *
         * **MySQL, MariaDB, SQL Server, PostgreSQL**
         *
         * Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.
         *
         * **Oracle**
         *
         * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.
         */
        public var dbName: kotlin.String? = null
        /**
         * A list of the DB parameter groups to assign to the DB instance.
         */
        public var dbParameterGroups: List<AwsRdsDbParameterGroup>? = null
        /**
         * A list of the DB security groups to assign to the DB instance.
         */
        public var dbSecurityGroups: List<String>? = null
        /**
         * Information about the subnet group that is associated with the DB instance.
         */
        public var dbSubnetGroup: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSubnetGroup? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in CloudTrail log entries whenever the KMS key for the DB instance is accessed.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * Indicates whether the DB instance has deletion protection enabled.
         *
         * When deletion protection is enabled, the database cannot be deleted.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory domain membership records associated with the DB instance.
         */
        public var domainMemberships: List<AwsRdsDbDomainMembership>? = null
        /**
         * A list of log types that this DB instance is configured to export to CloudWatch Logs.
         */
        public var enabledCloudWatchLogsExports: List<String>? = null
        /**
         * Specifies the connection endpoint.
         */
        public var endpoint: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint? = null
        /**
         * Provides the name of the database engine to use for this DB instance.
         */
        public var engine: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring metrics data for the DB instance.
         */
        public var enhancedMonitoringResourceArn: kotlin.String? = null
        /**
         * True if mapping of IAM accounts to database accounts is enabled, and otherwise false.
         *
         * IAM database authentication can be enabled for the following database engines.
         * + For MySQL 5.6, minor version 5.6.34 or higher
         * + For MySQL 5.7, minor version 5.7.16 or higher
         * + Aurora 5.6 or higher
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * Indicates when the DB instance was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var instanceCreateTime: kotlin.String? = null
        /**
         * Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
         */
        public var iops: kotlin.Int? = null
        /**
         * If `StorageEncrypted` is true, the KMS key identifier for the encrypted DB instance.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var latestRestorableTime: kotlin.String? = null
        /**
         * License model information for this DB instance.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Specifies the connection endpoint.
         */
        public var listenerEndpoint: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint? = null
        /**
         * The master user name of the DB instance.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
         */
        public var maxAllocatedStorage: kotlin.Int? = null
        /**
         * The interval, in seconds, between points when enhanced monitoring metrics are collected for the DB instance.
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring metrics to CloudWatch Logs.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Whether the DB instance is a multiple Availability Zone deployment.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The list of option group memberships for this DB instance.
         */
        public var optionGroupMemberships: List<AwsRdsDbOptionGroupMembership>? = null
        /**
         * Changes to the DB instance that are currently pending.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbPendingModifiedValues? = null
        /**
         * Indicates whether Performance Insights is enabled for the DB instance.
         */
        public var performanceInsightsEnabled: kotlin.Boolean? = null
        /**
         * The identifier of the KMS key used to encrypt the Performance Insights data.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data.
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The range of time each day when automated backups are created, if automated backups are enabled.
         *
         * Uses the format `HH:MM-HH:MM`. For example, `04:52-05:22`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *
         * Uses the format `<day>:HH:MM-<day>:HH:MM`.
         *
         * For the day values, use `mon`|`tue`|`wed`|`thu`|`fri`|`sat`|`sun`.
         *
         * For example, `sun:09:32-sun:10:02`.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         */
        public var processorFeatures: List<AwsRdsDbProcessorFeature>? = null
        /**
         * The order in which to promote an Aurora replica to the primary instance after a failure of the existing primary instance.
         */
        public var promotionTier: kotlin.Int? = null
        /**
         * Specifies the accessibility options for the DB instance.
         *
         * A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a public IP address.
         *
         * A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.
         */
        public var readReplicaDbClusterIdentifiers: List<String>? = null
        /**
         * List of identifiers of the read replicas associated with this DB instance.
         */
        public var readReplicaDbInstanceIdentifiers: List<String>? = null
        /**
         * If this DB instance is a read replica, contains the identifier of the source DB instance.
         */
        public var readReplicaSourceDbInstanceIdentifier: kotlin.String? = null
        /**
         * For a DB instance with multi-Availability Zone support, the name of the secondary Availability Zone.
         */
        public var secondaryAvailabilityZone: kotlin.String? = null
        /**
         * The status of a read replica. If the instance isn't a read replica, this is empty.
         */
        public var statusInfos: List<AwsRdsDbStatusInfo>? = null
        /**
         * Specifies whether the DB instance is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * The storage type for the DB instance.
         */
        public var storageType: kotlin.String? = null
        /**
         * The ARN from the key store with which the instance is associated for TDE encryption.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The time zone of the DB instance.
         */
        public var timezone: kotlin.String? = null
        /**
         * A list of VPC security groups that the DB instance belongs to.
         */
        public var vpcSecurityGroups: List<AwsRdsDbInstanceVpcSecurityGroup>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.associatedRoles = x.associatedRoles
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbInstancePort = x.dbInstancePort
            this.dbInstanceStatus = x.dbInstanceStatus
            this.dbName = x.dbName
            this.dbParameterGroups = x.dbParameterGroups
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroup = x.dbSubnetGroup
            this.dbiResourceId = x.dbiResourceId
            this.deletionProtection = x.deletionProtection
            this.domainMemberships = x.domainMemberships
            this.enabledCloudWatchLogsExports = x.enabledCloudWatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.enhancedMonitoringResourceArn = x.enhancedMonitoringResourceArn
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.instanceCreateTime = x.instanceCreateTime
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.licenseModel = x.licenseModel
            this.listenerEndpoint = x.listenerEndpoint
            this.masterUsername = x.masterUsername
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.optionGroupMemberships = x.optionGroupMemberships
            this.pendingModifiedValues = x.pendingModifiedValues
            this.performanceInsightsEnabled = x.performanceInsightsEnabled
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.processorFeatures = x.processorFeatures
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.readReplicaDbClusterIdentifiers = x.readReplicaDbClusterIdentifiers
            this.readReplicaDbInstanceIdentifiers = x.readReplicaDbInstanceIdentifiers
            this.readReplicaSourceDbInstanceIdentifier = x.readReplicaSourceDbInstanceIdentifier
            this.secondaryAvailabilityZone = x.secondaryAvailabilityZone
            this.statusInfos = x.statusInfos
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tdeCredentialArn = x.tdeCredentialArn
            this.timezone = x.timezone
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails = AwsRdsDbInstanceDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSubnetGroup] inside the given [block]
         */
        public fun dbSubnetGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSubnetGroup.Builder.() -> kotlin.Unit) {
            this.dbSubnetGroup = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSubnetGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint] inside the given [block]
         */
        public fun endpoint(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint.Builder.() -> kotlin.Unit) {
            this.endpoint = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint] inside the given [block]
         */
        public fun listenerEndpoint(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint.Builder.() -> kotlin.Unit) {
            this.listenerEndpoint = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceEndpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbPendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbPendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbPendingModifiedValues.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
