// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about the configuration of an OpenSearch cluster.
 */
public class AwsOpenSearchServiceDomainClusterConfigDetails private constructor(builder: Builder) {
    /**
     * The number of instances to use for the master node. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
     */
    public val dedicatedMasterCount: kotlin.Int? = builder.dedicatedMasterCount
    /**
     * Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.
     */
    public val dedicatedMasterEnabled: kotlin.Boolean? = builder.dedicatedMasterEnabled
    /**
     * The hardware configuration of the computer that hosts the dedicated master node.
     *
     * If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
     */
    public val dedicatedMasterType: kotlin.String? = builder.dedicatedMasterType
    /**
     * The number of data nodes to use in the OpenSearch domain.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The instance type for your data nodes.
     *
     * For a list of valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) in the *Amazon OpenSearch Service Developer Guide*.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * The number of UltraWarm instances.
     */
    public val warmCount: kotlin.Int? = builder.warmCount
    /**
     * Whether UltraWarm is enabled.
     */
    public val warmEnabled: kotlin.Boolean? = builder.warmEnabled
    /**
     * The type of UltraWarm instance.
     */
    public val warmType: kotlin.String? = builder.warmType
    /**
     * Configuration options for zone awareness. Provided if `ZoneAwarenessEnabled` is `true`.
     */
    public val zoneAwarenessConfig: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails? = builder.zoneAwarenessConfig
    /**
     * Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.
     */
    public val zoneAwarenessEnabled: kotlin.Boolean? = builder.zoneAwarenessEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsOpenSearchServiceDomainClusterConfigDetails(")
        append("dedicatedMasterCount=$dedicatedMasterCount,")
        append("dedicatedMasterEnabled=$dedicatedMasterEnabled,")
        append("dedicatedMasterType=$dedicatedMasterType,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("warmCount=$warmCount,")
        append("warmEnabled=$warmEnabled,")
        append("warmType=$warmType,")
        append("zoneAwarenessConfig=$zoneAwarenessConfig,")
        append("zoneAwarenessEnabled=$zoneAwarenessEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dedicatedMasterCount ?: 0
        result = 31 * result + (dedicatedMasterEnabled?.hashCode() ?: 0)
        result = 31 * result + (dedicatedMasterType?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (warmCount ?: 0)
        result = 31 * result + (warmEnabled?.hashCode() ?: 0)
        result = 31 * result + (warmType?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessConfig?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessEnabled?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsOpenSearchServiceDomainClusterConfigDetails

        if (dedicatedMasterCount != other.dedicatedMasterCount) return false
        if (dedicatedMasterEnabled != other.dedicatedMasterEnabled) return false
        if (dedicatedMasterType != other.dedicatedMasterType) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (warmCount != other.warmCount) return false
        if (warmEnabled != other.warmEnabled) return false
        if (warmType != other.warmType) return false
        if (zoneAwarenessConfig != other.zoneAwarenessConfig) return false
        if (zoneAwarenessEnabled != other.zoneAwarenessEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of instances to use for the master node. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
         */
        public var dedicatedMasterCount: kotlin.Int? = null
        /**
         * Whether to use a dedicated master node for the OpenSearch domain. A dedicated master node performs cluster management tasks, but does not hold data or respond to data upload requests.
         */
        public var dedicatedMasterEnabled: kotlin.Boolean? = null
        /**
         * The hardware configuration of the computer that hosts the dedicated master node.
         *
         * If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
         */
        public var dedicatedMasterType: kotlin.String? = null
        /**
         * The number of data nodes to use in the OpenSearch domain.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The instance type for your data nodes.
         *
         * For a list of valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) in the *Amazon OpenSearch Service Developer Guide*.
         */
        public var instanceType: kotlin.String? = null
        /**
         * The number of UltraWarm instances.
         */
        public var warmCount: kotlin.Int? = null
        /**
         * Whether UltraWarm is enabled.
         */
        public var warmEnabled: kotlin.Boolean? = null
        /**
         * The type of UltraWarm instance.
         */
        public var warmType: kotlin.String? = null
        /**
         * Configuration options for zone awareness. Provided if `ZoneAwarenessEnabled` is `true`.
         */
        public var zoneAwarenessConfig: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails? = null
        /**
         * Whether to enable zone awareness for the OpenSearch domain. When zone awareness is enabled, OpenSearch Service allocates the cluster's nodes and replica index shards across Availability Zones (AZs) in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.
         */
        public var zoneAwarenessEnabled: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails) : this() {
            this.dedicatedMasterCount = x.dedicatedMasterCount
            this.dedicatedMasterEnabled = x.dedicatedMasterEnabled
            this.dedicatedMasterType = x.dedicatedMasterType
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.warmCount = x.warmCount
            this.warmEnabled = x.warmEnabled
            this.warmType = x.warmType
            this.zoneAwarenessConfig = x.zoneAwarenessConfig
            this.zoneAwarenessEnabled = x.zoneAwarenessEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails = AwsOpenSearchServiceDomainClusterConfigDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails] inside the given [block]
         */
        public fun zoneAwarenessConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.Builder.() -> kotlin.Unit) {
            this.zoneAwarenessConfig = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigZoneAwarenessConfigDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
