// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains metadata about an KMS key.
 */
public class AwsKmsKeyDetails private constructor(builder: Builder) {
    /**
     * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Indicates when the KMS key was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val creationDate: kotlin.Double? = builder.creationDate
    /**
     * A description of the KMS key.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The globally unique identifier for the KMS key.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed.
     */
    public val keyManager: kotlin.String? = builder.keyManager
    /**
     * Whether the key has key rotation enabled.
     */
    public val keyRotationStatus: kotlin.Boolean? = builder.keyRotationStatus
    /**
     * The state of the KMS key. Valid values are as follows:
     * + `Disabled`
     * + `Enabled`
     * + `PendingDeletion`
     * + `PendingImport`
     * + `Unavailable`
     */
    public val keyState: kotlin.String? = builder.keyState
    /**
     * The source of the KMS key material.
     *
     * When this value is `AWS_KMS`, KMS created the key material.
     *
     * When this value is `EXTERNAL`, the key material was imported from your existing key management infrastructure or the KMS key lacks key material.
     *
     * When this value is `AWS_CLOUDHSM`, the key material was created in the CloudHSM cluster associated with a custom key store.
     */
    public val origin: kotlin.String? = builder.origin

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsKmsKeyDetails(")
        append("awsAccountId=$awsAccountId,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("keyId=$keyId,")
        append("keyManager=$keyManager,")
        append("keyRotationStatus=$keyRotationStatus,")
        append("keyState=$keyState,")
        append("origin=$origin")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keyManager?.hashCode() ?: 0)
        result = 31 * result + (keyRotationStatus?.hashCode() ?: 0)
        result = 31 * result + (keyState?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsKmsKeyDetails

        if (awsAccountId != other.awsAccountId) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (keyId != other.keyId) return false
        if (keyManager != other.keyManager) return false
        if (keyRotationStatus != other.keyRotationStatus) return false
        if (keyState != other.keyState) return false
        if (origin != other.origin) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The twelve-digit account ID of the Amazon Web Services account that owns the KMS key.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * Indicates when the KMS key was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var creationDate: kotlin.Double? = null
        /**
         * A description of the KMS key.
         */
        public var description: kotlin.String? = null
        /**
         * The globally unique identifier for the KMS key.
         */
        public var keyId: kotlin.String? = null
        /**
         * The manager of the KMS key. KMS keys in your Amazon Web Services account are either customer managed or Amazon Web Services managed.
         */
        public var keyManager: kotlin.String? = null
        /**
         * Whether the key has key rotation enabled.
         */
        public var keyRotationStatus: kotlin.Boolean? = null
        /**
         * The state of the KMS key. Valid values are as follows:
         * + `Disabled`
         * + `Enabled`
         * + `PendingDeletion`
         * + `PendingImport`
         * + `Unavailable`
         */
        public var keyState: kotlin.String? = null
        /**
         * The source of the KMS key material.
         *
         * When this value is `AWS_KMS`, KMS created the key material.
         *
         * When this value is `EXTERNAL`, the key material was imported from your existing key management infrastructure or the KMS key lacks key material.
         *
         * When this value is `AWS_CLOUDHSM`, the key material was created in the CloudHSM cluster associated with a custom key store.
         */
        public var origin: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails) : this() {
            this.awsAccountId = x.awsAccountId
            this.creationDate = x.creationDate
            this.description = x.description
            this.keyId = x.keyId
            this.keyManager = x.keyManager
            this.keyRotationStatus = x.keyRotationStatus
            this.keyState = x.keyState
            this.origin = x.origin
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails = AwsKmsKeyDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
