// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Represents an IAM permissions policy.
 */
public class AwsIamPolicyDetails private constructor(builder: Builder) {
    /**
     * The number of users, groups, and roles that the policy is attached to.
     */
    public val attachmentCount: kotlin.Int? = builder.attachmentCount
    /**
     * When the policy was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createDate: kotlin.String? = builder.createDate
    /**
     * The identifier of the default version of the policy.
     */
    public val defaultVersionId: kotlin.String? = builder.defaultVersionId
    /**
     * A description of the policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether the policy can be attached to a user, group, or role.
     */
    public val isAttachable: kotlin.Boolean? = builder.isAttachable
    /**
     * The path to the policy.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The number of users and roles that use the policy to set the permissions boundary.
     */
    public val permissionsBoundaryUsageCount: kotlin.Int? = builder.permissionsBoundaryUsageCount
    /**
     * The unique identifier of the policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The name of the policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * List of versions of the policy.
     */
    public val policyVersionList: List<AwsIamPolicyVersion>? = builder.policyVersionList
    /**
     * When the policy was most recently updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val updateDate: kotlin.String? = builder.updateDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsIamPolicyDetails(")
        append("attachmentCount=$attachmentCount,")
        append("createDate=$createDate,")
        append("defaultVersionId=$defaultVersionId,")
        append("description=$description,")
        append("isAttachable=$isAttachable,")
        append("path=$path,")
        append("permissionsBoundaryUsageCount=$permissionsBoundaryUsageCount,")
        append("policyId=$policyId,")
        append("policyName=$policyName,")
        append("policyVersionList=$policyVersionList,")
        append("updateDate=$updateDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentCount ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (defaultVersionId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isAttachable?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundaryUsageCount ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyVersionList?.hashCode() ?: 0)
        result = 31 * result + (updateDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsIamPolicyDetails

        if (attachmentCount != other.attachmentCount) return false
        if (createDate != other.createDate) return false
        if (defaultVersionId != other.defaultVersionId) return false
        if (description != other.description) return false
        if (isAttachable != other.isAttachable) return false
        if (path != other.path) return false
        if (permissionsBoundaryUsageCount != other.permissionsBoundaryUsageCount) return false
        if (policyId != other.policyId) return false
        if (policyName != other.policyName) return false
        if (policyVersionList != other.policyVersionList) return false
        if (updateDate != other.updateDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of users, groups, and roles that the policy is attached to.
         */
        public var attachmentCount: kotlin.Int? = null
        /**
         * When the policy was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createDate: kotlin.String? = null
        /**
         * The identifier of the default version of the policy.
         */
        public var defaultVersionId: kotlin.String? = null
        /**
         * A description of the policy.
         */
        public var description: kotlin.String? = null
        /**
         * Whether the policy can be attached to a user, group, or role.
         */
        public var isAttachable: kotlin.Boolean? = null
        /**
         * The path to the policy.
         */
        public var path: kotlin.String? = null
        /**
         * The number of users and roles that use the policy to set the permissions boundary.
         */
        public var permissionsBoundaryUsageCount: kotlin.Int? = null
        /**
         * The unique identifier of the policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * The name of the policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * List of versions of the policy.
         */
        public var policyVersionList: List<AwsIamPolicyVersion>? = null
        /**
         * When the policy was most recently updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var updateDate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails) : this() {
            this.attachmentCount = x.attachmentCount
            this.createDate = x.createDate
            this.defaultVersionId = x.defaultVersionId
            this.description = x.description
            this.isAttachable = x.isAttachable
            this.path = x.path
            this.permissionsBoundaryUsageCount = x.permissionsBoundaryUsageCount
            this.policyId = x.policyId
            this.policyName = x.policyName
            this.policyVersionList = x.policyVersionList
            this.updateDate = x.updateDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails = AwsIamPolicyDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
