// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains details about an IAM group.
 */
public class AwsIamGroupDetails private constructor(builder: Builder) {
    /**
     * A list of the managed policies that are attached to the IAM group.
     */
    public val attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = builder.attachedManagedPolicies
    /**
     * Indicates when the IAM group was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createDate: kotlin.String? = builder.createDate
    /**
     * The identifier of the IAM group.
     */
    public val groupId: kotlin.String? = builder.groupId
    /**
     * The name of the IAM group.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The list of inline policies that are embedded in the group.
     */
    public val groupPolicyList: List<AwsIamGroupPolicy>? = builder.groupPolicyList
    /**
     * The path to the group.
     */
    public val path: kotlin.String? = builder.path

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsIamGroupDetails(")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("groupPolicyList=$groupPolicyList,")
        append("path=$path")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachedManagedPolicies?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (groupPolicyList?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsIamGroupDetails

        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (groupPolicyList != other.groupPolicyList) return false
        if (path != other.path) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of the managed policies that are attached to the IAM group.
         */
        public var attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = null
        /**
         * Indicates when the IAM group was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createDate: kotlin.String? = null
        /**
         * The identifier of the IAM group.
         */
        public var groupId: kotlin.String? = null
        /**
         * The name of the IAM group.
         */
        public var groupName: kotlin.String? = null
        /**
         * The list of inline policies that are embedded in the group.
         */
        public var groupPolicyList: List<AwsIamGroupPolicy>? = null
        /**
         * The path to the group.
         */
        public var path: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails) : this() {
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.groupPolicyList = x.groupPolicyList
            this.path = x.path
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails = AwsIamGroupDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
