// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about the health checks that are conducted on the load balancer.
 */
public class AwsElbLoadBalancerHealthCheck private constructor(builder: Builder) {
    /**
     * The number of consecutive health check successes required before the instance is moved to the Healthy state.
     */
    public val healthyThreshold: kotlin.Int? = builder.healthyThreshold
    /**
     * The approximate interval, in seconds, between health checks of an individual instance.
     */
    public val interval: kotlin.Int? = builder.interval
    /**
     * The instance that is being checked. The target specifies the protocol and port. The available protocols are TCP, SSL, HTTP, and HTTPS. The range of valid ports is 1 through 65535.
     *
     * For the HTTP and HTTPS protocols, the target also specifies the ping path.
     *
     * For the TCP protocol, the target is specified as `TCP: <i><port></i> `.
     *
     * For the SSL protocol, the target is specified as `SSL.<i><port></i> `.
     *
     * For the HTTP and HTTPS protocols, the target is specified as ` <i><protocol></i>:<i><port></i>/<i><path to ping></i> `.
     */
    public val target: kotlin.String? = builder.target
    /**
     * The amount of time, in seconds, during which no response means a failed health check.
     */
    public val timeout: kotlin.Int? = builder.timeout
    /**
     * The number of consecutive health check failures that must occur before the instance is moved to the Unhealthy state.
     */
    public val unhealthyThreshold: kotlin.Int? = builder.unhealthyThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElbLoadBalancerHealthCheck(")
        append("healthyThreshold=$healthyThreshold,")
        append("interval=$interval,")
        append("target=$target,")
        append("timeout=$timeout,")
        append("unhealthyThreshold=$unhealthyThreshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthyThreshold ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (timeout ?: 0)
        result = 31 * result + (unhealthyThreshold ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElbLoadBalancerHealthCheck

        if (healthyThreshold != other.healthyThreshold) return false
        if (interval != other.interval) return false
        if (target != other.target) return false
        if (timeout != other.timeout) return false
        if (unhealthyThreshold != other.unhealthyThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of consecutive health check successes required before the instance is moved to the Healthy state.
         */
        public var healthyThreshold: kotlin.Int? = null
        /**
         * The approximate interval, in seconds, between health checks of an individual instance.
         */
        public var interval: kotlin.Int? = null
        /**
         * The instance that is being checked. The target specifies the protocol and port. The available protocols are TCP, SSL, HTTP, and HTTPS. The range of valid ports is 1 through 65535.
         *
         * For the HTTP and HTTPS protocols, the target also specifies the ping path.
         *
         * For the TCP protocol, the target is specified as `TCP: <i><port></i> `.
         *
         * For the SSL protocol, the target is specified as `SSL.<i><port></i> `.
         *
         * For the HTTP and HTTPS protocols, the target is specified as ` <i><protocol></i>:<i><port></i>/<i><path to ping></i> `.
         */
        public var target: kotlin.String? = null
        /**
         * The amount of time, in seconds, during which no response means a failed health check.
         */
        public var timeout: kotlin.Int? = null
        /**
         * The number of consecutive health check failures that must occur before the instance is moved to the Unhealthy state.
         */
        public var unhealthyThreshold: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck) : this() {
            this.healthyThreshold = x.healthyThreshold
            this.interval = x.interval
            this.target = x.target
            this.timeout = x.timeout
            this.unhealthyThreshold = x.unhealthyThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck = AwsElbLoadBalancerHealthCheck(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
