// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains details about a Classic Load Balancer.
 */
public class AwsElbLoadBalancerDetails private constructor(builder: Builder) {
    /**
     * The list of Availability Zones for the load balancer.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Information about the configuration of the EC2 instances.
     */
    public val backendServerDescriptions: List<AwsElbLoadBalancerBackendServerDescription>? = builder.backendServerDescriptions
    /**
     * The name of the Amazon Route 53 hosted zone for the load balancer.
     */
    public val canonicalHostedZoneName: kotlin.String? = builder.canonicalHostedZoneName
    /**
     * The ID of the Amazon Route 53 hosted zone for the load balancer.
     */
    public val canonicalHostedZoneNameId: kotlin.String? = builder.canonicalHostedZoneNameId
    /**
     * Indicates when the load balancer was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdTime: kotlin.String? = builder.createdTime
    /**
     * The DNS name of the load balancer.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * Information about the health checks that are conducted on the load balancer.
     */
    public val healthCheck: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck? = builder.healthCheck
    /**
     * List of EC2 instances for the load balancer.
     */
    public val instances: List<AwsElbLoadBalancerInstance>? = builder.instances
    /**
     * The policies that are enabled for the load balancer listeners.
     */
    public val listenerDescriptions: List<AwsElbLoadBalancerListenerDescription>? = builder.listenerDescriptions
    /**
     * The attributes for a load balancer.
     */
    public val loadBalancerAttributes: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes? = builder.loadBalancerAttributes
    /**
     * The name of the load balancer.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The policies for a load balancer.
     */
    public val policies: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerPolicies? = builder.policies
    /**
     * The type of load balancer. Only provided if the load balancer is in a VPC.
     *
     * If `Scheme` is `internet-facing`, the load balancer has a public DNS name that resolves to a public IP address.
     *
     * If `Scheme` is `internal`, the load balancer has a public DNS name that resolves to a private IP address.
     */
    public val scheme: kotlin.String? = builder.scheme
    /**
     * The security groups for the load balancer. Only provided if the load balancer is in a VPC.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * Information about the security group for the load balancer. This is the security group that is used for inbound rules.
     */
    public val sourceSecurityGroup: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup? = builder.sourceSecurityGroup
    /**
     * The list of subnet identifiers for the load balancer.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The identifier of the VPC for the load balancer.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElbLoadBalancerDetails(")
        append("availabilityZones=$availabilityZones,")
        append("backendServerDescriptions=$backendServerDescriptions,")
        append("canonicalHostedZoneName=$canonicalHostedZoneName,")
        append("canonicalHostedZoneNameId=$canonicalHostedZoneNameId,")
        append("createdTime=$createdTime,")
        append("dnsName=$dnsName,")
        append("healthCheck=$healthCheck,")
        append("instances=$instances,")
        append("listenerDescriptions=$listenerDescriptions,")
        append("loadBalancerAttributes=$loadBalancerAttributes,")
        append("loadBalancerName=$loadBalancerName,")
        append("policies=$policies,")
        append("scheme=$scheme,")
        append("securityGroups=$securityGroups,")
        append("sourceSecurityGroup=$sourceSecurityGroup,")
        append("subnets=$subnets,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (backendServerDescriptions?.hashCode() ?: 0)
        result = 31 * result + (canonicalHostedZoneName?.hashCode() ?: 0)
        result = 31 * result + (canonicalHostedZoneNameId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (healthCheck?.hashCode() ?: 0)
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (listenerDescriptions?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerAttributes?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sourceSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElbLoadBalancerDetails

        if (availabilityZones != other.availabilityZones) return false
        if (backendServerDescriptions != other.backendServerDescriptions) return false
        if (canonicalHostedZoneName != other.canonicalHostedZoneName) return false
        if (canonicalHostedZoneNameId != other.canonicalHostedZoneNameId) return false
        if (createdTime != other.createdTime) return false
        if (dnsName != other.dnsName) return false
        if (healthCheck != other.healthCheck) return false
        if (instances != other.instances) return false
        if (listenerDescriptions != other.listenerDescriptions) return false
        if (loadBalancerAttributes != other.loadBalancerAttributes) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (policies != other.policies) return false
        if (scheme != other.scheme) return false
        if (securityGroups != other.securityGroups) return false
        if (sourceSecurityGroup != other.sourceSecurityGroup) return false
        if (subnets != other.subnets) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of Availability Zones for the load balancer.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Information about the configuration of the EC2 instances.
         */
        public var backendServerDescriptions: List<AwsElbLoadBalancerBackendServerDescription>? = null
        /**
         * The name of the Amazon Route 53 hosted zone for the load balancer.
         */
        public var canonicalHostedZoneName: kotlin.String? = null
        /**
         * The ID of the Amazon Route 53 hosted zone for the load balancer.
         */
        public var canonicalHostedZoneNameId: kotlin.String? = null
        /**
         * Indicates when the load balancer was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdTime: kotlin.String? = null
        /**
         * The DNS name of the load balancer.
         */
        public var dnsName: kotlin.String? = null
        /**
         * Information about the health checks that are conducted on the load balancer.
         */
        public var healthCheck: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck? = null
        /**
         * List of EC2 instances for the load balancer.
         */
        public var instances: List<AwsElbLoadBalancerInstance>? = null
        /**
         * The policies that are enabled for the load balancer listeners.
         */
        public var listenerDescriptions: List<AwsElbLoadBalancerListenerDescription>? = null
        /**
         * The attributes for a load balancer.
         */
        public var loadBalancerAttributes: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes? = null
        /**
         * The name of the load balancer.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The policies for a load balancer.
         */
        public var policies: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerPolicies? = null
        /**
         * The type of load balancer. Only provided if the load balancer is in a VPC.
         *
         * If `Scheme` is `internet-facing`, the load balancer has a public DNS name that resolves to a public IP address.
         *
         * If `Scheme` is `internal`, the load balancer has a public DNS name that resolves to a private IP address.
         */
        public var scheme: kotlin.String? = null
        /**
         * The security groups for the load balancer. Only provided if the load balancer is in a VPC.
         */
        public var securityGroups: List<String>? = null
        /**
         * Information about the security group for the load balancer. This is the security group that is used for inbound rules.
         */
        public var sourceSecurityGroup: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup? = null
        /**
         * The list of subnet identifiers for the load balancer.
         */
        public var subnets: List<String>? = null
        /**
         * The identifier of the VPC for the load balancer.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails) : this() {
            this.availabilityZones = x.availabilityZones
            this.backendServerDescriptions = x.backendServerDescriptions
            this.canonicalHostedZoneName = x.canonicalHostedZoneName
            this.canonicalHostedZoneNameId = x.canonicalHostedZoneNameId
            this.createdTime = x.createdTime
            this.dnsName = x.dnsName
            this.healthCheck = x.healthCheck
            this.instances = x.instances
            this.listenerDescriptions = x.listenerDescriptions
            this.loadBalancerAttributes = x.loadBalancerAttributes
            this.loadBalancerName = x.loadBalancerName
            this.policies = x.policies
            this.scheme = x.scheme
            this.securityGroups = x.securityGroups
            this.sourceSecurityGroup = x.sourceSecurityGroup
            this.subnets = x.subnets
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails = AwsElbLoadBalancerDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck] inside the given [block]
         */
        public fun healthCheck(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck.Builder.() -> kotlin.Unit) {
            this.healthCheck = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerHealthCheck.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes] inside the given [block]
         */
        public fun loadBalancerAttributes(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes.Builder.() -> kotlin.Unit) {
            this.loadBalancerAttributes = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerPolicies] inside the given [block]
         */
        public fun policies(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerPolicies.Builder.() -> kotlin.Unit) {
            this.policies = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerPolicies.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup] inside the given [block]
         */
        public fun sourceSecurityGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.Builder.() -> kotlin.Unit) {
            this.sourceSecurityGroup = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerSourceSecurityGroup.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
