// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about an Amazon EFS access point.
 */
public class AwsEfsAccessPointDetails private constructor(builder: Builder) {
    /**
     * The ID of the Amazon EFS access point.
     */
    public val accessPointId: kotlin.String? = builder.accessPointId
    /**
     * The Amazon Resource Name (ARN) of the Amazon EFS access point.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The opaque string specified in the request to ensure idempotent creation.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ID of the Amazon EFS file system that the access point applies to.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point, that is used for all file operations by NFS clients using the access point.
     */
    public val posixUser: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointPosixUserDetails? = builder.posixUser
    /**
     * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.
     */
    public val rootDirectory: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails? = builder.rootDirectory

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEfsAccessPointDetails(")
        append("accessPointId=$accessPointId,")
        append("arn=$arn,")
        append("clientToken=$clientToken,")
        append("fileSystemId=$fileSystemId,")
        append("posixUser=$posixUser,")
        append("rootDirectory=$rootDirectory")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (posixUser?.hashCode() ?: 0)
        result = 31 * result + (rootDirectory?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEfsAccessPointDetails

        if (accessPointId != other.accessPointId) return false
        if (arn != other.arn) return false
        if (clientToken != other.clientToken) return false
        if (fileSystemId != other.fileSystemId) return false
        if (posixUser != other.posixUser) return false
        if (rootDirectory != other.rootDirectory) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon EFS access point.
         */
        public var accessPointId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon EFS access point.
         */
        public var arn: kotlin.String? = null
        /**
         * The opaque string specified in the request to ensure idempotent creation.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ID of the Amazon EFS file system that the access point applies to.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point, that is used for all file operations by NFS clients using the access point.
         */
        public var posixUser: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointPosixUserDetails? = null
        /**
         * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.
         */
        public var rootDirectory: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails) : this() {
            this.accessPointId = x.accessPointId
            this.arn = x.arn
            this.clientToken = x.clientToken
            this.fileSystemId = x.fileSystemId
            this.posixUser = x.posixUser
            this.rootDirectory = x.rootDirectory
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails = AwsEfsAccessPointDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointPosixUserDetails] inside the given [block]
         */
        public fun posixUser(block: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointPosixUserDetails.Builder.() -> kotlin.Unit) {
            this.posixUser = aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointPosixUserDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails] inside the given [block]
         */
        public fun rootDirectory(block: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.Builder.() -> kotlin.Unit) {
            this.rootDirectory = aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointRootDirectoryDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
