// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.
 */
public class AwsEcsTaskDefinitionDetails private constructor(builder: Builder) {
    /**
     * The container definitions that describe the containers that make up the task.
     */
    public val containerDefinitions: List<AwsEcsTaskDefinitionContainerDefinitionsDetails>? = builder.containerDefinitions
    /**
     * The number of CPU units used by the task.Valid values are as follows:
     * + `256 (.25 vCPU)`
     * + `512 (.5 vCPU)`
     * + `1024 (1 vCPU)`
     * + `2048 (2 vCPU)`
     * + `4096 (4 vCPU)`
     */
    public val cpu: kotlin.String? = builder.cpu
    /**
     * The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.
     */
    public val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The name of a family that this task definition is registered to.
     */
    public val family: kotlin.String? = builder.family
    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     */
    public val inferenceAccelerators: List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>? = builder.inferenceAccelerators
    /**
     * The inter-process communication (IPC) resource namespace to use for the containers in the task. Valid values are as follows:
     * + `host`
     * + `none`
     * + `task`
     */
    public val ipcMode: kotlin.String? = builder.ipcMode
    /**
     * The amount (in MiB) of memory used by the task.
     *
     * For tasks that are hosted on Amazon EC2, you can provide a task-level memory value or a container-level memory value. For tasks that are hosted on Fargate, you must use one of the [specified values](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size) in the **Amazon Elastic Container Service Developer Guide**, which determines your range of supported values for the `Cpu` and `Memory` parameters.
     */
    public val memory: kotlin.String? = builder.memory
    /**
     * The Docker networking mode to use for the containers in the task. Valid values are as follows:
     * + `awsvpc`
     * + `bridge`
     * + `host`
     * + `none`
     */
    public val networkMode: kotlin.String? = builder.networkMode
    /**
     * The process namespace to use for the containers in the task. Valid values are `host` or `task`.
     */
    public val pidMode: kotlin.String? = builder.pidMode
    /**
     * The placement constraint objects to use for tasks.
     */
    public val placementConstraints: List<AwsEcsTaskDefinitionPlacementConstraintsDetails>? = builder.placementConstraints
    /**
     * The configuration details for the App Mesh proxy.
     */
    public val proxyConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails? = builder.proxyConfiguration
    /**
     * The task launch types that the task definition was validated against.
     */
    public val requiresCompatibilities: List<String>? = builder.requiresCompatibilities
    /**
     * The status of the task definition.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.
     */
    public val taskRoleArn: kotlin.String? = builder.taskRoleArn
    /**
     * The data volume definitions for the task.
     */
    public val volumes: List<AwsEcsTaskDefinitionVolumesDetails>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsTaskDefinitionDetails(")
        append("containerDefinitions=$containerDefinitions,")
        append("cpu=$cpu,")
        append("executionRoleArn=$executionRoleArn,")
        append("family=$family,")
        append("inferenceAccelerators=$inferenceAccelerators,")
        append("ipcMode=$ipcMode,")
        append("memory=$memory,")
        append("networkMode=$networkMode,")
        append("pidMode=$pidMode,")
        append("placementConstraints=$placementConstraints,")
        append("proxyConfiguration=$proxyConfiguration,")
        append("requiresCompatibilities=$requiresCompatibilities,")
        append("status=$status,")
        append("taskRoleArn=$taskRoleArn,")
        append("volumes=$volumes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerDefinitions?.hashCode() ?: 0
        result = 31 * result + (cpu?.hashCode() ?: 0)
        result = 31 * result + (executionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (family?.hashCode() ?: 0)
        result = 31 * result + (inferenceAccelerators?.hashCode() ?: 0)
        result = 31 * result + (ipcMode?.hashCode() ?: 0)
        result = 31 * result + (memory?.hashCode() ?: 0)
        result = 31 * result + (networkMode?.hashCode() ?: 0)
        result = 31 * result + (pidMode?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (proxyConfiguration?.hashCode() ?: 0)
        result = 31 * result + (requiresCompatibilities?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskRoleArn?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsTaskDefinitionDetails

        if (containerDefinitions != other.containerDefinitions) return false
        if (cpu != other.cpu) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (family != other.family) return false
        if (inferenceAccelerators != other.inferenceAccelerators) return false
        if (ipcMode != other.ipcMode) return false
        if (memory != other.memory) return false
        if (networkMode != other.networkMode) return false
        if (pidMode != other.pidMode) return false
        if (placementConstraints != other.placementConstraints) return false
        if (proxyConfiguration != other.proxyConfiguration) return false
        if (requiresCompatibilities != other.requiresCompatibilities) return false
        if (status != other.status) return false
        if (taskRoleArn != other.taskRoleArn) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The container definitions that describe the containers that make up the task.
         */
        public var containerDefinitions: List<AwsEcsTaskDefinitionContainerDefinitionsDetails>? = null
        /**
         * The number of CPU units used by the task.Valid values are as follows:
         * + `256 (.25 vCPU)`
         * + `512 (.5 vCPU)`
         * + `1024 (1 vCPU)`
         * + `2048 (2 vCPU)`
         * + `4096 (4 vCPU)`
         */
        public var cpu: kotlin.String? = null
        /**
         * The ARN of the task execution role that grants the container agent permission to make API calls on behalf of the container user.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The name of a family that this task definition is registered to.
         */
        public var family: kotlin.String? = null
        /**
         * The Elastic Inference accelerators to use for the containers in the task.
         */
        public var inferenceAccelerators: List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails>? = null
        /**
         * The inter-process communication (IPC) resource namespace to use for the containers in the task. Valid values are as follows:
         * + `host`
         * + `none`
         * + `task`
         */
        public var ipcMode: kotlin.String? = null
        /**
         * The amount (in MiB) of memory used by the task.
         *
         * For tasks that are hosted on Amazon EC2, you can provide a task-level memory value or a container-level memory value. For tasks that are hosted on Fargate, you must use one of the [specified values](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size) in the **Amazon Elastic Container Service Developer Guide**, which determines your range of supported values for the `Cpu` and `Memory` parameters.
         */
        public var memory: kotlin.String? = null
        /**
         * The Docker networking mode to use for the containers in the task. Valid values are as follows:
         * + `awsvpc`
         * + `bridge`
         * + `host`
         * + `none`
         */
        public var networkMode: kotlin.String? = null
        /**
         * The process namespace to use for the containers in the task. Valid values are `host` or `task`.
         */
        public var pidMode: kotlin.String? = null
        /**
         * The placement constraint objects to use for tasks.
         */
        public var placementConstraints: List<AwsEcsTaskDefinitionPlacementConstraintsDetails>? = null
        /**
         * The configuration details for the App Mesh proxy.
         */
        public var proxyConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails? = null
        /**
         * The task launch types that the task definition was validated against.
         */
        public var requiresCompatibilities: List<String>? = null
        /**
         * The status of the task definition.
         */
        public var status: kotlin.String? = null
        /**
         * The short name or ARN of the IAM role that grants containers in the task permission to call Amazon Web Services API operations on your behalf.
         */
        public var taskRoleArn: kotlin.String? = null
        /**
         * The data volume definitions for the task.
         */
        public var volumes: List<AwsEcsTaskDefinitionVolumesDetails>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails) : this() {
            this.containerDefinitions = x.containerDefinitions
            this.cpu = x.cpu
            this.executionRoleArn = x.executionRoleArn
            this.family = x.family
            this.inferenceAccelerators = x.inferenceAccelerators
            this.ipcMode = x.ipcMode
            this.memory = x.memory
            this.networkMode = x.networkMode
            this.pidMode = x.pidMode
            this.placementConstraints = x.placementConstraints
            this.proxyConfiguration = x.proxyConfiguration
            this.requiresCompatibilities = x.requiresCompatibilities
            this.status = x.status
            this.taskRoleArn = x.taskRoleArn
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails = AwsEcsTaskDefinitionDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails] inside the given [block]
         */
        public fun proxyConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.proxyConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionProxyConfigurationDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
