// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The log configuration specification for the container.
 */
public class AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails private constructor(builder: Builder) {
    /**
     * The log driver to use for the container.
     *
     * Valid values on Fargate are as follows:
     * + `awsfirelens`
     * + `awslogs`
     * + `splunk`
     *
     * Valid values on Amazon EC2 are as follows:
     * + `awsfirelens`
     * + `awslogs`
     * + `fluentd`
     * + `gelf`
     * + `journald`
     * + `json-file`
     * + `logentries`
     * + `splunk`
     * + `syslog`
     */
    public val logDriver: kotlin.String? = builder.logDriver
    /**
     * The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or greater on your container instance.
     */
    public val options: Map<String, String>? = builder.options
    /**
     * The secrets to pass to the log configuration.
     */
    public val secretOptions: List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>? = builder.secretOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(")
        append("logDriver=$logDriver,")
        append("options=$options,")
        append("secretOptions=$secretOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logDriver?.hashCode() ?: 0
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (secretOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails

        if (logDriver != other.logDriver) return false
        if (options != other.options) return false
        if (secretOptions != other.secretOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The log driver to use for the container.
         *
         * Valid values on Fargate are as follows:
         * + `awsfirelens`
         * + `awslogs`
         * + `splunk`
         *
         * Valid values on Amazon EC2 are as follows:
         * + `awsfirelens`
         * + `awslogs`
         * + `fluentd`
         * + `gelf`
         * + `journald`
         * + `json-file`
         * + `logentries`
         * + `splunk`
         * + `syslog`
         */
        public var logDriver: kotlin.String? = null
        /**
         * The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or greater on your container instance.
         */
        public var options: Map<String, String>? = null
        /**
         * The secrets to pass to the log configuration.
         */
        public var secretOptions: List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) : this() {
            this.logDriver = x.logDriver
            this.options = x.options
            this.secretOptions = x.secretOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails = AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
