// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Amazon ECS cluster.
 */
public class AwsEcsClusterDetails private constructor(builder: Builder) {
    /**
     * The number of services that are running on the cluster in an `ACTIVE` state. You can view these services with the Amazon ECS `ListServices`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html) API operation.
     */
    public val activeServicesCount: kotlin.Int? = builder.activeServicesCount
    /**
     * The short name of one or more capacity providers to associate with the cluster.
     */
    public val capacityProviders: List<String>? = builder.capacityProviders
    /**
     * The Amazon Resource Name (ARN) that identifies the cluster.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * A name that you use to identify your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch Container Insights for the cluster.
     */
    public val clusterSettings: List<AwsEcsClusterClusterSettingsDetails>? = builder.clusterSettings
    /**
     * The run command configuration for the cluster.
     */
    public val configuration: aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterConfigurationDetails? = builder.configuration
    /**
     * The default capacity provider strategy for the cluster. The default capacity provider strategy is used when services or tasks are run without a specified launch type or capacity provider strategy.
     */
    public val defaultCapacityProviderStrategy: List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>? = builder.defaultCapacityProviderStrategy
    /**
     * The number of container instances registered into the cluster. This includes container instances in both `ACTIVE` and `DRAINING` status.
     */
    public val registeredContainerInstancesCount: kotlin.Int? = builder.registeredContainerInstancesCount
    /**
     * The number of tasks in the cluster that are in the `RUNNING` state.
     */
    public val runningTasksCount: kotlin.Int? = builder.runningTasksCount
    /**
     * The status of the cluster.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsClusterDetails(")
        append("activeServicesCount=$activeServicesCount,")
        append("capacityProviders=$capacityProviders,")
        append("clusterArn=$clusterArn,")
        append("clusterName=$clusterName,")
        append("clusterSettings=$clusterSettings,")
        append("configuration=$configuration,")
        append("defaultCapacityProviderStrategy=$defaultCapacityProviderStrategy,")
        append("registeredContainerInstancesCount=$registeredContainerInstancesCount,")
        append("runningTasksCount=$runningTasksCount,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeServicesCount ?: 0
        result = 31 * result + (capacityProviders?.hashCode() ?: 0)
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (clusterSettings?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (defaultCapacityProviderStrategy?.hashCode() ?: 0)
        result = 31 * result + (registeredContainerInstancesCount ?: 0)
        result = 31 * result + (runningTasksCount ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsClusterDetails

        if (activeServicesCount != other.activeServicesCount) return false
        if (capacityProviders != other.capacityProviders) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterName != other.clusterName) return false
        if (clusterSettings != other.clusterSettings) return false
        if (configuration != other.configuration) return false
        if (defaultCapacityProviderStrategy != other.defaultCapacityProviderStrategy) return false
        if (registeredContainerInstancesCount != other.registeredContainerInstancesCount) return false
        if (runningTasksCount != other.runningTasksCount) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of services that are running on the cluster in an `ACTIVE` state. You can view these services with the Amazon ECS `ListServices`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ListServices.html) API operation.
         */
        public var activeServicesCount: kotlin.Int? = null
        /**
         * The short name of one or more capacity providers to associate with the cluster.
         */
        public var capacityProviders: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the cluster.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * A name that you use to identify your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The setting to use to create the cluster. Specifically used to configure whether to enable CloudWatch Container Insights for the cluster.
         */
        public var clusterSettings: List<AwsEcsClusterClusterSettingsDetails>? = null
        /**
         * The run command configuration for the cluster.
         */
        public var configuration: aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterConfigurationDetails? = null
        /**
         * The default capacity provider strategy for the cluster. The default capacity provider strategy is used when services or tasks are run without a specified launch type or capacity provider strategy.
         */
        public var defaultCapacityProviderStrategy: List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>? = null
        /**
         * The number of container instances registered into the cluster. This includes container instances in both `ACTIVE` and `DRAINING` status.
         */
        public var registeredContainerInstancesCount: kotlin.Int? = null
        /**
         * The number of tasks in the cluster that are in the `RUNNING` state.
         */
        public var runningTasksCount: kotlin.Int? = null
        /**
         * The status of the cluster.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails) : this() {
            this.activeServicesCount = x.activeServicesCount
            this.capacityProviders = x.capacityProviders
            this.clusterArn = x.clusterArn
            this.clusterName = x.clusterName
            this.clusterSettings = x.clusterSettings
            this.configuration = x.configuration
            this.defaultCapacityProviderStrategy = x.defaultCapacityProviderStrategy
            this.registeredContainerInstancesCount = x.registeredContainerInstancesCount
            this.runningTasksCount = x.runningTasksCount
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails = AwsEcsClusterDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterConfigurationDetails] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterConfigurationDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
