// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The VPN tunnel options.
 */
public class AwsEc2VpnConnectionOptionsTunnelOptionsDetails private constructor(builder: Builder) {
    /**
     * The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
     */
    public val dpdTimeoutSeconds: kotlin.Int? = builder.dpdTimeoutSeconds
    /**
     * The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
     */
    public val ikeVersions: List<String>? = builder.ikeVersions
    /**
     * The external IP address of the VPN tunnel.
     */
    public val outsideIpAddress: kotlin.String? = builder.outsideIpAddress
    /**
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
     */
    public val phase1DhGroupNumbers: List<Int>? = builder.phase1DhGroupNumbers
    /**
     * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
     */
    public val phase1EncryptionAlgorithms: List<String>? = builder.phase1EncryptionAlgorithms
    /**
     * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
     */
    public val phase1IntegrityAlgorithms: List<String>? = builder.phase1IntegrityAlgorithms
    /**
     * The lifetime for phase 1 of the IKE negotiation, in seconds.
     */
    public val phase1LifetimeSeconds: kotlin.Int? = builder.phase1LifetimeSeconds
    /**
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
     */
    public val phase2DhGroupNumbers: List<Int>? = builder.phase2DhGroupNumbers
    /**
     * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
     */
    public val phase2EncryptionAlgorithms: List<String>? = builder.phase2EncryptionAlgorithms
    /**
     * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
     */
    public val phase2IntegrityAlgorithms: List<String>? = builder.phase2IntegrityAlgorithms
    /**
     * The lifetime for phase 2 of the IKE negotiation, in seconds.
     */
    public val phase2LifetimeSeconds: kotlin.Int? = builder.phase2LifetimeSeconds
    /**
     * The preshared key to establish initial authentication between the virtual private gateway and the customer gateway.
     */
    public val preSharedKey: kotlin.String? = builder.preSharedKey
    /**
     * The percentage of the rekey window, which is determined by `RekeyMarginTimeSeconds` during which the rekey time is randomly selected.
     */
    public val rekeyFuzzPercentage: kotlin.Int? = builder.rekeyFuzzPercentage
    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services side of the VPN connection performs an IKE rekey.
     */
    public val rekeyMarginTimeSeconds: kotlin.Int? = builder.rekeyMarginTimeSeconds
    /**
     * The number of packets in an IKE replay window.
     */
    public val replayWindowSize: kotlin.Int? = builder.replayWindowSize
    /**
     * The range of inside IPv4 addresses for the tunnel.
     */
    public val tunnelInsideCidr: kotlin.String? = builder.tunnelInsideCidr

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2VpnConnectionOptionsTunnelOptionsDetails(")
        append("dpdTimeoutSeconds=$dpdTimeoutSeconds,")
        append("ikeVersions=$ikeVersions,")
        append("outsideIpAddress=$outsideIpAddress,")
        append("phase1DhGroupNumbers=$phase1DhGroupNumbers,")
        append("phase1EncryptionAlgorithms=$phase1EncryptionAlgorithms,")
        append("phase1IntegrityAlgorithms=$phase1IntegrityAlgorithms,")
        append("phase1LifetimeSeconds=$phase1LifetimeSeconds,")
        append("phase2DhGroupNumbers=$phase2DhGroupNumbers,")
        append("phase2EncryptionAlgorithms=$phase2EncryptionAlgorithms,")
        append("phase2IntegrityAlgorithms=$phase2IntegrityAlgorithms,")
        append("phase2LifetimeSeconds=$phase2LifetimeSeconds,")
        append("preSharedKey=$preSharedKey,")
        append("rekeyFuzzPercentage=$rekeyFuzzPercentage,")
        append("rekeyMarginTimeSeconds=$rekeyMarginTimeSeconds,")
        append("replayWindowSize=$replayWindowSize,")
        append("tunnelInsideCidr=$tunnelInsideCidr")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dpdTimeoutSeconds ?: 0
        result = 31 * result + (ikeVersions?.hashCode() ?: 0)
        result = 31 * result + (outsideIpAddress?.hashCode() ?: 0)
        result = 31 * result + (phase1DhGroupNumbers?.hashCode() ?: 0)
        result = 31 * result + (phase1EncryptionAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase1IntegrityAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase1LifetimeSeconds ?: 0)
        result = 31 * result + (phase2DhGroupNumbers?.hashCode() ?: 0)
        result = 31 * result + (phase2EncryptionAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase2IntegrityAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase2LifetimeSeconds ?: 0)
        result = 31 * result + (preSharedKey?.hashCode() ?: 0)
        result = 31 * result + (rekeyFuzzPercentage ?: 0)
        result = 31 * result + (rekeyMarginTimeSeconds ?: 0)
        result = 31 * result + (replayWindowSize ?: 0)
        result = 31 * result + (tunnelInsideCidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2VpnConnectionOptionsTunnelOptionsDetails

        if (dpdTimeoutSeconds != other.dpdTimeoutSeconds) return false
        if (ikeVersions != other.ikeVersions) return false
        if (outsideIpAddress != other.outsideIpAddress) return false
        if (phase1DhGroupNumbers != other.phase1DhGroupNumbers) return false
        if (phase1EncryptionAlgorithms != other.phase1EncryptionAlgorithms) return false
        if (phase1IntegrityAlgorithms != other.phase1IntegrityAlgorithms) return false
        if (phase1LifetimeSeconds != other.phase1LifetimeSeconds) return false
        if (phase2DhGroupNumbers != other.phase2DhGroupNumbers) return false
        if (phase2EncryptionAlgorithms != other.phase2EncryptionAlgorithms) return false
        if (phase2IntegrityAlgorithms != other.phase2IntegrityAlgorithms) return false
        if (phase2LifetimeSeconds != other.phase2LifetimeSeconds) return false
        if (preSharedKey != other.preSharedKey) return false
        if (rekeyFuzzPercentage != other.rekeyFuzzPercentage) return false
        if (rekeyMarginTimeSeconds != other.rekeyMarginTimeSeconds) return false
        if (replayWindowSize != other.replayWindowSize) return false
        if (tunnelInsideCidr != other.tunnelInsideCidr) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of seconds after which a Dead Peer Detection (DPD) timeout occurs.
         */
        public var dpdTimeoutSeconds: kotlin.Int? = null
        /**
         * The Internet Key Exchange (IKE) versions that are permitted for the VPN tunnel.
         */
        public var ikeVersions: List<String>? = null
        /**
         * The external IP address of the VPN tunnel.
         */
        public var outsideIpAddress: kotlin.String? = null
        /**
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE negotiations.
         */
        public var phase1DhGroupNumbers: List<Int>? = null
        /**
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE negotiations.
         */
        public var phase1EncryptionAlgorithms: List<String>? = null
        /**
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE negotiations.
         */
        public var phase1IntegrityAlgorithms: List<String>? = null
        /**
         * The lifetime for phase 1 of the IKE negotiation, in seconds.
         */
        public var phase1LifetimeSeconds: kotlin.Int? = null
        /**
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE negotiations.
         */
        public var phase2DhGroupNumbers: List<Int>? = null
        /**
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE negotiations.
         */
        public var phase2EncryptionAlgorithms: List<String>? = null
        /**
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE negotiations.
         */
        public var phase2IntegrityAlgorithms: List<String>? = null
        /**
         * The lifetime for phase 2 of the IKE negotiation, in seconds.
         */
        public var phase2LifetimeSeconds: kotlin.Int? = null
        /**
         * The preshared key to establish initial authentication between the virtual private gateway and the customer gateway.
         */
        public var preSharedKey: kotlin.String? = null
        /**
         * The percentage of the rekey window, which is determined by `RekeyMarginTimeSeconds` during which the rekey time is randomly selected.
         */
        public var rekeyFuzzPercentage: kotlin.Int? = null
        /**
         * The margin time, in seconds, before the phase 2 lifetime expires, during which the Amazon Web Services side of the VPN connection performs an IKE rekey.
         */
        public var rekeyMarginTimeSeconds: kotlin.Int? = null
        /**
         * The number of packets in an IKE replay window.
         */
        public var replayWindowSize: kotlin.Int? = null
        /**
         * The range of inside IPv4 addresses for the tunnel.
         */
        public var tunnelInsideCidr: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails) : this() {
            this.dpdTimeoutSeconds = x.dpdTimeoutSeconds
            this.ikeVersions = x.ikeVersions
            this.outsideIpAddress = x.outsideIpAddress
            this.phase1DhGroupNumbers = x.phase1DhGroupNumbers
            this.phase1EncryptionAlgorithms = x.phase1EncryptionAlgorithms
            this.phase1IntegrityAlgorithms = x.phase1IntegrityAlgorithms
            this.phase1LifetimeSeconds = x.phase1LifetimeSeconds
            this.phase2DhGroupNumbers = x.phase2DhGroupNumbers
            this.phase2EncryptionAlgorithms = x.phase2EncryptionAlgorithms
            this.phase2IntegrityAlgorithms = x.phase2IntegrityAlgorithms
            this.phase2LifetimeSeconds = x.phase2LifetimeSeconds
            this.preSharedKey = x.preSharedKey
            this.rekeyFuzzPercentage = x.rekeyFuzzPercentage
            this.rekeyMarginTimeSeconds = x.rekeyMarginTimeSeconds
            this.replayWindowSize = x.replayWindowSize
            this.tunnelInsideCidr = x.tunnelInsideCidr
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionOptionsTunnelOptionsDetails = AwsEc2VpnConnectionOptionsTunnelOptionsDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
