// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about the network interface attachment.
 */
public class AwsEc2NetworkInterfaceAttachment private constructor(builder: Builder) {
    /**
     * Indicates when the attachment initiated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val attachTime: kotlin.String? = builder.attachTime
    /**
     * The identifier of the network interface attachment
     */
    public val attachmentId: kotlin.String? = builder.attachmentId
    /**
     * Indicates whether the network interface is deleted when the instance is terminated.
     */
    public val deleteOnTermination: kotlin.Boolean? = builder.deleteOnTermination
    /**
     * The device index of the network interface attachment on the instance.
     */
    public val deviceIndex: kotlin.Int? = builder.deviceIndex
    /**
     * The ID of the instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The Amazon Web Services account ID of the owner of the instance.
     */
    public val instanceOwnerId: kotlin.String? = builder.instanceOwnerId
    /**
     * The attachment state.
     *
     * Valid values: `attaching` | `attached` | `detaching` | `detached`
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceAttachment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2NetworkInterfaceAttachment(")
        append("attachTime=$attachTime,")
        append("attachmentId=$attachmentId,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("deviceIndex=$deviceIndex,")
        append("instanceId=$instanceId,")
        append("instanceOwnerId=$instanceOwnerId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachTime?.hashCode() ?: 0
        result = 31 * result + (attachmentId?.hashCode() ?: 0)
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2NetworkInterfaceAttachment

        if (attachTime != other.attachTime) return false
        if (attachmentId != other.attachmentId) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (deviceIndex != other.deviceIndex) return false
        if (instanceId != other.instanceId) return false
        if (instanceOwnerId != other.instanceOwnerId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceAttachment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates when the attachment initiated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var attachTime: kotlin.String? = null
        /**
         * The identifier of the network interface attachment
         */
        public var attachmentId: kotlin.String? = null
        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        public var deleteOnTermination: kotlin.Boolean? = null
        /**
         * The device index of the network interface attachment on the instance.
         */
        public var deviceIndex: kotlin.Int? = null
        /**
         * The ID of the instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the owner of the instance.
         */
        public var instanceOwnerId: kotlin.String? = null
        /**
         * The attachment state.
         *
         * Valid values: `attaching` | `attached` | `detaching` | `detached`
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceAttachment) : this() {
            this.attachTime = x.attachTime
            this.attachmentId = x.attachmentId
            this.deleteOnTermination = x.deleteOnTermination
            this.deviceIndex = x.deviceIndex
            this.instanceId = x.instanceId
            this.instanceOwnerId = x.instanceOwnerId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceAttachment = AwsEc2NetworkInterfaceAttachment(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
