// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * One or more network interfaces to attach to an Amazon EC2 instance. If you specify a network interface, you must specify security groups and subnets as part of the network interface.
 */
public class AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails private constructor(builder: Builder) {
    /**
     * Indicates whether to associate a Carrier IP address with eth0 for a new network interface. You use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information, see [Carrier IP address](https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip) in the *Wavelength Developer Guide*.
     */
    public val associateCarrierIpAddress: kotlin.Boolean? = builder.associateCarrierIpAddress
    /**
     * Associates a public IPv4 address with eth0 for a new network interface.
     */
    public val associatePublicIpAddress: kotlin.Boolean? = builder.associatePublicIpAddress
    /**
     * Indicates whether the network interface is deleted when the instance is terminated.
     */
    public val deleteOnTermination: kotlin.Boolean? = builder.deleteOnTermination
    /**
     * A description for the network interface.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The device index for the network interface attachment.
     */
    public val deviceIndex: kotlin.Int? = builder.deviceIndex
    /**
     * The IDs of one or more security groups.
     */
    public val groups: List<String>? = builder.groups
    /**
     * The type of network interface.
     */
    public val interfaceType: kotlin.String? = builder.interfaceType
    /**
     * The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv4Prefixes` option.
     */
    public val ipv4PrefixCount: kotlin.Int? = builder.ipv4PrefixCount
    /**
     * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv4PrefixCount` option.
     */
    public val ipv4Prefixes: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails>? = builder.ipv4Prefixes
    /**
     * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if you use `Ipv6Addresses`.
     */
    public val ipv6AddressCount: kotlin.Int? = builder.ipv6AddressCount
    /**
     * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you use `Ipv6AddressCount`.
     */
    public val ipv6Addresses: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails>? = builder.ipv6Addresses
    /**
     * The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv6Prefix` option.
     */
    public val ipv6PrefixCount: kotlin.Int? = builder.ipv6PrefixCount
    /**
     * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv6PrefixCount` option.
     */
    public val ipv6Prefixes: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails>? = builder.ipv6Prefixes
    /**
     * The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index `0`. The default is network card index `0`.
     */
    public val networkCardIndex: kotlin.Int? = builder.networkCardIndex
    /**
     * The ID of the network interface.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The primary private IPv4 address of the network interface.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * One or more private IPv4 addresses.
     */
    public val privateIpAddresses: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails>? = builder.privateIpAddresses
    /**
     * The number of secondary private IPv4 addresses to assign to a network interface.
     */
    public val secondaryPrivateIpAddressCount: kotlin.Int? = builder.secondaryPrivateIpAddressCount
    /**
     * The ID of the subnet for the network interface.
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(")
        append("associateCarrierIpAddress=$associateCarrierIpAddress,")
        append("associatePublicIpAddress=$associatePublicIpAddress,")
        append("deleteOnTermination=$deleteOnTermination,")
        append("description=$description,")
        append("deviceIndex=$deviceIndex,")
        append("groups=$groups,")
        append("interfaceType=$interfaceType,")
        append("ipv4PrefixCount=$ipv4PrefixCount,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("ipv6AddressCount=$ipv6AddressCount,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("ipv6PrefixCount=$ipv6PrefixCount,")
        append("ipv6Prefixes=$ipv6Prefixes,")
        append("networkCardIndex=$networkCardIndex,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("privateIpAddress=$privateIpAddress,")
        append("privateIpAddresses=$privateIpAddresses,")
        append("secondaryPrivateIpAddressCount=$secondaryPrivateIpAddressCount,")
        append("subnetId=$subnetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associateCarrierIpAddress?.hashCode() ?: 0
        result = 31 * result + (associatePublicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (deleteOnTermination?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (deviceIndex ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (interfaceType?.hashCode() ?: 0)
        result = 31 * result + (ipv4PrefixCount ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (ipv6AddressCount ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6PrefixCount ?: 0)
        result = 31 * result + (ipv6Prefixes?.hashCode() ?: 0)
        result = 31 * result + (networkCardIndex ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddresses?.hashCode() ?: 0)
        result = 31 * result + (secondaryPrivateIpAddressCount ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails

        if (associateCarrierIpAddress != other.associateCarrierIpAddress) return false
        if (associatePublicIpAddress != other.associatePublicIpAddress) return false
        if (deleteOnTermination != other.deleteOnTermination) return false
        if (description != other.description) return false
        if (deviceIndex != other.deviceIndex) return false
        if (groups != other.groups) return false
        if (interfaceType != other.interfaceType) return false
        if (ipv4PrefixCount != other.ipv4PrefixCount) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (ipv6AddressCount != other.ipv6AddressCount) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (ipv6PrefixCount != other.ipv6PrefixCount) return false
        if (ipv6Prefixes != other.ipv6Prefixes) return false
        if (networkCardIndex != other.networkCardIndex) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (privateIpAddresses != other.privateIpAddresses) return false
        if (secondaryPrivateIpAddressCount != other.secondaryPrivateIpAddressCount) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether to associate a Carrier IP address with eth0 for a new network interface. You use this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network interface. For more information, see [Carrier IP address](https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip) in the *Wavelength Developer Guide*.
         */
        public var associateCarrierIpAddress: kotlin.Boolean? = null
        /**
         * Associates a public IPv4 address with eth0 for a new network interface.
         */
        public var associatePublicIpAddress: kotlin.Boolean? = null
        /**
         * Indicates whether the network interface is deleted when the instance is terminated.
         */
        public var deleteOnTermination: kotlin.Boolean? = null
        /**
         * A description for the network interface.
         */
        public var description: kotlin.String? = null
        /**
         * The device index for the network interface attachment.
         */
        public var deviceIndex: kotlin.Int? = null
        /**
         * The IDs of one or more security groups.
         */
        public var groups: List<String>? = null
        /**
         * The type of network interface.
         */
        public var interfaceType: kotlin.String? = null
        /**
         * The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv4Prefixes` option.
         */
        public var ipv4PrefixCount: kotlin.Int? = null
        /**
         * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv4PrefixCount` option.
         */
        public var ipv4Prefixes: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails>? = null
        /**
         * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't use this option if you use `Ipv6Addresses`.
         */
        public var ipv6AddressCount: kotlin.Int? = null
        /**
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if you use `Ipv6AddressCount`.
         */
        public var ipv6Addresses: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails>? = null
        /**
         * The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this option if you use the `Ipv6Prefix` option.
         */
        public var ipv6PrefixCount: kotlin.Int? = null
        /**
         * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the `Ipv6PrefixCount` option.
         */
        public var ipv6Prefixes: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails>? = null
        /**
         * The index of the network card. Some instance types support multiple network cards. The primary network interface must be assigned to network card index `0`. The default is network card index `0`.
         */
        public var networkCardIndex: kotlin.Int? = null
        /**
         * The ID of the network interface.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The primary private IPv4 address of the network interface.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * One or more private IPv4 addresses.
         */
        public var privateIpAddresses: List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails>? = null
        /**
         * The number of secondary private IPv4 addresses to assign to a network interface.
         */
        public var secondaryPrivateIpAddressCount: kotlin.Int? = null
        /**
         * The ID of the subnet for the network interface.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) : this() {
            this.associateCarrierIpAddress = x.associateCarrierIpAddress
            this.associatePublicIpAddress = x.associatePublicIpAddress
            this.deleteOnTermination = x.deleteOnTermination
            this.description = x.description
            this.deviceIndex = x.deviceIndex
            this.groups = x.groups
            this.interfaceType = x.interfaceType
            this.ipv4PrefixCount = x.ipv4PrefixCount
            this.ipv4Prefixes = x.ipv4Prefixes
            this.ipv6AddressCount = x.ipv6AddressCount
            this.ipv6Addresses = x.ipv6Addresses
            this.ipv6PrefixCount = x.ipv6PrefixCount
            this.ipv6Prefixes = x.ipv6Prefixes
            this.networkCardIndex = x.networkCardIndex
            this.networkInterfaceId = x.networkInterfaceId
            this.privateIpAddress = x.privateIpAddress
            this.privateIpAddresses = x.privateIpAddresses
            this.secondaryPrivateIpAddressCount = x.secondaryPrivateIpAddressCount
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails = AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
