// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The details of an Amazon EC2 instance.
 */
public class AwsEc2InstanceDetails private constructor(builder: Builder) {
    /**
     * The IAM profile ARN of the instance.
     */
    public val iamInstanceProfileArn: kotlin.String? = builder.iamInstanceProfileArn
    /**
     * The Amazon Machine Image (AMI) ID of the instance.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The IPv4 addresses associated with the instance.
     */
    public val ipv4Addresses: List<String>? = builder.ipv4Addresses
    /**
     * The IPv6 addresses associated with the instance.
     */
    public val ipv6Addresses: List<String>? = builder.ipv6Addresses
    /**
     * The key name associated with the instance.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * Indicates when the instance was launched.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val launchedAt: kotlin.String? = builder.launchedAt
    /**
     * Details about the metadata options for the Amazon EC2 instance.
     */
    public val metadataOptions: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMetadataOptions? = builder.metadataOptions
    /**
     * Describes the type of monitoring that’s turned on for an instance.
     */
    public val monitoring: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMonitoringDetails? = builder.monitoring
    /**
     * The identifiers of the network interfaces for the EC2 instance. The details for each network interface are in a corresponding `AwsEc2NetworkInterfacesDetails` object.
     */
    public val networkInterfaces: List<AwsEc2InstanceNetworkInterfacesDetails>? = builder.networkInterfaces
    /**
     * The identifier of the subnet that the instance was launched in.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The instance type of the instance.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The virtualization type of the Amazon Machine Image (AMI) required to launch the instance.
     */
    public val virtualizationType: kotlin.String? = builder.virtualizationType
    /**
     * The identifier of the VPC that the instance was launched in.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2InstanceDetails(")
        append("iamInstanceProfileArn=$iamInstanceProfileArn,")
        append("imageId=$imageId,")
        append("ipv4Addresses=$ipv4Addresses,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("keyName=$keyName,")
        append("launchedAt=$launchedAt,")
        append("metadataOptions=$metadataOptions,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("subnetId=$subnetId,")
        append("type=$type,")
        append("virtualizationType=$virtualizationType,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iamInstanceProfileArn?.hashCode() ?: 0
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (ipv4Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchedAt?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2InstanceDetails

        if (iamInstanceProfileArn != other.iamInstanceProfileArn) return false
        if (imageId != other.imageId) return false
        if (ipv4Addresses != other.ipv4Addresses) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (keyName != other.keyName) return false
        if (launchedAt != other.launchedAt) return false
        if (metadataOptions != other.metadataOptions) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (subnetId != other.subnetId) return false
        if (type != other.type) return false
        if (virtualizationType != other.virtualizationType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IAM profile ARN of the instance.
         */
        public var iamInstanceProfileArn: kotlin.String? = null
        /**
         * The Amazon Machine Image (AMI) ID of the instance.
         */
        public var imageId: kotlin.String? = null
        /**
         * The IPv4 addresses associated with the instance.
         */
        public var ipv4Addresses: List<String>? = null
        /**
         * The IPv6 addresses associated with the instance.
         */
        public var ipv6Addresses: List<String>? = null
        /**
         * The key name associated with the instance.
         */
        public var keyName: kotlin.String? = null
        /**
         * Indicates when the instance was launched.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var launchedAt: kotlin.String? = null
        /**
         * Details about the metadata options for the Amazon EC2 instance.
         */
        public var metadataOptions: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMetadataOptions? = null
        /**
         * Describes the type of monitoring that’s turned on for an instance.
         */
        public var monitoring: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMonitoringDetails? = null
        /**
         * The identifiers of the network interfaces for the EC2 instance. The details for each network interface are in a corresponding `AwsEc2NetworkInterfacesDetails` object.
         */
        public var networkInterfaces: List<AwsEc2InstanceNetworkInterfacesDetails>? = null
        /**
         * The identifier of the subnet that the instance was launched in.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The instance type of the instance.
         */
        public var type: kotlin.String? = null
        /**
         * The virtualization type of the Amazon Machine Image (AMI) required to launch the instance.
         */
        public var virtualizationType: kotlin.String? = null
        /**
         * The identifier of the VPC that the instance was launched in.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails) : this() {
            this.iamInstanceProfileArn = x.iamInstanceProfileArn
            this.imageId = x.imageId
            this.ipv4Addresses = x.ipv4Addresses
            this.ipv6Addresses = x.ipv6Addresses
            this.keyName = x.keyName
            this.launchedAt = x.launchedAt
            this.metadataOptions = x.metadataOptions
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.subnetId = x.subnetId
            this.type = x.type
            this.virtualizationType = x.virtualizationType
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails = AwsEc2InstanceDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMetadataOptions] inside the given [block]
         */
        public fun metadataOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMetadataOptions.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMetadataOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMonitoringDetails] inside the given [block]
         */
        public fun monitoring(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMonitoringDetails.Builder.() -> kotlin.Unit) {
            this.monitoring = aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceMonitoringDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
