// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an Elastic IP address.
 */
public class AwsEc2EipDetails private constructor(builder: Builder) {
    /**
     * The identifier that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with Amazon VPC.
     */
    public val allocationId: kotlin.String? = builder.allocationId
    /**
     * The identifier that represents the association of the Elastic IP address with an EC2 instance.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The domain in which to allocate the address.
     *
     * If the address is for use with EC2 instances in a VPC, then `Domain` is `vpc`. Otherwise, `Domain` is `standard`.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The identifier of the EC2 instance.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of the location from which the Elastic IP address is advertised.
     */
    public val networkBorderGroup: kotlin.String? = builder.networkBorderGroup
    /**
     * The identifier of the network interface.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The Amazon Web Services account ID of the owner of the network interface.
     */
    public val networkInterfaceOwnerId: kotlin.String? = builder.networkInterfaceOwnerId
    /**
     * The private IP address that is associated with the Elastic IP address.
     */
    public val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * A public IP address that is associated with the EC2 instance.
     */
    public val publicIp: kotlin.String? = builder.publicIp
    /**
     * The identifier of an IP address pool. This parameter allows Amazon EC2 to select an IP address from the address pool.
     */
    public val publicIpv4Pool: kotlin.String? = builder.publicIpv4Pool

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2EipDetails(")
        append("allocationId=$allocationId,")
        append("associationId=$associationId,")
        append("domain=$domain,")
        append("instanceId=$instanceId,")
        append("networkBorderGroup=$networkBorderGroup,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("networkInterfaceOwnerId=$networkInterfaceOwnerId,")
        append("privateIpAddress=$privateIpAddress,")
        append("publicIp=$publicIp,")
        append("publicIpv4Pool=$publicIpv4Pool")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationId?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (networkBorderGroup?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (publicIp?.hashCode() ?: 0)
        result = 31 * result + (publicIpv4Pool?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2EipDetails

        if (allocationId != other.allocationId) return false
        if (associationId != other.associationId) return false
        if (domain != other.domain) return false
        if (instanceId != other.instanceId) return false
        if (networkBorderGroup != other.networkBorderGroup) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (networkInterfaceOwnerId != other.networkInterfaceOwnerId) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (publicIp != other.publicIp) return false
        if (publicIpv4Pool != other.publicIpv4Pool) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier that Amazon Web Services assigns to represent the allocation of the Elastic IP address for use with Amazon VPC.
         */
        public var allocationId: kotlin.String? = null
        /**
         * The identifier that represents the association of the Elastic IP address with an EC2 instance.
         */
        public var associationId: kotlin.String? = null
        /**
         * The domain in which to allocate the address.
         *
         * If the address is for use with EC2 instances in a VPC, then `Domain` is `vpc`. Otherwise, `Domain` is `standard`.
         */
        public var domain: kotlin.String? = null
        /**
         * The identifier of the EC2 instance.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of the location from which the Elastic IP address is advertised.
         */
        public var networkBorderGroup: kotlin.String? = null
        /**
         * The identifier of the network interface.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the owner of the network interface.
         */
        public var networkInterfaceOwnerId: kotlin.String? = null
        /**
         * The private IP address that is associated with the Elastic IP address.
         */
        public var privateIpAddress: kotlin.String? = null
        /**
         * A public IP address that is associated with the EC2 instance.
         */
        public var publicIp: kotlin.String? = null
        /**
         * The identifier of an IP address pool. This parameter allows Amazon EC2 to select an IP address from the address pool.
         */
        public var publicIpv4Pool: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails) : this() {
            this.allocationId = x.allocationId
            this.associationId = x.associationId
            this.domain = x.domain
            this.instanceId = x.instanceId
            this.networkBorderGroup = x.networkBorderGroup
            this.networkInterfaceId = x.networkInterfaceId
            this.networkInterfaceOwnerId = x.networkInterfaceOwnerId
            this.privateIpAddress = x.privateIpAddress
            this.publicIp = x.publicIp
            this.publicIpv4Pool = x.publicIpv4Pool
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails = AwsEc2EipDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
