// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Database Migration Service (DMS) replication task. A replication task moves a set of data from the source endpoint to the target endpoint.
 */
public class AwsDmsReplicationTaskDetails private constructor(builder: Builder) {
    /**
     * Indicates when you want a change data capture (CDC) operation to start. `CCdcStartPosition` or `CCdcStartTime` specifies when you want a CDC operation to start. Only a value for one of these fields is included.
     */
    public val cdcStartPosition: kotlin.String? = builder.cdcStartPosition
    /**
     * Indicates the start time for a CDC operation. `CdcStartPosition` or `CCdcStartTime` specifies when you want a CDC operation to start. Only a value for one of these fields is included.
     */
    public val cdcStartTime: kotlin.String? = builder.cdcStartTime
    /**
     * Indicates when you want a CDC operation to stop. The value can be either server time or commit time.
     */
    public val cdcStopPosition: kotlin.String? = builder.cdcStopPosition
    /**
     * The identifier of the replication task.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The migration type.
     */
    public val migrationType: kotlin.String? = builder.migrationType
    /**
     * The Amazon Resource Name (ARN) of a replication instance.
     */
    public val replicationInstanceArn: kotlin.String? = builder.replicationInstanceArn
    /**
     * The user-defined replication task identifier or name.
     */
    public val replicationTaskIdentifier: kotlin.String? = builder.replicationTaskIdentifier
    /**
     * The settings for the replication task.
     */
    public val replicationTaskSettings: kotlin.String? = builder.replicationTaskSettings
    /**
     * A display name for the resource identifier at the end of the `EndpointArn` response parameter. If you don't specify a `ResourceIdentifier` value, DMS generates a default identifier value for the end of `EndpointArn`.
     */
    public val resourceIdentifier: kotlin.String? = builder.resourceIdentifier
    /**
     * The ARN of the source endpoint.
     */
    public val sourceEndpointArn: kotlin.String? = builder.sourceEndpointArn
    /**
     * The table mappings for the replication task, in JSON format.
     */
    public val tableMappings: kotlin.String? = builder.tableMappings
    /**
     * The ARN of the target endpoint.
     */
    public val targetEndpointArn: kotlin.String? = builder.targetEndpointArn
    /**
     * Supplemental information that the task requires to migrate the data for certain source and target endpoints.
     */
    public val taskData: kotlin.String? = builder.taskData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationTaskDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsDmsReplicationTaskDetails(")
        append("cdcStartPosition=$cdcStartPosition,")
        append("cdcStartTime=$cdcStartTime,")
        append("cdcStopPosition=$cdcStopPosition,")
        append("id=$id,")
        append("migrationType=$migrationType,")
        append("replicationInstanceArn=$replicationInstanceArn,")
        append("replicationTaskIdentifier=$replicationTaskIdentifier,")
        append("replicationTaskSettings=$replicationTaskSettings,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("sourceEndpointArn=$sourceEndpointArn,")
        append("tableMappings=$tableMappings,")
        append("targetEndpointArn=$targetEndpointArn,")
        append("taskData=$taskData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cdcStartPosition?.hashCode() ?: 0
        result = 31 * result + (cdcStartTime?.hashCode() ?: 0)
        result = 31 * result + (cdcStopPosition?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (migrationType?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskIdentifier?.hashCode() ?: 0)
        result = 31 * result + (replicationTaskSettings?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (tableMappings?.hashCode() ?: 0)
        result = 31 * result + (targetEndpointArn?.hashCode() ?: 0)
        result = 31 * result + (taskData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsDmsReplicationTaskDetails

        if (cdcStartPosition != other.cdcStartPosition) return false
        if (cdcStartTime != other.cdcStartTime) return false
        if (cdcStopPosition != other.cdcStopPosition) return false
        if (id != other.id) return false
        if (migrationType != other.migrationType) return false
        if (replicationInstanceArn != other.replicationInstanceArn) return false
        if (replicationTaskIdentifier != other.replicationTaskIdentifier) return false
        if (replicationTaskSettings != other.replicationTaskSettings) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (sourceEndpointArn != other.sourceEndpointArn) return false
        if (tableMappings != other.tableMappings) return false
        if (targetEndpointArn != other.targetEndpointArn) return false
        if (taskData != other.taskData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationTaskDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates when you want a change data capture (CDC) operation to start. `CCdcStartPosition` or `CCdcStartTime` specifies when you want a CDC operation to start. Only a value for one of these fields is included.
         */
        public var cdcStartPosition: kotlin.String? = null
        /**
         * Indicates the start time for a CDC operation. `CdcStartPosition` or `CCdcStartTime` specifies when you want a CDC operation to start. Only a value for one of these fields is included.
         */
        public var cdcStartTime: kotlin.String? = null
        /**
         * Indicates when you want a CDC operation to stop. The value can be either server time or commit time.
         */
        public var cdcStopPosition: kotlin.String? = null
        /**
         * The identifier of the replication task.
         */
        public var id: kotlin.String? = null
        /**
         * The migration type.
         */
        public var migrationType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a replication instance.
         */
        public var replicationInstanceArn: kotlin.String? = null
        /**
         * The user-defined replication task identifier or name.
         */
        public var replicationTaskIdentifier: kotlin.String? = null
        /**
         * The settings for the replication task.
         */
        public var replicationTaskSettings: kotlin.String? = null
        /**
         * A display name for the resource identifier at the end of the `EndpointArn` response parameter. If you don't specify a `ResourceIdentifier` value, DMS generates a default identifier value for the end of `EndpointArn`.
         */
        public var resourceIdentifier: kotlin.String? = null
        /**
         * The ARN of the source endpoint.
         */
        public var sourceEndpointArn: kotlin.String? = null
        /**
         * The table mappings for the replication task, in JSON format.
         */
        public var tableMappings: kotlin.String? = null
        /**
         * The ARN of the target endpoint.
         */
        public var targetEndpointArn: kotlin.String? = null
        /**
         * Supplemental information that the task requires to migrate the data for certain source and target endpoints.
         */
        public var taskData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationTaskDetails) : this() {
            this.cdcStartPosition = x.cdcStartPosition
            this.cdcStartTime = x.cdcStartTime
            this.cdcStopPosition = x.cdcStopPosition
            this.id = x.id
            this.migrationType = x.migrationType
            this.replicationInstanceArn = x.replicationInstanceArn
            this.replicationTaskIdentifier = x.replicationTaskIdentifier
            this.replicationTaskSettings = x.replicationTaskSettings
            this.resourceIdentifier = x.resourceIdentifier
            this.sourceEndpointArn = x.sourceEndpointArn
            this.tableMappings = x.tableMappings
            this.targetEndpointArn = x.targetEndpointArn
            this.taskData = x.taskData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationTaskDetails = AwsDmsReplicationTaskDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
