// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Database Migration Service (DMS) replication instance. DMS uses a replication instance to connect to your source data store, read the source data, and format the data for consumption by the target data store.
 */
public class AwsDmsReplicationInstanceDetails private constructor(builder: Builder) {
    /**
     * The amount of storage (in gigabytes) that is allocated for the replication instance.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Availability Zone that the replication instance is created in. The default value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, such as `us-east-1d`.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The engine version number of the replication instance. If an engine version number is not specified when a replication instance is created, the default is the latest engine version available.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * An KMS key identifier that is used to encrypt the data on the replication instance. If you don't specify a value for the `KmsKeyId` parameter, DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies whether the replication instance is deployed across multiple Availability Zones (AZs). You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true`.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The maintenance window times for the replication instance. Upgrades to the replication instance are performed during this time.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies the accessibility options for the replication instance. A value of `true` represents an instance with a public IP address. A value of `false` represents an instance with a private IP address. The default value is `true`.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The compute and memory capacity of the replication instance as defined for the specified replication instance class.
     */
    public val replicationInstanceClass: kotlin.String? = builder.replicationInstanceClass
    /**
     * The replication instance identifier.
     */
    public val replicationInstanceIdentifier: kotlin.String? = builder.replicationInstanceIdentifier
    /**
     * The subnet group for the replication instance.
     */
    public val replicationSubnetGroup: aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails? = builder.replicationSubnetGroup
    /**
     * The virtual private cloud (VPC) security group for the replication instance.
     */
    public val vpcSecurityGroups: List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsDmsReplicationInstanceDetails(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("multiAz=$multiAz,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("replicationInstanceClass=$replicationInstanceClass,")
        append("replicationInstanceIdentifier=$replicationInstanceIdentifier,")
        append("replicationSubnetGroup=$replicationSubnetGroup,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (replicationInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (replicationSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsDmsReplicationInstanceDetails

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (multiAz != other.multiAz) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (replicationInstanceClass != other.replicationInstanceClass) return false
        if (replicationInstanceIdentifier != other.replicationInstanceIdentifier) return false
        if (replicationSubnetGroup != other.replicationSubnetGroup) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of storage (in gigabytes) that is allocated for the replication instance.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Indicates whether minor engine upgrades are applied automatically to the replication instance during the maintenance window.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Availability Zone that the replication instance is created in. The default value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, such as `us-east-1d`.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The engine version number of the replication instance. If an engine version number is not specified when a replication instance is created, the default is the latest engine version available.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * An KMS key identifier that is used to encrypt the data on the replication instance. If you don't specify a value for the `KmsKeyId` parameter, DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies whether the replication instance is deployed across multiple Availability Zones (AZs). You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true`.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The maintenance window times for the replication instance. Upgrades to the replication instance are performed during this time.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies the accessibility options for the replication instance. A value of `true` represents an instance with a public IP address. A value of `false` represents an instance with a private IP address. The default value is `true`.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The compute and memory capacity of the replication instance as defined for the specified replication instance class.
         */
        public var replicationInstanceClass: kotlin.String? = null
        /**
         * The replication instance identifier.
         */
        public var replicationInstanceIdentifier: kotlin.String? = null
        /**
         * The subnet group for the replication instance.
         */
        public var replicationSubnetGroup: aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails? = null
        /**
         * The virtual private cloud (VPC) security group for the replication instance.
         */
        public var vpcSecurityGroups: List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceDetails) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.multiAz = x.multiAz
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.replicationInstanceClass = x.replicationInstanceClass
            this.replicationInstanceIdentifier = x.replicationInstanceIdentifier
            this.replicationSubnetGroup = x.replicationSubnetGroup
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceDetails = AwsDmsReplicationInstanceDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails] inside the given [block]
         */
        public fun replicationSubnetGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder.() -> kotlin.Unit) {
            this.replicationSubnetGroup = aws.sdk.kotlin.services.securityhub.model.AwsDmsReplicationInstanceReplicationSubnetGroupDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
