// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Database Migration Service (DMS) endpoint. An endpoint provides connection, data store type, and location information about your data store.
 */
public class AwsDmsEndpointDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the SSL certificate that encrypts connections between the DMS endpoint and the replication instance.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The name of the endpoint database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The Amazon Resource Name (ARN) of the endpoint.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The database endpoint identifier.
     */
    public val endpointIdentifier: kotlin.String? = builder.endpointIdentifier
    /**
     * The type of endpoint. Valid values are source and target.
     */
    public val endpointType: kotlin.String? = builder.endpointType
    /**
     * The type of engine for the endpoint, depending on the `EndpointType` value.
     */
    public val engineName: kotlin.String? = builder.engineName
    /**
     * A value that can be used for cross-account validation.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * Additional attributes associated with the connection.
     */
    public val extraConnectionAttributes: kotlin.String? = builder.extraConnectionAttributes
    /**
     * An DMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don't specify a value for the `KmsKeyId` parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The port used to access the endpoint.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The name of the server where the endpoint database resides.
     */
    public val serverName: kotlin.String? = builder.serverName
    /**
     * The SSL mode used to connect to the endpoint. The default is none.
     */
    public val sslMode: kotlin.String? = builder.sslMode
    /**
     * The user name to be used to log in to the endpoint database.
     */
    public val username: kotlin.String? = builder.username

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsDmsEndpointDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsDmsEndpointDetails(")
        append("certificateArn=$certificateArn,")
        append("databaseName=$databaseName,")
        append("endpointArn=$endpointArn,")
        append("endpointIdentifier=$endpointIdentifier,")
        append("endpointType=$endpointType,")
        append("engineName=$engineName,")
        append("externalId=$externalId,")
        append("extraConnectionAttributes=$extraConnectionAttributes,")
        append("kmsKeyId=$kmsKeyId,")
        append("port=$port,")
        append("serverName=$serverName,")
        append("sslMode=$sslMode,")
        append("username=$username")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (endpointIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (engineName?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (extraConnectionAttributes?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (serverName?.hashCode() ?: 0)
        result = 31 * result + (sslMode?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsDmsEndpointDetails

        if (certificateArn != other.certificateArn) return false
        if (databaseName != other.databaseName) return false
        if (endpointArn != other.endpointArn) return false
        if (endpointIdentifier != other.endpointIdentifier) return false
        if (endpointType != other.endpointType) return false
        if (engineName != other.engineName) return false
        if (externalId != other.externalId) return false
        if (extraConnectionAttributes != other.extraConnectionAttributes) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (port != other.port) return false
        if (serverName != other.serverName) return false
        if (sslMode != other.sslMode) return false
        if (username != other.username) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsDmsEndpointDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the SSL certificate that encrypts connections between the DMS endpoint and the replication instance.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The name of the endpoint database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint.
         */
        public var endpointArn: kotlin.String? = null
        /**
         * The database endpoint identifier.
         */
        public var endpointIdentifier: kotlin.String? = null
        /**
         * The type of endpoint. Valid values are source and target.
         */
        public var endpointType: kotlin.String? = null
        /**
         * The type of engine for the endpoint, depending on the `EndpointType` value.
         */
        public var engineName: kotlin.String? = null
        /**
         * A value that can be used for cross-account validation.
         */
        public var externalId: kotlin.String? = null
        /**
         * Additional attributes associated with the connection.
         */
        public var extraConnectionAttributes: kotlin.String? = null
        /**
         * An DMS key identifier that is used to encrypt the connection parameters for the endpoint. If you don't specify a value for the `KmsKeyId` parameter, then DMS uses your default encryption key. KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The port used to access the endpoint.
         */
        public var port: kotlin.Int? = null
        /**
         * The name of the server where the endpoint database resides.
         */
        public var serverName: kotlin.String? = null
        /**
         * The SSL mode used to connect to the endpoint. The default is none.
         */
        public var sslMode: kotlin.String? = null
        /**
         * The user name to be used to log in to the endpoint database.
         */
        public var username: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsDmsEndpointDetails) : this() {
            this.certificateArn = x.certificateArn
            this.databaseName = x.databaseName
            this.endpointArn = x.endpointArn
            this.endpointIdentifier = x.endpointIdentifier
            this.endpointType = x.endpointType
            this.engineName = x.engineName
            this.externalId = x.externalId
            this.extraConnectionAttributes = x.extraConnectionAttributes
            this.kmsKeyId = x.kmsKeyId
            this.port = x.port
            this.serverName = x.serverName
            this.sslMode = x.sslMode
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsDmsEndpointDetails = AwsDmsEndpointDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
