// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Backup backup vault. In Backup, a backup vault is a container that stores and organizes your backups.
 */
public class AwsBackupBackupVaultDetails private constructor(builder: Builder) {
    /**
     * A resource-based policy that is used to manage access permissions on the target backup vault.
     */
    public val accessPolicy: kotlin.String? = builder.accessPolicy
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
     */
    public val backupVaultArn: kotlin.String? = builder.backupVaultArn
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = builder.backupVaultName
    /**
     * The unique ARN associated with the server-side encryption key. You can specify a key to encrypt your backups from services that support full Backup management. If you do not specify a key, Backup creates an KMS key for you by default.
     */
    public val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn
    /**
     * The Amazon SNS event notifications for the specified backup vault.
     */
    public val notifications: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails? = builder.notifications

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsBackupBackupVaultDetails(")
        append("accessPolicy=$accessPolicy,")
        append("backupVaultArn=$backupVaultArn,")
        append("backupVaultName=$backupVaultName,")
        append("encryptionKeyArn=$encryptionKeyArn,")
        append("notifications=$notifications")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicy?.hashCode() ?: 0
        result = 31 * result + (backupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (notifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsBackupBackupVaultDetails

        if (accessPolicy != other.accessPolicy) return false
        if (backupVaultArn != other.backupVaultArn) return false
        if (backupVaultName != other.backupVaultName) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false
        if (notifications != other.notifications) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A resource-based policy that is used to manage access permissions on the target backup vault.
         */
        public var accessPolicy: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
         */
        public var backupVaultArn: kotlin.String? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The unique ARN associated with the server-side encryption key. You can specify a key to encrypt your backups from services that support full Backup management. If you do not specify a key, Backup creates an KMS key for you by default.
         */
        public var encryptionKeyArn: kotlin.String? = null
        /**
         * The Amazon SNS event notifications for the specified backup vault.
         */
        public var notifications: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails) : this() {
            this.accessPolicy = x.accessPolicy
            this.backupVaultArn = x.backupVaultArn
            this.backupVaultName = x.backupVaultName
            this.encryptionKeyArn = x.encryptionKeyArn
            this.notifications = x.notifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails = AwsBackupBackupVaultDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails] inside the given [block]
         */
        public fun notifications(block: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails.Builder.() -> kotlin.Unit) {
            this.notifications = aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultNotificationsDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
