// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an auto scaling group.
 */
public class AwsAutoScalingAutoScalingGroupDetails private constructor(builder: Builder) {
    /**
     * The list of Availability Zones for the automatic scaling group.
     */
    public val availabilityZones: List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>? = builder.availabilityZones
    /**
     * Indicates whether capacity rebalancing is enabled.
     */
    public val capacityRebalance: kotlin.Boolean? = builder.capacityRebalance
    /**
     * Indicates when the auto scaling group was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdTime: kotlin.String? = builder.createdTime
    /**
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2 instance that has come into service.
     */
    public val healthCheckGracePeriod: kotlin.Int? = builder.healthCheckGracePeriod
    /**
     * The service to use for the health checks. Valid values are `EC2` or `ELB`.
     */
    public val healthCheckType: kotlin.String? = builder.healthCheckType
    /**
     * The name of the launch configuration.
     */
    public val launchConfigurationName: kotlin.String? = builder.launchConfigurationName
    /**
     * The launch template to use.
     */
    public val launchTemplate: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The list of load balancers associated with the group.
     */
    public val loadBalancerNames: List<String>? = builder.loadBalancerNames
    /**
     * The mixed instances policy for the automatic scaling group.
     */
    public val mixedInstancesPolicy: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails? = builder.mixedInstancesPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAutoScalingAutoScalingGroupDetails(")
        append("availabilityZones=$availabilityZones,")
        append("capacityRebalance=$capacityRebalance,")
        append("createdTime=$createdTime,")
        append("healthCheckGracePeriod=$healthCheckGracePeriod,")
        append("healthCheckType=$healthCheckType,")
        append("launchConfigurationName=$launchConfigurationName,")
        append("launchTemplate=$launchTemplate,")
        append("loadBalancerNames=$loadBalancerNames,")
        append("mixedInstancesPolicy=$mixedInstancesPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (capacityRebalance?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (healthCheckGracePeriod ?: 0)
        result = 31 * result + (healthCheckType?.hashCode() ?: 0)
        result = 31 * result + (launchConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerNames?.hashCode() ?: 0)
        result = 31 * result + (mixedInstancesPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsAutoScalingAutoScalingGroupDetails

        if (availabilityZones != other.availabilityZones) return false
        if (capacityRebalance != other.capacityRebalance) return false
        if (createdTime != other.createdTime) return false
        if (healthCheckGracePeriod != other.healthCheckGracePeriod) return false
        if (healthCheckType != other.healthCheckType) return false
        if (launchConfigurationName != other.launchConfigurationName) return false
        if (launchTemplate != other.launchTemplate) return false
        if (loadBalancerNames != other.loadBalancerNames) return false
        if (mixedInstancesPolicy != other.mixedInstancesPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of Availability Zones for the automatic scaling group.
         */
        public var availabilityZones: List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>? = null
        /**
         * Indicates whether capacity rebalancing is enabled.
         */
        public var capacityRebalance: kotlin.Boolean? = null
        /**
         * Indicates when the auto scaling group was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdTime: kotlin.String? = null
        /**
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2 instance that has come into service.
         */
        public var healthCheckGracePeriod: kotlin.Int? = null
        /**
         * The service to use for the health checks. Valid values are `EC2` or `ELB`.
         */
        public var healthCheckType: kotlin.String? = null
        /**
         * The name of the launch configuration.
         */
        public var launchConfigurationName: kotlin.String? = null
        /**
         * The launch template to use.
         */
        public var launchTemplate: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification? = null
        /**
         * The list of load balancers associated with the group.
         */
        public var loadBalancerNames: List<String>? = null
        /**
         * The mixed instances policy for the automatic scaling group.
         */
        public var mixedInstancesPolicy: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails) : this() {
            this.availabilityZones = x.availabilityZones
            this.capacityRebalance = x.capacityRebalance
            this.createdTime = x.createdTime
            this.healthCheckGracePeriod = x.healthCheckGracePeriod
            this.healthCheckType = x.healthCheckType
            this.launchConfigurationName = x.launchConfigurationName
            this.launchTemplate = x.launchTemplate
            this.loadBalancerNames = x.loadBalancerNames
            this.mixedInstancesPolicy = x.mixedInstancesPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails = AwsAutoScalingAutoScalingGroupDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification] inside the given [block]
         */
        public fun launchTemplate(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails] inside the given [block]
         */
        public fun mixedInstancesPolicy(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder.() -> kotlin.Unit) {
            this.mixedInstancesPolicy = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
