// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about a version 2 stage for Amazon API Gateway.
 */
public class AwsApiGatewayV2StageDetails private constructor(builder: Builder) {
    /**
     * Information about settings for logging access for the stage.
     */
    public val accessLogSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings? = builder.accessLogSettings
    /**
     * Indicates whether the stage is managed by API Gateway.
     */
    public val apiGatewayManaged: kotlin.Boolean? = builder.apiGatewayManaged
    /**
     * Indicates whether updates to an API automatically trigger a new deployment.
     */
    public val autoDeploy: kotlin.Boolean? = builder.autoDeploy
    /**
     * The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
     */
    public val clientCertificateId: kotlin.String? = builder.clientCertificateId
    /**
     * Indicates when the stage was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdDate: kotlin.String? = builder.createdDate
    /**
     * Default route settings for the stage.
     */
    public val defaultRouteSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = builder.defaultRouteSettings
    /**
     * The identifier of the deployment that the stage is associated with.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The description of the stage.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The status of the last deployment of a stage. Supported only if the stage has automatic deployment enabled.
     */
    public val lastDeploymentStatusMessage: kotlin.String? = builder.lastDeploymentStatusMessage
    /**
     * Indicates when the stage was most recently updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val lastUpdatedDate: kotlin.String? = builder.lastUpdatedDate
    /**
     * The route settings for the stage.
     */
    public val routeSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = builder.routeSettings
    /**
     * The name of the stage.
     */
    public val stageName: kotlin.String? = builder.stageName
    /**
     * A map that defines the stage variables for the stage.
     *
     * Variable names can have alphanumeric and underscore characters.
     *
     * Variable values can contain the following characters:
     * + Uppercase and lowercase letters
     * + Numbers
     * + Special characters -._~:/?#&=,
     */
    public val stageVariables: Map<String, String>? = builder.stageVariables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiGatewayV2StageDetails(")
        append("accessLogSettings=$accessLogSettings,")
        append("apiGatewayManaged=$apiGatewayManaged,")
        append("autoDeploy=$autoDeploy,")
        append("clientCertificateId=$clientCertificateId,")
        append("createdDate=$createdDate,")
        append("defaultRouteSettings=$defaultRouteSettings,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("lastDeploymentStatusMessage=$lastDeploymentStatusMessage,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("routeSettings=$routeSettings,")
        append("stageName=$stageName,")
        append("stageVariables=$stageVariables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLogSettings?.hashCode() ?: 0
        result = 31 * result + (apiGatewayManaged?.hashCode() ?: 0)
        result = 31 * result + (autoDeploy?.hashCode() ?: 0)
        result = 31 * result + (clientCertificateId?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteSettings?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastDeploymentStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (routeSettings?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (stageVariables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiGatewayV2StageDetails

        if (accessLogSettings != other.accessLogSettings) return false
        if (apiGatewayManaged != other.apiGatewayManaged) return false
        if (autoDeploy != other.autoDeploy) return false
        if (clientCertificateId != other.clientCertificateId) return false
        if (createdDate != other.createdDate) return false
        if (defaultRouteSettings != other.defaultRouteSettings) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (lastDeploymentStatusMessage != other.lastDeploymentStatusMessage) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (routeSettings != other.routeSettings) return false
        if (stageName != other.stageName) return false
        if (stageVariables != other.stageVariables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about settings for logging access for the stage.
         */
        public var accessLogSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings? = null
        /**
         * Indicates whether the stage is managed by API Gateway.
         */
        public var apiGatewayManaged: kotlin.Boolean? = null
        /**
         * Indicates whether updates to an API automatically trigger a new deployment.
         */
        public var autoDeploy: kotlin.Boolean? = null
        /**
         * The identifier of a client certificate for a stage. Supported only for WebSocket API calls.
         */
        public var clientCertificateId: kotlin.String? = null
        /**
         * Indicates when the stage was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdDate: kotlin.String? = null
        /**
         * Default route settings for the stage.
         */
        public var defaultRouteSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = null
        /**
         * The identifier of the deployment that the stage is associated with.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The description of the stage.
         */
        public var description: kotlin.String? = null
        /**
         * The status of the last deployment of a stage. Supported only if the stage has automatic deployment enabled.
         */
        public var lastDeploymentStatusMessage: kotlin.String? = null
        /**
         * Indicates when the stage was most recently updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var lastUpdatedDate: kotlin.String? = null
        /**
         * The route settings for the stage.
         */
        public var routeSettings: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings? = null
        /**
         * The name of the stage.
         */
        public var stageName: kotlin.String? = null
        /**
         * A map that defines the stage variables for the stage.
         *
         * Variable names can have alphanumeric and underscore characters.
         *
         * Variable values can contain the following characters:
         * + Uppercase and lowercase letters
         * + Numbers
         * + Special characters -._~:/?#&=,
         */
        public var stageVariables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails) : this() {
            this.accessLogSettings = x.accessLogSettings
            this.apiGatewayManaged = x.apiGatewayManaged
            this.autoDeploy = x.autoDeploy
            this.clientCertificateId = x.clientCertificateId
            this.createdDate = x.createdDate
            this.defaultRouteSettings = x.defaultRouteSettings
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.lastDeploymentStatusMessage = x.lastDeploymentStatusMessage
            this.lastUpdatedDate = x.lastUpdatedDate
            this.routeSettings = x.routeSettings
            this.stageName = x.stageName
            this.stageVariables = x.stageVariables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails = AwsApiGatewayV2StageDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings] inside the given [block]
         */
        public fun accessLogSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings.Builder.() -> kotlin.Unit) {
            this.accessLogSettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayAccessLogSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings] inside the given [block]
         */
        public fun defaultRouteSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.Builder.() -> kotlin.Unit) {
            this.defaultRouteSettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings] inside the given [block]
         */
        public fun routeSettings(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.Builder.() -> kotlin.Unit) {
            this.routeSettings = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2RouteSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
