// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about a version 2 API in Amazon API Gateway.
 */
public class AwsApiGatewayV2ApiDetails private constructor(builder: Builder) {
    /**
     * The URI of the API.
     *
     * Uses the format ` <i><api-id></i>.execute-api.<i><region></i>.amazonaws.com`
     *
     * The stage name is typically appended to the URI to form a complete path to a deployed API stage.
     */
    public val apiEndpoint: kotlin.String? = builder.apiEndpoint
    /**
     * The identifier of the API.
     */
    public val apiId: kotlin.String? = builder.apiId
    /**
     * An API key selection expression. Supported only for WebSocket APIs.
     */
    public val apiKeySelectionExpression: kotlin.String? = builder.apiKeySelectionExpression
    /**
     * A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.
     */
    public val corsConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration? = builder.corsConfiguration
    /**
     * Indicates when the API was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdDate: kotlin.String? = builder.createdDate
    /**
     * A description of the API.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the API.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The API protocol for the API.
     *
     * Valid values: `WEBSOCKET` | `HTTP`
     */
    public val protocolType: kotlin.String? = builder.protocolType
    /**
     * The route selection expression for the API.
     *
     * For HTTP APIs, must be `${request.method} ${request.path}`. This is the default value for HTTP APIs.
     *
     * For WebSocket APIs, there is no default value.
     */
    public val routeSelectionExpression: kotlin.String? = builder.routeSelectionExpression
    /**
     * The version identifier for the API.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiGatewayV2ApiDetails(")
        append("apiEndpoint=$apiEndpoint,")
        append("apiId=$apiId,")
        append("apiKeySelectionExpression=$apiKeySelectionExpression,")
        append("corsConfiguration=$corsConfiguration,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("name=$name,")
        append("protocolType=$protocolType,")
        append("routeSelectionExpression=$routeSelectionExpression,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiEndpoint?.hashCode() ?: 0
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (apiKeySelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (corsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protocolType?.hashCode() ?: 0)
        result = 31 * result + (routeSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiGatewayV2ApiDetails

        if (apiEndpoint != other.apiEndpoint) return false
        if (apiId != other.apiId) return false
        if (apiKeySelectionExpression != other.apiKeySelectionExpression) return false
        if (corsConfiguration != other.corsConfiguration) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (protocolType != other.protocolType) return false
        if (routeSelectionExpression != other.routeSelectionExpression) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URI of the API.
         *
         * Uses the format ` <i><api-id></i>.execute-api.<i><region></i>.amazonaws.com`
         *
         * The stage name is typically appended to the URI to form a complete path to a deployed API stage.
         */
        public var apiEndpoint: kotlin.String? = null
        /**
         * The identifier of the API.
         */
        public var apiId: kotlin.String? = null
        /**
         * An API key selection expression. Supported only for WebSocket APIs.
         */
        public var apiKeySelectionExpression: kotlin.String? = null
        /**
         * A cross-origin resource sharing (CORS) configuration. Supported only for HTTP APIs.
         */
        public var corsConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration? = null
        /**
         * Indicates when the API was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdDate: kotlin.String? = null
        /**
         * A description of the API.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the API.
         */
        public var name: kotlin.String? = null
        /**
         * The API protocol for the API.
         *
         * Valid values: `WEBSOCKET` | `HTTP`
         */
        public var protocolType: kotlin.String? = null
        /**
         * The route selection expression for the API.
         *
         * For HTTP APIs, must be `${request.method} ${request.path}`. This is the default value for HTTP APIs.
         *
         * For WebSocket APIs, there is no default value.
         */
        public var routeSelectionExpression: kotlin.String? = null
        /**
         * The version identifier for the API.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails) : this() {
            this.apiEndpoint = x.apiEndpoint
            this.apiId = x.apiId
            this.apiKeySelectionExpression = x.apiKeySelectionExpression
            this.corsConfiguration = x.corsConfiguration
            this.createdDate = x.createdDate
            this.description = x.description
            this.name = x.name
            this.protocolType = x.protocolType
            this.routeSelectionExpression = x.routeSelectionExpression
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails = AwsApiGatewayV2ApiDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration] inside the given [block]
         */
        public fun corsConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration.Builder.() -> kotlin.Unit) {
            this.corsConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsCorsConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
