// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about a REST API in version 1 of Amazon API Gateway.
 */
public class AwsApiGatewayRestApiDetails private constructor(builder: Builder) {
    /**
     * The source of the API key for metering requests according to a usage plan.
     *
     * `HEADER` indicates whether to read the API key from the X-API-Key header of a request.
     *
     * `AUTHORIZER` indicates whether to read the API key from the `UsageIdentifierKey` from a custom authorizer.
     */
    public val apiKeySource: kotlin.String? = builder.apiKeySource
    /**
     * The list of binary media types supported by the REST API.
     */
    public val binaryMediaTypes: List<String>? = builder.binaryMediaTypes
    /**
     * Indicates when the API was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createdDate: kotlin.String? = builder.createdDate
    /**
     * A description of the REST API.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The endpoint configuration of the REST API.
     */
    public val endpointConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayEndpointConfiguration? = builder.endpointConfiguration
    /**
     * The identifier of the REST API.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The minimum size in bytes of a payload before compression is enabled.
     *
     * If `null`, then compression is disabled.
     *
     * If 0, then all payloads are compressed.
     */
    public val minimumCompressionSize: kotlin.Int? = builder.minimumCompressionSize
    /**
     * The name of the REST API.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The version identifier for the REST API.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiGatewayRestApiDetails(")
        append("apiKeySource=$apiKeySource,")
        append("binaryMediaTypes=$binaryMediaTypes,")
        append("createdDate=$createdDate,")
        append("description=$description,")
        append("endpointConfiguration=$endpointConfiguration,")
        append("id=$id,")
        append("minimumCompressionSize=$minimumCompressionSize,")
        append("name=$name,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeySource?.hashCode() ?: 0
        result = 31 * result + (binaryMediaTypes?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointConfiguration?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (minimumCompressionSize ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiGatewayRestApiDetails

        if (apiKeySource != other.apiKeySource) return false
        if (binaryMediaTypes != other.binaryMediaTypes) return false
        if (createdDate != other.createdDate) return false
        if (description != other.description) return false
        if (endpointConfiguration != other.endpointConfiguration) return false
        if (id != other.id) return false
        if (minimumCompressionSize != other.minimumCompressionSize) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The source of the API key for metering requests according to a usage plan.
         *
         * `HEADER` indicates whether to read the API key from the X-API-Key header of a request.
         *
         * `AUTHORIZER` indicates whether to read the API key from the `UsageIdentifierKey` from a custom authorizer.
         */
        public var apiKeySource: kotlin.String? = null
        /**
         * The list of binary media types supported by the REST API.
         */
        public var binaryMediaTypes: List<String>? = null
        /**
         * Indicates when the API was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createdDate: kotlin.String? = null
        /**
         * A description of the REST API.
         */
        public var description: kotlin.String? = null
        /**
         * The endpoint configuration of the REST API.
         */
        public var endpointConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayEndpointConfiguration? = null
        /**
         * The identifier of the REST API.
         */
        public var id: kotlin.String? = null
        /**
         * The minimum size in bytes of a payload before compression is enabled.
         *
         * If `null`, then compression is disabled.
         *
         * If 0, then all payloads are compressed.
         */
        public var minimumCompressionSize: kotlin.Int? = null
        /**
         * The name of the REST API.
         */
        public var name: kotlin.String? = null
        /**
         * The version identifier for the REST API.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails) : this() {
            this.apiKeySource = x.apiKeySource
            this.binaryMediaTypes = x.binaryMediaTypes
            this.createdDate = x.createdDate
            this.description = x.description
            this.endpointConfiguration = x.endpointConfiguration
            this.id = x.id
            this.minimumCompressionSize = x.minimumCompressionSize
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails = AwsApiGatewayRestApiDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayEndpointConfiguration] inside the given [block]
         */
        public fun endpointConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayEndpointConfiguration.Builder.() -> kotlin.Unit) {
            this.endpointConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayEndpointConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
