// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about settings for canary deployment in the stage.
 */
public class AwsApiGatewayCanarySettings private constructor(builder: Builder) {
    /**
     * The deployment identifier for the canary deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The percentage of traffic that is diverted to a canary deployment.
     */
    public val percentTraffic: kotlin.Double? = builder.percentTraffic
    /**
     * Stage variables that are overridden in the canary release deployment. The variables include new stage variables that are introduced in the canary.
     *
     * Each variable is represented as a string-to-string map between the stage variable name and the variable value.
     */
    public val stageVariableOverrides: Map<String, String>? = builder.stageVariableOverrides
    /**
     * Indicates whether the canary deployment uses the stage cache.
     */
    public val useStageCache: kotlin.Boolean? = builder.useStageCache

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsApiGatewayCanarySettings(")
        append("deploymentId=$deploymentId,")
        append("percentTraffic=$percentTraffic,")
        append("stageVariableOverrides=$stageVariableOverrides,")
        append("useStageCache=$useStageCache")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (percentTraffic?.hashCode() ?: 0)
        result = 31 * result + (stageVariableOverrides?.hashCode() ?: 0)
        result = 31 * result + (useStageCache?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsApiGatewayCanarySettings

        if (deploymentId != other.deploymentId) return false
        if (percentTraffic != other.percentTraffic) return false
        if (stageVariableOverrides != other.stageVariableOverrides) return false
        if (useStageCache != other.useStageCache) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The deployment identifier for the canary deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The percentage of traffic that is diverted to a canary deployment.
         */
        public var percentTraffic: kotlin.Double? = null
        /**
         * Stage variables that are overridden in the canary release deployment. The variables include new stage variables that are introduced in the canary.
         *
         * Each variable is represented as a string-to-string map between the stage variable name and the variable value.
         */
        public var stageVariableOverrides: Map<String, String>? = null
        /**
         * Indicates whether the canary deployment uses the stage cache.
         */
        public var useStageCache: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings) : this() {
            this.deploymentId = x.deploymentId
            this.percentTraffic = x.percentTraffic
            this.stageVariableOverrides = x.stageVariableOverrides
            this.useStageCache = x.useStageCache
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayCanarySettings = AwsApiGatewayCanarySettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
