// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The metadata of the Lightweight Directory Access Protocol (LDAP) server used to authenticate and authorize connections to the broker. This is an optional failover server.
 */
public class AwsAmazonMqBrokerLdapServerMetadataDetails private constructor(builder: Builder) {
    /**
     * Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft Active Directory.
     */
    public val hosts: List<String>? = builder.hosts
    /**
     * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups.
     */
    public val roleBase: kotlin.String? = builder.roleBase
    /**
     * The group name attribute in a role entry whose value is the name of that role.
     */
    public val roleName: kotlin.String? = builder.roleName
    /**
     * The LDAP search filter used to find roles within the `roleBase`.
     */
    public val roleSearchMatching: kotlin.String? = builder.roleSearchMatching
    /**
     * The directory search scope for the role. If set to `true`, the scope is to search the entire subtree.
     */
    public val roleSearchSubtree: kotlin.Boolean? = builder.roleSearchSubtree
    /**
     * A username for the service account, which is an account in your LDAP server that has access to initiate a connection.
     */
    public val serviceAccountUsername: kotlin.String? = builder.serviceAccountUsername
    /**
     * Selects a particular subtree of the directory information tree (DIT) to search for user entries.
     */
    public val userBase: kotlin.String? = builder.userBase
    /**
     * The name of the LDAP attribute in the user's directory entry for the user's group membership.
     */
    public val userRoleName: kotlin.String? = builder.userRoleName
    /**
     * The LDAP search filter used to find users within the `userBase`.
     */
    public val userSearchMatching: kotlin.String? = builder.userSearchMatching
    /**
     * The directory search scope for the user. If set to true, the scope is to search the entire subtree.
     */
    public val userSearchSubtree: kotlin.Boolean? = builder.userSearchSubtree

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAmazonMqBrokerLdapServerMetadataDetails(")
        append("hosts=$hosts,")
        append("roleBase=$roleBase,")
        append("roleName=$roleName,")
        append("roleSearchMatching=$roleSearchMatching,")
        append("roleSearchSubtree=$roleSearchSubtree,")
        append("serviceAccountUsername=$serviceAccountUsername,")
        append("userBase=$userBase,")
        append("userRoleName=$userRoleName,")
        append("userSearchMatching=$userSearchMatching,")
        append("userSearchSubtree=$userSearchSubtree")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hosts?.hashCode() ?: 0
        result = 31 * result + (roleBase?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (roleSearchMatching?.hashCode() ?: 0)
        result = 31 * result + (roleSearchSubtree?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountUsername?.hashCode() ?: 0)
        result = 31 * result + (userBase?.hashCode() ?: 0)
        result = 31 * result + (userRoleName?.hashCode() ?: 0)
        result = 31 * result + (userSearchMatching?.hashCode() ?: 0)
        result = 31 * result + (userSearchSubtree?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsAmazonMqBrokerLdapServerMetadataDetails

        if (hosts != other.hosts) return false
        if (roleBase != other.roleBase) return false
        if (roleName != other.roleName) return false
        if (roleSearchMatching != other.roleSearchMatching) return false
        if (roleSearchSubtree != other.roleSearchSubtree) return false
        if (serviceAccountUsername != other.serviceAccountUsername) return false
        if (userBase != other.userBase) return false
        if (userRoleName != other.userRoleName) return false
        if (userSearchMatching != other.userSearchMatching) return false
        if (userSearchSubtree != other.userSearchSubtree) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the location of the LDAP server, such as Amazon Web Services Directory Service for Microsoft Active Directory.
         */
        public var hosts: List<String>? = null
        /**
         * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups.
         */
        public var roleBase: kotlin.String? = null
        /**
         * The group name attribute in a role entry whose value is the name of that role.
         */
        public var roleName: kotlin.String? = null
        /**
         * The LDAP search filter used to find roles within the `roleBase`.
         */
        public var roleSearchMatching: kotlin.String? = null
        /**
         * The directory search scope for the role. If set to `true`, the scope is to search the entire subtree.
         */
        public var roleSearchSubtree: kotlin.Boolean? = null
        /**
         * A username for the service account, which is an account in your LDAP server that has access to initiate a connection.
         */
        public var serviceAccountUsername: kotlin.String? = null
        /**
         * Selects a particular subtree of the directory information tree (DIT) to search for user entries.
         */
        public var userBase: kotlin.String? = null
        /**
         * The name of the LDAP attribute in the user's directory entry for the user's group membership.
         */
        public var userRoleName: kotlin.String? = null
        /**
         * The LDAP search filter used to find users within the `userBase`.
         */
        public var userSearchMatching: kotlin.String? = null
        /**
         * The directory search scope for the user. If set to true, the scope is to search the entire subtree.
         */
        public var userSearchSubtree: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails) : this() {
            this.hosts = x.hosts
            this.roleBase = x.roleBase
            this.roleName = x.roleName
            this.roleSearchMatching = x.roleSearchMatching
            this.roleSearchSubtree = x.roleSearchSubtree
            this.serviceAccountUsername = x.serviceAccountUsername
            this.userBase = x.userBase
            this.userRoleName = x.userRoleName
            this.userSearchMatching = x.userSearchMatching
            this.userSearchSubtree = x.userSearchSubtree
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails = AwsAmazonMqBrokerLdapServerMetadataDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
