// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about an Amazon MQ message broker. A message broker allows software applications and components to communicate using various programming languages, operating systems, and formal messaging protocols.
 */
public class AwsAmazonMqBrokerDetails private constructor(builder: Builder) {
    /**
     * The authentication strategy used to secure the broker. The default is `SIMPLE`.
     */
    public val authenticationStrategy: kotlin.String? = builder.authenticationStrategy
    /**
     * Whether automatically upgrade new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Amazon Resource Name (ARN) of the broker.
     */
    public val brokerArn: kotlin.String? = builder.brokerArn
    /**
     * The unique ID that Amazon MQ generates for the broker.
     */
    public val brokerId: kotlin.String? = builder.brokerId
    /**
     * The broker's name.
     */
    public val brokerName: kotlin.String? = builder.brokerName
    /**
     * The broker's deployment mode.
     */
    public val deploymentMode: kotlin.String? = builder.deploymentMode
    /**
     * Encryption options for the broker. Doesn’t apply to RabbitMQ brokers.
     */
    public val encryptionOptions: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails? = builder.encryptionOptions
    /**
     * The type of broker engine.
     */
    public val engineType: kotlin.String? = builder.engineType
    /**
     * The version of the broker engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The broker's instance type.
     */
    public val hostInstanceType: kotlin.String? = builder.hostInstanceType
    /**
     * The metadata of the Lightweight Directory Access Protocol (LDAP) server used to authenticate and authorize connections to the broker. This is an optional failover server.
     */
    public val ldapServerMetadata: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails? = builder.ldapServerMetadata
    /**
     * Turns on Amazon CloudWatch logging for brokers.
     */
    public val logs: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLogsDetails? = builder.logs
    /**
     * The scheduled time period (UTC) during which Amazon MQ begins to apply pending updates or patches to the broker.
     */
    public val maintenanceWindowStartTime: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails? = builder.maintenanceWindowStartTime
    /**
     * Permits connections from applications outside of the VPC that hosts the broker's subnets.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The list of rules (one minimum, 125 maximum) that authorize connections to brokers.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The broker's storage type.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The list of all broker usernames for the specified broker. Doesn't apply to RabbitMQ brokers.
     */
    public val users: List<AwsAmazonMqBrokerUsersDetails>? = builder.users

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsAmazonMqBrokerDetails(")
        append("authenticationStrategy=$authenticationStrategy,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("brokerArn=$brokerArn,")
        append("brokerId=$brokerId,")
        append("brokerName=$brokerName,")
        append("deploymentMode=$deploymentMode,")
        append("encryptionOptions=$encryptionOptions,")
        append("engineType=$engineType,")
        append("engineVersion=$engineVersion,")
        append("hostInstanceType=$hostInstanceType,")
        append("ldapServerMetadata=$ldapServerMetadata,")
        append("logs=$logs,")
        append("maintenanceWindowStartTime=$maintenanceWindowStartTime,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("securityGroups=$securityGroups,")
        append("storageType=$storageType,")
        append("subnetIds=$subnetIds,")
        append("users=$users")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationStrategy?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (brokerArn?.hashCode() ?: 0)
        result = 31 * result + (brokerId?.hashCode() ?: 0)
        result = 31 * result + (brokerName?.hashCode() ?: 0)
        result = 31 * result + (deploymentMode?.hashCode() ?: 0)
        result = 31 * result + (encryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (engineType?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hostInstanceType?.hashCode() ?: 0)
        result = 31 * result + (ldapServerMetadata?.hashCode() ?: 0)
        result = 31 * result + (logs?.hashCode() ?: 0)
        result = 31 * result + (maintenanceWindowStartTime?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (users?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsAmazonMqBrokerDetails

        if (authenticationStrategy != other.authenticationStrategy) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (brokerArn != other.brokerArn) return false
        if (brokerId != other.brokerId) return false
        if (brokerName != other.brokerName) return false
        if (deploymentMode != other.deploymentMode) return false
        if (encryptionOptions != other.encryptionOptions) return false
        if (engineType != other.engineType) return false
        if (engineVersion != other.engineVersion) return false
        if (hostInstanceType != other.hostInstanceType) return false
        if (ldapServerMetadata != other.ldapServerMetadata) return false
        if (logs != other.logs) return false
        if (maintenanceWindowStartTime != other.maintenanceWindowStartTime) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (securityGroups != other.securityGroups) return false
        if (storageType != other.storageType) return false
        if (subnetIds != other.subnetIds) return false
        if (users != other.users) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authentication strategy used to secure the broker. The default is `SIMPLE`.
         */
        public var authenticationStrategy: kotlin.String? = null
        /**
         * Whether automatically upgrade new minor versions for brokers, as new versions are released and supported by Amazon MQ. Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the broker.
         */
        public var brokerArn: kotlin.String? = null
        /**
         * The unique ID that Amazon MQ generates for the broker.
         */
        public var brokerId: kotlin.String? = null
        /**
         * The broker's name.
         */
        public var brokerName: kotlin.String? = null
        /**
         * The broker's deployment mode.
         */
        public var deploymentMode: kotlin.String? = null
        /**
         * Encryption options for the broker. Doesn’t apply to RabbitMQ brokers.
         */
        public var encryptionOptions: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails? = null
        /**
         * The type of broker engine.
         */
        public var engineType: kotlin.String? = null
        /**
         * The version of the broker engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The broker's instance type.
         */
        public var hostInstanceType: kotlin.String? = null
        /**
         * The metadata of the Lightweight Directory Access Protocol (LDAP) server used to authenticate and authorize connections to the broker. This is an optional failover server.
         */
        public var ldapServerMetadata: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails? = null
        /**
         * Turns on Amazon CloudWatch logging for brokers.
         */
        public var logs: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLogsDetails? = null
        /**
         * The scheduled time period (UTC) during which Amazon MQ begins to apply pending updates or patches to the broker.
         */
        public var maintenanceWindowStartTime: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails? = null
        /**
         * Permits connections from applications outside of the VPC that hosts the broker's subnets.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The list of rules (one minimum, 125 maximum) that authorize connections to brokers.
         */
        public var securityGroups: List<String>? = null
        /**
         * The broker's storage type.
         */
        public var storageType: kotlin.String? = null
        /**
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
         */
        public var subnetIds: List<String>? = null
        /**
         * The list of all broker usernames for the specified broker. Doesn't apply to RabbitMQ brokers.
         */
        public var users: List<AwsAmazonMqBrokerUsersDetails>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerDetails) : this() {
            this.authenticationStrategy = x.authenticationStrategy
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.brokerArn = x.brokerArn
            this.brokerId = x.brokerId
            this.brokerName = x.brokerName
            this.deploymentMode = x.deploymentMode
            this.encryptionOptions = x.encryptionOptions
            this.engineType = x.engineType
            this.engineVersion = x.engineVersion
            this.hostInstanceType = x.hostInstanceType
            this.ldapServerMetadata = x.ldapServerMetadata
            this.logs = x.logs
            this.maintenanceWindowStartTime = x.maintenanceWindowStartTime
            this.publiclyAccessible = x.publiclyAccessible
            this.securityGroups = x.securityGroups
            this.storageType = x.storageType
            this.subnetIds = x.subnetIds
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerDetails = AwsAmazonMqBrokerDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails] inside the given [block]
         */
        public fun encryptionOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.Builder.() -> kotlin.Unit) {
            this.encryptionOptions = aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails] inside the given [block]
         */
        public fun ldapServerMetadata(block: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.Builder.() -> kotlin.Unit) {
            this.ldapServerMetadata = aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLogsDetails] inside the given [block]
         */
        public fun logs(block: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLogsDetails.Builder.() -> kotlin.Unit) {
            this.logs = aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerLogsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails] inside the given [block]
         */
        public fun maintenanceWindowStartTime(block: aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.Builder.() -> kotlin.Unit) {
            this.maintenanceWindowStartTime = aws.sdk.kotlin.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
