// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * The criteria that determine which findings a rule applies to.
 */
public class AutomationRulesFindingFilters private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID in which a finding was generated.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public val awsAccountId: List<StringFilter>? = builder.awsAccountId
    /**
     * The name of the company for the product that generated the finding. For control-based findings, the company is Amazon Web Services.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val companyName: List<StringFilter>? = builder.companyName
    /**
     * The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the [DescribeStandards](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html) API response.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val complianceAssociatedStandardsId: List<StringFilter>? = builder.complianceAssociatedStandardsId
    /**
     * The security control ID for which a finding was generated. Security control IDs are the same across standards.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val complianceSecurityControlId: List<StringFilter>? = builder.complianceSecurityControlId
    /**
     * The result of a security check. This field is only used for findings generated from controls.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val complianceStatus: List<StringFilter>? = builder.complianceStatus
    /**
     * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. For example, a data exfiltration detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration hasn't been verified. For more information, see [Confidence](https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence) in the *Security Hub User Guide*.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val confidence: List<NumberFilter>? = builder.confidence
    /**
     * A timestamp that indicates when this finding record was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val createdAt: List<DateFilter>? = builder.createdAt
    /**
     * The level of importance that is assigned to the resources that are associated with a finding. `Criticality` is scored on a 0–100 basis, using a ratio scale that supports only full integers. A score of `0` means that the underlying resources have no criticality, and a score of `100` is reserved for the most critical resources. For more information, see [Criticality](https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality) in the *Security Hub User Guide*.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val criticality: List<NumberFilter>? = builder.criticality
    /**
     * A finding's description.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val description: List<StringFilter>? = builder.description
    /**
     * A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val firstObservedAt: List<DateFilter>? = builder.firstObservedAt
    /**
     * The identifier for the solution-specific component that generated a finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public val generatorId: List<StringFilter>? = builder.generatorId
    /**
     * The product-specific identifier for a finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val id: List<StringFilter>? = builder.id
    /**
     * A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val lastObservedAt: List<DateFilter>? = builder.lastObservedAt
    /**
     * The text of a user-defined note that's added to a finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val noteText: List<StringFilter>? = builder.noteText
    /**
     * The timestamp of when the note was updated. Uses the date-time format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val noteUpdatedAt: List<DateFilter>? = builder.noteUpdatedAt
    /**
     * The principal that created a note.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val noteUpdatedBy: List<StringFilter>? = builder.noteUpdatedBy
    /**
     * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val productArn: List<StringFilter>? = builder.productArn
    /**
     * Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val productName: List<StringFilter>? = builder.productName
    /**
     * Provides the current state of a finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val recordState: List<StringFilter>? = builder.recordState
    /**
     * The product-generated identifier for a related finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val relatedFindingsId: List<StringFilter>? = builder.relatedFindingsId
    /**
     * The ARN for the product that generated a related finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val relatedFindingsProductArn: List<StringFilter>? = builder.relatedFindingsProductArn
    /**
     * Custom fields and values about the resource that a finding pertains to.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val resourceDetailsOther: List<MapFilter>? = builder.resourceDetailsOther
    /**
     * The identifier for the given resource type. For Amazon Web Services resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is the identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web Services resources, this is a unique identifier that is associated with the resource.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public val resourceId: List<StringFilter>? = builder.resourceId
    /**
     * The partition in which the resource that the finding pertains to is located. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val resourcePartition: List<StringFilter>? = builder.resourcePartition
    /**
     * The Amazon Web Services Region where the resource that a finding pertains to is located.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val resourceRegion: List<StringFilter>? = builder.resourceRegion
    /**
     * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val resourceTags: List<MapFilter>? = builder.resourceTags
    /**
     * The type of resource that the finding pertains to.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val resourceType: List<StringFilter>? = builder.resourceType
    /**
     * The severity value of the finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val severityLabel: List<StringFilter>? = builder.severityLabel
    /**
     * Provides a URL that links to a page about the current finding in the finding product.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val sourceUrl: List<StringFilter>? = builder.sourceUrl
    /**
     * A finding's title.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
     */
    public val title: List<StringFilter>? = builder.title
    /**
     * One or more finding types in the format of namespace/category/classifier that classify a finding. For a list of namespaces, classifiers, and categories, see [Types taxonomy for ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html) in the *Security Hub User Guide*.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val type: List<StringFilter>? = builder.type
    /**
     * A timestamp that indicates when the finding record was most recently updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val updatedAt: List<DateFilter>? = builder.updatedAt
    /**
     * A list of user-defined name and value string pairs added to a finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val userDefinedFields: List<MapFilter>? = builder.userDefinedFields
    /**
     * Provides the veracity of a finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val verificationState: List<StringFilter>? = builder.verificationState
    /**
     * Provides information about the status of the investigation into a finding.
     *
     *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
     */
    public val workflowStatus: List<StringFilter>? = builder.workflowStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomationRulesFindingFilters(")
        append("awsAccountId=$awsAccountId,")
        append("companyName=$companyName,")
        append("complianceAssociatedStandardsId=$complianceAssociatedStandardsId,")
        append("complianceSecurityControlId=$complianceSecurityControlId,")
        append("complianceStatus=$complianceStatus,")
        append("confidence=$confidence,")
        append("createdAt=$createdAt,")
        append("criticality=$criticality,")
        append("description=$description,")
        append("firstObservedAt=$firstObservedAt,")
        append("generatorId=$generatorId,")
        append("id=$id,")
        append("lastObservedAt=$lastObservedAt,")
        append("noteText=$noteText,")
        append("noteUpdatedAt=$noteUpdatedAt,")
        append("noteUpdatedBy=$noteUpdatedBy,")
        append("productArn=$productArn,")
        append("productName=$productName,")
        append("recordState=$recordState,")
        append("relatedFindingsId=$relatedFindingsId,")
        append("relatedFindingsProductArn=$relatedFindingsProductArn,")
        append("resourceDetailsOther=$resourceDetailsOther,")
        append("resourceId=$resourceId,")
        append("resourcePartition=$resourcePartition,")
        append("resourceRegion=$resourceRegion,")
        append("resourceTags=$resourceTags,")
        append("resourceType=$resourceType,")
        append("severityLabel=$severityLabel,")
        append("sourceUrl=$sourceUrl,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt,")
        append("userDefinedFields=$userDefinedFields,")
        append("verificationState=$verificationState,")
        append("workflowStatus=$workflowStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (companyName?.hashCode() ?: 0)
        result = 31 * result + (complianceAssociatedStandardsId?.hashCode() ?: 0)
        result = 31 * result + (complianceSecurityControlId?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (confidence?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (criticality?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (firstObservedAt?.hashCode() ?: 0)
        result = 31 * result + (generatorId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastObservedAt?.hashCode() ?: 0)
        result = 31 * result + (noteText?.hashCode() ?: 0)
        result = 31 * result + (noteUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (noteUpdatedBy?.hashCode() ?: 0)
        result = 31 * result + (productArn?.hashCode() ?: 0)
        result = 31 * result + (productName?.hashCode() ?: 0)
        result = 31 * result + (recordState?.hashCode() ?: 0)
        result = 31 * result + (relatedFindingsId?.hashCode() ?: 0)
        result = 31 * result + (relatedFindingsProductArn?.hashCode() ?: 0)
        result = 31 * result + (resourceDetailsOther?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourcePartition?.hashCode() ?: 0)
        result = 31 * result + (resourceRegion?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (severityLabel?.hashCode() ?: 0)
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (userDefinedFields?.hashCode() ?: 0)
        result = 31 * result + (verificationState?.hashCode() ?: 0)
        result = 31 * result + (workflowStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomationRulesFindingFilters

        if (awsAccountId != other.awsAccountId) return false
        if (companyName != other.companyName) return false
        if (complianceAssociatedStandardsId != other.complianceAssociatedStandardsId) return false
        if (complianceSecurityControlId != other.complianceSecurityControlId) return false
        if (complianceStatus != other.complianceStatus) return false
        if (confidence != other.confidence) return false
        if (createdAt != other.createdAt) return false
        if (criticality != other.criticality) return false
        if (description != other.description) return false
        if (firstObservedAt != other.firstObservedAt) return false
        if (generatorId != other.generatorId) return false
        if (id != other.id) return false
        if (lastObservedAt != other.lastObservedAt) return false
        if (noteText != other.noteText) return false
        if (noteUpdatedAt != other.noteUpdatedAt) return false
        if (noteUpdatedBy != other.noteUpdatedBy) return false
        if (productArn != other.productArn) return false
        if (productName != other.productName) return false
        if (recordState != other.recordState) return false
        if (relatedFindingsId != other.relatedFindingsId) return false
        if (relatedFindingsProductArn != other.relatedFindingsProductArn) return false
        if (resourceDetailsOther != other.resourceDetailsOther) return false
        if (resourceId != other.resourceId) return false
        if (resourcePartition != other.resourcePartition) return false
        if (resourceRegion != other.resourceRegion) return false
        if (resourceTags != other.resourceTags) return false
        if (resourceType != other.resourceType) return false
        if (severityLabel != other.severityLabel) return false
        if (sourceUrl != other.sourceUrl) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false
        if (userDefinedFields != other.userDefinedFields) return false
        if (verificationState != other.verificationState) return false
        if (workflowStatus != other.workflowStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID in which a finding was generated.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
         */
        public var awsAccountId: List<StringFilter>? = null
        /**
         * The name of the company for the product that generated the finding. For control-based findings, the company is Amazon Web Services.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var companyName: List<StringFilter>? = null
        /**
         * The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the [DescribeStandards](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html) API response.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var complianceAssociatedStandardsId: List<StringFilter>? = null
        /**
         * The security control ID for which a finding was generated. Security control IDs are the same across standards.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var complianceSecurityControlId: List<StringFilter>? = null
        /**
         * The result of a security check. This field is only used for findings generated from controls.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var complianceStatus: List<StringFilter>? = null
        /**
         * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. For example, a data exfiltration detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration hasn't been verified. For more information, see [Confidence](https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence) in the *Security Hub User Guide*.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var confidence: List<NumberFilter>? = null
        /**
         * A timestamp that indicates when this finding record was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var createdAt: List<DateFilter>? = null
        /**
         * The level of importance that is assigned to the resources that are associated with a finding. `Criticality` is scored on a 0–100 basis, using a ratio scale that supports only full integers. A score of `0` means that the underlying resources have no criticality, and a score of `100` is reserved for the most critical resources. For more information, see [Criticality](https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality) in the *Security Hub User Guide*.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var criticality: List<NumberFilter>? = null
        /**
         * A finding's description.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var description: List<StringFilter>? = null
        /**
         * A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var firstObservedAt: List<DateFilter>? = null
        /**
         * The identifier for the solution-specific component that generated a finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
         */
        public var generatorId: List<StringFilter>? = null
        /**
         * The product-specific identifier for a finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var id: List<StringFilter>? = null
        /**
         * A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var lastObservedAt: List<DateFilter>? = null
        /**
         * The text of a user-defined note that's added to a finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var noteText: List<StringFilter>? = null
        /**
         * The timestamp of when the note was updated. Uses the date-time format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var noteUpdatedAt: List<DateFilter>? = null
        /**
         * The principal that created a note.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var noteUpdatedBy: List<StringFilter>? = null
        /**
         * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var productArn: List<StringFilter>? = null
        /**
         * Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var productName: List<StringFilter>? = null
        /**
         * Provides the current state of a finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var recordState: List<StringFilter>? = null
        /**
         * The product-generated identifier for a related finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var relatedFindingsId: List<StringFilter>? = null
        /**
         * The ARN for the product that generated a related finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var relatedFindingsProductArn: List<StringFilter>? = null
        /**
         * Custom fields and values about the resource that a finding pertains to.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var resourceDetailsOther: List<MapFilter>? = null
        /**
         * The identifier for the given resource type. For Amazon Web Services resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For Amazon Web Services resources that lack ARNs, this is the identifier as defined by the Amazon Web Service that created the resource. For non-Amazon Web Services resources, this is a unique identifier that is associated with the resource.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
         */
        public var resourceId: List<StringFilter>? = null
        /**
         * The partition in which the resource that the finding pertains to is located. A partition is a group of Amazon Web Services Regions. Each Amazon Web Services account is scoped to one partition.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var resourcePartition: List<StringFilter>? = null
        /**
         * The Amazon Web Services Region where the resource that a finding pertains to is located.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var resourceRegion: List<StringFilter>? = null
        /**
         * A list of Amazon Web Services tags associated with a resource at the time the finding was processed.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var resourceTags: List<MapFilter>? = null
        /**
         * The type of resource that the finding pertains to.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var resourceType: List<StringFilter>? = null
        /**
         * The severity value of the finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var severityLabel: List<StringFilter>? = null
        /**
         * Provides a URL that links to a page about the current finding in the finding product.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var sourceUrl: List<StringFilter>? = null
        /**
         * A finding's title.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 100 items.
         */
        public var title: List<StringFilter>? = null
        /**
         * One or more finding types in the format of namespace/category/classifier that classify a finding. For a list of namespaces, classifiers, and categories, see [Types taxonomy for ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html) in the *Security Hub User Guide*.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var type: List<StringFilter>? = null
        /**
         * A timestamp that indicates when the finding record was most recently updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z`.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var updatedAt: List<DateFilter>? = null
        /**
         * A list of user-defined name and value string pairs added to a finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var userDefinedFields: List<MapFilter>? = null
        /**
         * Provides the veracity of a finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var verificationState: List<StringFilter>? = null
        /**
         * Provides information about the status of the investigation into a finding.
         *
         *  Array Members: Minimum number of 1 item. Maximum number of 20 items.
         */
        public var workflowStatus: List<StringFilter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters) : this() {
            this.awsAccountId = x.awsAccountId
            this.companyName = x.companyName
            this.complianceAssociatedStandardsId = x.complianceAssociatedStandardsId
            this.complianceSecurityControlId = x.complianceSecurityControlId
            this.complianceStatus = x.complianceStatus
            this.confidence = x.confidence
            this.createdAt = x.createdAt
            this.criticality = x.criticality
            this.description = x.description
            this.firstObservedAt = x.firstObservedAt
            this.generatorId = x.generatorId
            this.id = x.id
            this.lastObservedAt = x.lastObservedAt
            this.noteText = x.noteText
            this.noteUpdatedAt = x.noteUpdatedAt
            this.noteUpdatedBy = x.noteUpdatedBy
            this.productArn = x.productArn
            this.productName = x.productName
            this.recordState = x.recordState
            this.relatedFindingsId = x.relatedFindingsId
            this.relatedFindingsProductArn = x.relatedFindingsProductArn
            this.resourceDetailsOther = x.resourceDetailsOther
            this.resourceId = x.resourceId
            this.resourcePartition = x.resourcePartition
            this.resourceRegion = x.resourceRegion
            this.resourceTags = x.resourceTags
            this.resourceType = x.resourceType
            this.severityLabel = x.severityLabel
            this.sourceUrl = x.sourceUrl
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
            this.userDefinedFields = x.userDefinedFields
            this.verificationState = x.verificationState
            this.workflowStatus = x.workflowStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AutomationRulesFindingFilters = AutomationRulesFindingFilters(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
