// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.securityhub.auth.DefaultSecurityHubAuthSchemeProvider
import aws.sdk.kotlin.services.securityhub.auth.SecurityHubAuthSchemeProvider
import aws.sdk.kotlin.services.securityhub.endpoints.DefaultSecurityHubEndpointProvider
import aws.sdk.kotlin.services.securityhub.endpoints.SecurityHubEndpointParameters
import aws.sdk.kotlin.services.securityhub.endpoints.SecurityHubEndpointProvider
import aws.sdk.kotlin.services.securityhub.model.AcceptAdministratorInvitationRequest
import aws.sdk.kotlin.services.securityhub.model.AcceptAdministratorInvitationResponse
import aws.sdk.kotlin.services.securityhub.model.AcceptInvitationRequest
import aws.sdk.kotlin.services.securityhub.model.AcceptInvitationResponse
import aws.sdk.kotlin.services.securityhub.model.BatchDeleteAutomationRulesRequest
import aws.sdk.kotlin.services.securityhub.model.BatchDeleteAutomationRulesResponse
import aws.sdk.kotlin.services.securityhub.model.BatchDisableStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.BatchDisableStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.BatchEnableStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.BatchEnableStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.BatchGetAutomationRulesRequest
import aws.sdk.kotlin.services.securityhub.model.BatchGetAutomationRulesResponse
import aws.sdk.kotlin.services.securityhub.model.BatchGetSecurityControlsRequest
import aws.sdk.kotlin.services.securityhub.model.BatchGetSecurityControlsResponse
import aws.sdk.kotlin.services.securityhub.model.BatchGetStandardsControlAssociationsRequest
import aws.sdk.kotlin.services.securityhub.model.BatchGetStandardsControlAssociationsResponse
import aws.sdk.kotlin.services.securityhub.model.BatchImportFindingsRequest
import aws.sdk.kotlin.services.securityhub.model.BatchImportFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateAutomationRulesRequest
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateAutomationRulesResponse
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsRequest
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest
import aws.sdk.kotlin.services.securityhub.model.BatchUpdateStandardsControlAssociationsResponse
import aws.sdk.kotlin.services.securityhub.model.CreateActionTargetRequest
import aws.sdk.kotlin.services.securityhub.model.CreateActionTargetResponse
import aws.sdk.kotlin.services.securityhub.model.CreateAutomationRuleRequest
import aws.sdk.kotlin.services.securityhub.model.CreateAutomationRuleResponse
import aws.sdk.kotlin.services.securityhub.model.CreateFindingAggregatorRequest
import aws.sdk.kotlin.services.securityhub.model.CreateFindingAggregatorResponse
import aws.sdk.kotlin.services.securityhub.model.CreateInsightRequest
import aws.sdk.kotlin.services.securityhub.model.CreateInsightResponse
import aws.sdk.kotlin.services.securityhub.model.CreateMembersRequest
import aws.sdk.kotlin.services.securityhub.model.CreateMembersResponse
import aws.sdk.kotlin.services.securityhub.model.DeclineInvitationsRequest
import aws.sdk.kotlin.services.securityhub.model.DeclineInvitationsResponse
import aws.sdk.kotlin.services.securityhub.model.DeleteActionTargetRequest
import aws.sdk.kotlin.services.securityhub.model.DeleteActionTargetResponse
import aws.sdk.kotlin.services.securityhub.model.DeleteFindingAggregatorRequest
import aws.sdk.kotlin.services.securityhub.model.DeleteFindingAggregatorResponse
import aws.sdk.kotlin.services.securityhub.model.DeleteInsightRequest
import aws.sdk.kotlin.services.securityhub.model.DeleteInsightResponse
import aws.sdk.kotlin.services.securityhub.model.DeleteInvitationsRequest
import aws.sdk.kotlin.services.securityhub.model.DeleteInvitationsResponse
import aws.sdk.kotlin.services.securityhub.model.DeleteMembersRequest
import aws.sdk.kotlin.services.securityhub.model.DeleteMembersResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeActionTargetsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeActionTargetsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeHubRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeHubResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeProductsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeProductsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsControlsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsControlsResponse
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.DescribeStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.DisableImportFindingsForProductRequest
import aws.sdk.kotlin.services.securityhub.model.DisableImportFindingsForProductResponse
import aws.sdk.kotlin.services.securityhub.model.DisableOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.securityhub.model.DisableOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.securityhub.model.DisableSecurityHubRequest
import aws.sdk.kotlin.services.securityhub.model.DisableSecurityHubResponse
import aws.sdk.kotlin.services.securityhub.model.DisassociateFromAdministratorAccountRequest
import aws.sdk.kotlin.services.securityhub.model.DisassociateFromAdministratorAccountResponse
import aws.sdk.kotlin.services.securityhub.model.DisassociateFromMasterAccountRequest
import aws.sdk.kotlin.services.securityhub.model.DisassociateFromMasterAccountResponse
import aws.sdk.kotlin.services.securityhub.model.DisassociateMembersRequest
import aws.sdk.kotlin.services.securityhub.model.DisassociateMembersResponse
import aws.sdk.kotlin.services.securityhub.model.EnableImportFindingsForProductRequest
import aws.sdk.kotlin.services.securityhub.model.EnableImportFindingsForProductResponse
import aws.sdk.kotlin.services.securityhub.model.EnableOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.securityhub.model.EnableOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.securityhub.model.EnableSecurityHubRequest
import aws.sdk.kotlin.services.securityhub.model.EnableSecurityHubResponse
import aws.sdk.kotlin.services.securityhub.model.GetAdministratorAccountRequest
import aws.sdk.kotlin.services.securityhub.model.GetAdministratorAccountResponse
import aws.sdk.kotlin.services.securityhub.model.GetEnabledStandardsRequest
import aws.sdk.kotlin.services.securityhub.model.GetEnabledStandardsResponse
import aws.sdk.kotlin.services.securityhub.model.GetFindingAggregatorRequest
import aws.sdk.kotlin.services.securityhub.model.GetFindingAggregatorResponse
import aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryRequest
import aws.sdk.kotlin.services.securityhub.model.GetFindingHistoryResponse
import aws.sdk.kotlin.services.securityhub.model.GetFindingsRequest
import aws.sdk.kotlin.services.securityhub.model.GetFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.GetInsightResultsRequest
import aws.sdk.kotlin.services.securityhub.model.GetInsightResultsResponse
import aws.sdk.kotlin.services.securityhub.model.GetInsightsRequest
import aws.sdk.kotlin.services.securityhub.model.GetInsightsResponse
import aws.sdk.kotlin.services.securityhub.model.GetInvitationsCountRequest
import aws.sdk.kotlin.services.securityhub.model.GetInvitationsCountResponse
import aws.sdk.kotlin.services.securityhub.model.GetMasterAccountRequest
import aws.sdk.kotlin.services.securityhub.model.GetMasterAccountResponse
import aws.sdk.kotlin.services.securityhub.model.GetMembersRequest
import aws.sdk.kotlin.services.securityhub.model.GetMembersResponse
import aws.sdk.kotlin.services.securityhub.model.InviteMembersRequest
import aws.sdk.kotlin.services.securityhub.model.InviteMembersResponse
import aws.sdk.kotlin.services.securityhub.model.ListAutomationRulesRequest
import aws.sdk.kotlin.services.securityhub.model.ListAutomationRulesResponse
import aws.sdk.kotlin.services.securityhub.model.ListEnabledProductsForImportRequest
import aws.sdk.kotlin.services.securityhub.model.ListEnabledProductsForImportResponse
import aws.sdk.kotlin.services.securityhub.model.ListFindingAggregatorsRequest
import aws.sdk.kotlin.services.securityhub.model.ListFindingAggregatorsResponse
import aws.sdk.kotlin.services.securityhub.model.ListInvitationsRequest
import aws.sdk.kotlin.services.securityhub.model.ListInvitationsResponse
import aws.sdk.kotlin.services.securityhub.model.ListMembersRequest
import aws.sdk.kotlin.services.securityhub.model.ListMembersResponse
import aws.sdk.kotlin.services.securityhub.model.ListOrganizationAdminAccountsRequest
import aws.sdk.kotlin.services.securityhub.model.ListOrganizationAdminAccountsResponse
import aws.sdk.kotlin.services.securityhub.model.ListSecurityControlDefinitionsRequest
import aws.sdk.kotlin.services.securityhub.model.ListSecurityControlDefinitionsResponse
import aws.sdk.kotlin.services.securityhub.model.ListStandardsControlAssociationsRequest
import aws.sdk.kotlin.services.securityhub.model.ListStandardsControlAssociationsResponse
import aws.sdk.kotlin.services.securityhub.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.securityhub.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.securityhub.model.TagResourceRequest
import aws.sdk.kotlin.services.securityhub.model.TagResourceResponse
import aws.sdk.kotlin.services.securityhub.model.UntagResourceRequest
import aws.sdk.kotlin.services.securityhub.model.UntagResourceResponse
import aws.sdk.kotlin.services.securityhub.model.UpdateActionTargetRequest
import aws.sdk.kotlin.services.securityhub.model.UpdateActionTargetResponse
import aws.sdk.kotlin.services.securityhub.model.UpdateFindingAggregatorRequest
import aws.sdk.kotlin.services.securityhub.model.UpdateFindingAggregatorResponse
import aws.sdk.kotlin.services.securityhub.model.UpdateFindingsRequest
import aws.sdk.kotlin.services.securityhub.model.UpdateFindingsResponse
import aws.sdk.kotlin.services.securityhub.model.UpdateInsightRequest
import aws.sdk.kotlin.services.securityhub.model.UpdateInsightResponse
import aws.sdk.kotlin.services.securityhub.model.UpdateOrganizationConfigurationRequest
import aws.sdk.kotlin.services.securityhub.model.UpdateOrganizationConfigurationResponse
import aws.sdk.kotlin.services.securityhub.model.UpdateSecurityHubConfigurationRequest
import aws.sdk.kotlin.services.securityhub.model.UpdateSecurityHubConfigurationResponse
import aws.sdk.kotlin.services.securityhub.model.UpdateStandardsControlRequest
import aws.sdk.kotlin.services.securityhub.model.UpdateStandardsControlResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SecurityHub"
public const val SdkVersion: String = "0.35.1-beta"

/**
 * Security Hub provides you with a comprehensive view of the security state of your Amazon Web Services environment and resources. It also provides you with the readiness status of your environment based on controls from supported security standards. Security Hub collects security data from Amazon Web Services accounts, services, and integrated third-party products and helps you analyze security trends in your environment to identify the highest priority security issues. For more information about Security Hub, see the *Security Hub User Guide*[](https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html).
 *
 * When you use operations in the Security Hub API, the requests are executed only in the Amazon Web Services Region that is currently active or in the specific Amazon Web Services Region that you specify in your request. Any configuration or settings change that results from the operation is applied only to that Region. To make the same change in other Regions, run the same command for each Region in which you want to apply the change.
 *
 * For example, if your Region is set to `us-west-2`, when you use `CreateMembers` to add a member account to Security Hub, the association of the member account with the administrator account is created only in the `us-west-2` Region. Security Hub must be enabled for the member account in the same Region that the invitation was sent from.
 *
 * The following throttling limits apply to using Security Hub API operations.
 * + `BatchEnableStandards` - `RateLimit` of 1 request per second. `BurstLimit` of 1 request per second.
 * + `GetFindings` - `RateLimit` of 3 requests per second. `BurstLimit` of 6 requests per second.
 * + `BatchImportFindings` - `RateLimit` of 10 requests per second. `BurstLimit` of 30 requests per second.
 * + `BatchUpdateFindings` - `RateLimit` of 10 requests per second. `BurstLimit` of 30 requests per second.
 * + `UpdateStandardsControl` - `RateLimit` of 1 request per second. `BurstLimit` of 5 requests per second.
 * + All other operations - `RateLimit` of 10 requests per second. `BurstLimit` of 30 requests per second.
 */
public interface SecurityHubClient : SdkClient {
    /**
     * SecurityHubClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SecurityHubClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "SecurityHub",
                "SECURITYHUB",
                "securityhub",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SecurityHubClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SecurityHubClient = DefaultSecurityHubClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SecurityHubEndpointProvider = builder.endpointProvider ?: DefaultSecurityHubEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SecurityHubAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSecurityHubAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SecurityHub"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SecurityHubEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SecurityHubAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    public suspend fun acceptAdministratorInvitation(input: AcceptAdministratorInvitationRequest): AcceptAdministratorInvitationResponse

    /**
     * This method is deprecated. Instead, use `AcceptAdministratorInvitation`.
     *
     * The Security Hub console continues to use `AcceptInvitation`. It will eventually change to use `AcceptAdministratorInvitation`. Any IAM policies that specifically control access to this function must continue to use `AcceptInvitation`. You should also add `AcceptAdministratorInvitation` to your policies to ensure that the correct permissions are in place after the console begins to use `AcceptAdministratorInvitation`.
     *
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
     *
     * This operation is only used by member accounts that are not added through Organizations.
     *
     * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse

    /**
     * Deletes one or more automation rules.
     */
    public suspend fun batchDeleteAutomationRules(input: BatchDeleteAutomationRulesRequest): BatchDeleteAutomationRulesResponse

    /**
     * Disables the standards specified by the provided `StandardsSubscriptionArns`.
     *
     * For more information, see [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    public suspend fun batchDisableStandards(input: BatchDisableStandardsRequest): BatchDisableStandardsResponse

    /**
     * Enables the standards specified by the provided `StandardsArn`. To obtain the ARN for a standard, use the `DescribeStandards` operation.
     *
     * For more information, see the [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
     */
    public suspend fun batchEnableStandards(input: BatchEnableStandardsRequest): BatchEnableStandardsResponse

    /**
     * Retrieves a list of details for automation rules based on rule Amazon Resource Names (ARNs).
     */
    public suspend fun batchGetAutomationRules(input: BatchGetAutomationRulesRequest): BatchGetAutomationRulesResponse

    /**
     * Provides details about a batch of security controls for the current Amazon Web Services account and Amazon Web Services Region.
     */
    public suspend fun batchGetSecurityControls(input: BatchGetSecurityControlsRequest): BatchGetSecurityControlsResponse

    /**
     * For a batch of security controls and standards, identifies whether each control is currently enabled or disabled in a standard.
     */
    public suspend fun batchGetStandardsControlAssociations(input: BatchGetStandardsControlAssociationsRequest): BatchGetStandardsControlAssociationsResponse

    /**
     * Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.
     *
     * `BatchImportFindings` must be called by one of the following:
     * + The Amazon Web Services account that is associated with a finding if you are using the [default product ARN](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs) or are a partner sending findings from within a customer's Amazon Web Services account. In these cases, the identifier of the account that you are calling `BatchImportFindings` from needs to be the same as the `AwsAccountId` attribute for the finding.
     * + An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this case, you can call `BatchImportFindings` from the allow-listed account and send findings from different customer accounts in the same batch.
     *
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     *
     * After a finding is created, `BatchImportFindings` cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.
     * + `Note`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * Finding providers also should not use `BatchImportFindings` to update the following attributes.
     * + `Confidence`
     * + `Criticality`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     *
     * Instead, finding providers use `FindingProviderFields` to provide values for these attributes.
     */
    public suspend fun batchImportFindings(input: BatchImportFindingsRequest): BatchImportFindingsResponse

    /**
     * Updates one or more automation rules based on rule Amazon Resource Names (ARNs) and input parameters.
     */
    public suspend fun batchUpdateAutomationRules(input: BatchUpdateAutomationRulesRequest): BatchUpdateAutomationRulesResponse

    /**
     * Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.
     *
     * Updates from `BatchUpdateFindings` do not affect the value of `UpdatedAt` for a finding.
     *
     * Administrator and member accounts can use `BatchUpdateFindings` to update the following finding fields and objects.
     * + `Confidence`
     * + `Criticality`
     * + `Note`
     * + `RelatedFindings`
     * + `Severity`
     * + `Types`
     * + `UserDefinedFields`
     * + `VerificationState`
     * + `Workflow`
     *
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See [Configuring access to BatchUpdateFindings](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access) in the *Security Hub User Guide*.
     */
    public suspend fun batchUpdateFindings(input: BatchUpdateFindingsRequest): BatchUpdateFindingsResponse

    /**
     * For a batch of security controls and standards, this operation updates the enablement status of a control in a standard.
     */
    public suspend fun batchUpdateStandardsControlAssociations(input: BatchUpdateStandardsControlAssociationsRequest): BatchUpdateStandardsControlAssociationsResponse

    /**
     * Creates a custom action target in Security Hub.
     *
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.
     */
    public suspend fun createActionTarget(input: CreateActionTargetRequest): CreateActionTargetResponse

    /**
     * Creates an automation rule based on input parameters.
     */
    public suspend fun createAutomationRule(input: CreateAutomationRuleRequest): CreateAutomationRuleResponse

    /**
     * Used to enable finding aggregation. Must be called from the aggregation Region.
     *
     * For more details about cross-Region replication, see [Configuring finding aggregation](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html) in the *Security Hub User Guide*.
     */
    public suspend fun createFindingAggregator(input: CreateFindingAggregatorRequest): CreateFindingAggregatorResponse

    /**
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.
     *
     * To group the related findings in the insight, use the `GroupByAttribute`.
     */
    public suspend fun createInsight(input: CreateInsightRequest): CreateInsightResponse

    /**
     * Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.
     *
     * `CreateMembers` is always used to add accounts that are not organization members.
     *
     * For accounts that are managed using Organizations, `CreateMembers` is only used in the following cases:
     * + Security Hub is not configured to automatically add new organization accounts.
     * + The account was disassociated or deleted in Security Hub.
     *
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the `EnableSecurityHub` operation.
     *
     * For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the `InviteMembers` operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub.
     *
     * Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub.
     * + If the organization account does not have Security Hub enabled, then Security Hub and the default standards are automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account.
     * + For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to those accounts. It does not change their enabled standards or controls.
     *
     * A permissions policy is added that permits the administrator account to view the findings generated in the member account.
     *
     * To remove the association between the administrator and member accounts, use the `DisassociateFromMasterAccount` or `DisassociateMembers` operation.
     */
    public suspend fun createMembers(input: CreateMembersRequest): CreateMembersResponse

    /**
     * Declines invitations to become a member account.
     *
     * A prospective member account uses this operation to decline an invitation to become a member.
     *
     * This operation is only called by member accounts that aren't part of an organization. Organization accounts don't receive invitations.
     */
    public suspend fun declineInvitations(input: DeclineInvitationsRequest): DeclineInvitationsResponse

    /**
     * Deletes a custom action target from Security Hub.
     *
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.
     */
    public suspend fun deleteActionTarget(input: DeleteActionTargetRequest): DeleteActionTargetResponse

    /**
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
     *
     * When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still visible from the aggregation Region. New findings and finding updates are not aggregated.
     */
    public suspend fun deleteFindingAggregator(input: DeleteFindingAggregatorRequest): DeleteFindingAggregatorResponse

    /**
     * Deletes the insight specified by the `InsightArn`.
     */
    public suspend fun deleteInsight(input: DeleteInsightRequest): DeleteInsightResponse

    /**
     * Deletes invitations received by the Amazon Web Services account to become a member account.
     *
     * A Security Hub administrator account can use this operation to delete invitations sent to one or more member accounts.
     *
     * This operation is only used to delete invitations that are sent to member accounts that aren't part of an organization. Organization accounts don't receive invitations.
     */
    public suspend fun deleteInvitations(input: DeleteInvitationsRequest): DeleteInvitationsResponse

    /**
     * Deletes the specified member accounts from Security Hub.
     *
     * You can invoke this API only to delete accounts that became members through invitation. You can't invoke this API to delete accounts that belong to an Organizations organization.
     */
    public suspend fun deleteMembers(input: DeleteMembersRequest): DeleteMembersResponse

    /**
     * Returns a list of the custom action targets in Security Hub in your account.
     */
    public suspend fun describeActionTargets(input: DescribeActionTargetsRequest = DescribeActionTargetsRequest { }): DescribeActionTargetsResponse

    /**
     * Returns details about the Hub resource in your account, including the `HubArn` and the time when you enabled Security Hub.
     */
    public suspend fun describeHub(input: DescribeHubRequest = DescribeHubRequest { }): DescribeHubResponse

    /**
     * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.
     */
    public suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest = DescribeOrganizationConfigurationRequest { }): DescribeOrganizationConfigurationResponse

    /**
     * Returns information about product integrations in Security Hub.
     *
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include that integration.
     *
     * If you do not provide an integration ARN, then the results include all of the available product integrations.
     */
    public suspend fun describeProducts(input: DescribeProductsRequest = DescribeProductsRequest { }): DescribeProductsResponse

    /**
     * Returns a list of the available standards in Security Hub.
     *
     * For each standard, the results include the standard ARN, the name, and a description.
     */
    public suspend fun describeStandards(input: DescribeStandardsRequest = DescribeStandardsRequest { }): DescribeStandardsResponse

    /**
     * Returns a list of security standards controls.
     *
     * For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.
     */
    public suspend fun describeStandardsControls(input: DescribeStandardsControlsRequest): DescribeStandardsControlsResponse

    /**
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.
     */
    public suspend fun disableImportFindingsForProduct(input: DisableImportFindingsForProductRequest): DisableImportFindingsForProductResponse

    /**
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     */
    public suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest): DisableOrganizationAdminAccountResponse

    /**
     * Disables Security Hub in your account only in the current Amazon Web Services Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.
     *
     * You can't disable Security Hub in an account that is currently the Security Hub administrator.
     *
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed.
     *
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     */
    public suspend fun disableSecurityHub(input: DisableSecurityHubRequest = DisableSecurityHubRequest { }): DisableSecurityHubResponse

    /**
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    public suspend fun disassociateFromAdministratorAccount(input: DisassociateFromAdministratorAccountRequest = DisassociateFromAdministratorAccountRequest { }): DisassociateFromAdministratorAccountResponse

    /**
     * This method is deprecated. Instead, use `DisassociateFromAdministratorAccount`.
     *
     * The Security Hub console continues to use `DisassociateFromMasterAccount`. It will eventually change to use `DisassociateFromAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `DisassociateFromMasterAccount`. You should also add `DisassociateFromAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `DisassociateFromAdministratorAccount`.
     *
     * Disassociates the current Security Hub member account from the associated administrator account.
     *
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun disassociateFromMasterAccount(input: DisassociateFromMasterAccountRequest = DisassociateFromMasterAccountRequest { }): DisassociateFromMasterAccountResponse

    /**
     * Disassociates the specified member accounts from the associated administrator account.
     *
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.
     */
    public suspend fun disassociateMembers(input: DisassociateMembersRequest): DisassociateMembersResponse

    /**
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.
     *
     * When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.
     */
    public suspend fun enableImportFindingsForProduct(input: EnableImportFindingsForProductRequest): EnableImportFindingsForProductResponse

    /**
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.
     */
    public suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse

    /**
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     *
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.
     *
     * When you use the `EnableSecurityHub` operation to enable Security Hub, you also automatically enable the following standards:
     * + Center for Internet Security (CIS) Amazon Web Services Foundations Benchmark v1.2.0
     * + Amazon Web Services Foundational Security Best Practices
     *
     * Other standards are not automatically enabled.
     *
     * To opt out of automatically enabled standards, set `EnableDefaultStandards` to `false`.
     *
     * After you enable Security Hub, to enable a standard, use the `BatchEnableStandards` operation. To disable a standard, use the `BatchDisableStandards` operation.
     *
     * To learn more, see the [setup information](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html) in the *Security Hub User Guide*.
     */
    public suspend fun enableSecurityHub(input: EnableSecurityHubRequest = EnableSecurityHubRequest { }): EnableSecurityHubResponse

    /**
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    public suspend fun getAdministratorAccount(input: GetAdministratorAccountRequest = GetAdministratorAccountRequest { }): GetAdministratorAccountResponse

    /**
     * Returns a list of the standards that are currently enabled.
     */
    public suspend fun getEnabledStandards(input: GetEnabledStandardsRequest = GetEnabledStandardsRequest { }): GetEnabledStandardsResponse

    /**
     * Returns the current finding aggregation configuration.
     */
    public suspend fun getFindingAggregator(input: GetFindingAggregatorRequest): GetFindingAggregatorResponse

    /**
     * Returns history for a Security Hub finding in the last 90 days. The history includes changes made to any fields in the Amazon Web Services Security Finding Format (ASFF).
     */
    public suspend fun getFindingHistory(input: GetFindingHistoryRequest): GetFindingHistoryResponse

    /**
     * Returns a list of findings that match the specified criteria.
     *
     * If finding aggregation is enabled, then when you call `GetFindings` from the aggregation Region, the results include all of the matching findings from both the aggregation Region and the linked Regions.
     */
    public suspend fun getFindings(input: GetFindingsRequest = GetFindingsRequest { }): GetFindingsResponse

    /**
     * Lists the results of the Security Hub insight specified by the insight ARN.
     */
    public suspend fun getInsightResults(input: GetInsightResultsRequest): GetInsightResultsResponse

    /**
     * Lists and describes insights for the specified insight ARNs.
     */
    public suspend fun getInsights(input: GetInsightsRequest = GetInsightsRequest { }): GetInsightsResponse

    /**
     * Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation.
     */
    public suspend fun getInvitationsCount(input: GetInvitationsCountRequest = GetInvitationsCountRequest { }): GetInvitationsCountResponse

    /**
     * This method is deprecated. Instead, use `GetAdministratorAccount`.
     *
     * The Security Hub console continues to use `GetMasterAccount`. It will eventually change to use `GetAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `GetMasterAccount`. You should also add `GetAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `GetAdministratorAccount`.
     *
     * Provides the details for the Security Hub administrator account for the current member account.
     *
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun getMasterAccount(input: GetMasterAccountRequest = GetMasterAccountRequest { }): GetMasterAccountResponse

    /**
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     *
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually.
     *
     * The results include both member accounts that are managed using Organizations and accounts that were invited manually.
     */
    public suspend fun getMembers(input: GetMembersRequest): GetMembersResponse

    /**
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.
     *
     * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations.
     *
     * Before you can use this action to invite a member, you must first use the `CreateMembers` action to create the member account in Security Hub.
     *
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.
     */
    public suspend fun inviteMembers(input: InviteMembersRequest): InviteMembersResponse

    /**
     * A list of automation rules and their metadata for the calling account.
     */
    public suspend fun listAutomationRules(input: ListAutomationRulesRequest = ListAutomationRulesRequest { }): ListAutomationRulesResponse

    /**
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.
     */
    public suspend fun listEnabledProductsForImport(input: ListEnabledProductsForImportRequest = ListEnabledProductsForImportRequest { }): ListEnabledProductsForImportResponse

    /**
     * If finding aggregation is enabled, then `ListFindingAggregators` returns the ARN of the finding aggregator. You can run this operation from any Region.
     */
    public suspend fun listFindingAggregators(input: ListFindingAggregatorsRequest = ListFindingAggregatorsRequest { }): ListFindingAggregatorsResponse

    /**
     * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
     *
     * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the integration with Organizations do not receive invitations.
     */
    public suspend fun listInvitations(input: ListInvitationsRequest = ListInvitationsRequest { }): ListInvitationsResponse

    /**
     * Lists details about all member accounts for the current Security Hub administrator account.
     *
     * The results include both member accounts that belong to an organization and member accounts that were invited manually.
     */
    public suspend fun listMembers(input: ListMembersRequest = ListMembersRequest { }): ListMembersResponse

    /**
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     */
    public suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest = ListOrganizationAdminAccountsRequest { }): ListOrganizationAdminAccountsResponse

    /**
     * Lists all of the security controls that apply to a specified standard.
     */
    public suspend fun listSecurityControlDefinitions(input: ListSecurityControlDefinitionsRequest = ListSecurityControlDefinitionsRequest { }): ListSecurityControlDefinitionsResponse

    /**
     * Specifies whether a control is currently enabled or disabled in each enabled standard in the calling account.
     */
    public suspend fun listStandardsControlAssociations(input: ListStandardsControlAssociationsRequest): ListStandardsControlAssociationsResponse

    /**
     * Returns a list of tags associated with a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds one or more tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the name and description of a custom action target in Security Hub.
     */
    public suspend fun updateActionTarget(input: UpdateActionTargetRequest): UpdateActionTargetResponse

    /**
     * Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use `UpdateFindingAggregator` to change the aggregation Region.
     *
     * You must run `UpdateFindingAggregator` from the current aggregation Region.
     */
    public suspend fun updateFindingAggregator(input: UpdateFindingAggregatorRequest): UpdateFindingAggregatorResponse

    /**
     * `UpdateFindings` is deprecated. Instead of `UpdateFindings`, use `BatchUpdateFindings`.
     *
     * Updates the `Note` and `RecordState` of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.
     */
    public suspend fun updateFindings(input: UpdateFindingsRequest): UpdateFindingsResponse

    /**
     * Updates the Security Hub insight identified by the specified insight ARN.
     */
    public suspend fun updateInsight(input: UpdateInsightRequest): UpdateInsightResponse

    /**
     * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.
     */
    public suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse

    /**
     * Updates configuration options for Security Hub.
     */
    public suspend fun updateSecurityHubConfiguration(input: UpdateSecurityHubConfigurationRequest = UpdateSecurityHubConfigurationRequest { }): UpdateSecurityHubConfigurationResponse

    /**
     * Used to control whether an individual security standard control is enabled or disabled.
     */
    public suspend fun updateStandardsControl(input: UpdateStandardsControlRequest): UpdateStandardsControlResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SecurityHubClient.withConfig(block: SecurityHubClient.Config.Builder.() -> Unit): SecurityHubClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSecurityHubClient(newConfig)
}

/**
 * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
 *
 * This operation is only used by member accounts that are not added through Organizations.
 *
 * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
 */
public suspend inline fun SecurityHubClient.acceptAdministratorInvitation(crossinline block: AcceptAdministratorInvitationRequest.Builder.() -> Unit): AcceptAdministratorInvitationResponse = acceptAdministratorInvitation(AcceptAdministratorInvitationRequest.Builder().apply(block).build())

/**
 * This method is deprecated. Instead, use `AcceptAdministratorInvitation`.
 *
 * The Security Hub console continues to use `AcceptInvitation`. It will eventually change to use `AcceptAdministratorInvitation`. Any IAM policies that specifically control access to this function must continue to use `AcceptInvitation`. You should also add `AcceptAdministratorInvitation` to your policies to ensure that the correct permissions are in place after the console begins to use `AcceptAdministratorInvitation`.
 *
 * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
 *
 * This operation is only used by member accounts that are not added through Organizations.
 *
 * When the member account accepts the invitation, permission is granted to the administrator account to view findings generated in the member account.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun SecurityHubClient.acceptInvitation(crossinline block: AcceptInvitationRequest.Builder.() -> Unit): AcceptInvitationResponse = acceptInvitation(AcceptInvitationRequest.Builder().apply(block).build())

/**
 * Deletes one or more automation rules.
 */
public suspend inline fun SecurityHubClient.batchDeleteAutomationRules(crossinline block: BatchDeleteAutomationRulesRequest.Builder.() -> Unit): BatchDeleteAutomationRulesResponse = batchDeleteAutomationRules(BatchDeleteAutomationRulesRequest.Builder().apply(block).build())

/**
 * Disables the standards specified by the provided `StandardsSubscriptionArns`.
 *
 * For more information, see [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
 */
public suspend inline fun SecurityHubClient.batchDisableStandards(crossinline block: BatchDisableStandardsRequest.Builder.() -> Unit): BatchDisableStandardsResponse = batchDisableStandards(BatchDisableStandardsRequest.Builder().apply(block).build())

/**
 * Enables the standards specified by the provided `StandardsArn`. To obtain the ARN for a standard, use the `DescribeStandards` operation.
 *
 * For more information, see the [Security Standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html) section of the *Security Hub User Guide*.
 */
public suspend inline fun SecurityHubClient.batchEnableStandards(crossinline block: BatchEnableStandardsRequest.Builder.() -> Unit): BatchEnableStandardsResponse = batchEnableStandards(BatchEnableStandardsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of details for automation rules based on rule Amazon Resource Names (ARNs).
 */
public suspend inline fun SecurityHubClient.batchGetAutomationRules(crossinline block: BatchGetAutomationRulesRequest.Builder.() -> Unit): BatchGetAutomationRulesResponse = batchGetAutomationRules(BatchGetAutomationRulesRequest.Builder().apply(block).build())

/**
 * Provides details about a batch of security controls for the current Amazon Web Services account and Amazon Web Services Region.
 */
public suspend inline fun SecurityHubClient.batchGetSecurityControls(crossinline block: BatchGetSecurityControlsRequest.Builder.() -> Unit): BatchGetSecurityControlsResponse = batchGetSecurityControls(BatchGetSecurityControlsRequest.Builder().apply(block).build())

/**
 * For a batch of security controls and standards, identifies whether each control is currently enabled or disabled in a standard.
 */
public suspend inline fun SecurityHubClient.batchGetStandardsControlAssociations(crossinline block: BatchGetStandardsControlAssociationsRequest.Builder.() -> Unit): BatchGetStandardsControlAssociationsResponse = batchGetStandardsControlAssociations(BatchGetStandardsControlAssociationsRequest.Builder().apply(block).build())

/**
 * Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.
 *
 * `BatchImportFindings` must be called by one of the following:
 * + The Amazon Web Services account that is associated with a finding if you are using the [default product ARN](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs) or are a partner sending findings from within a customer's Amazon Web Services account. In these cases, the identifier of the account that you are calling `BatchImportFindings` from needs to be the same as the `AwsAccountId` attribute for the finding.
 * + An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this case, you can call `BatchImportFindings` from the allow-listed account and send findings from different customer accounts in the same batch.
 *
 * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
 *
 * After a finding is created, `BatchImportFindings` cannot be used to update the following finding fields and objects, which Security Hub customers use to manage their investigation workflow.
 * + `Note`
 * + `UserDefinedFields`
 * + `VerificationState`
 * + `Workflow`
 *
 * Finding providers also should not use `BatchImportFindings` to update the following attributes.
 * + `Confidence`
 * + `Criticality`
 * + `RelatedFindings`
 * + `Severity`
 * + `Types`
 *
 * Instead, finding providers use `FindingProviderFields` to provide values for these attributes.
 */
public suspend inline fun SecurityHubClient.batchImportFindings(crossinline block: BatchImportFindingsRequest.Builder.() -> Unit): BatchImportFindingsResponse = batchImportFindings(BatchImportFindingsRequest.Builder().apply(block).build())

/**
 * Updates one or more automation rules based on rule Amazon Resource Names (ARNs) and input parameters.
 */
public suspend inline fun SecurityHubClient.batchUpdateAutomationRules(crossinline block: BatchUpdateAutomationRulesRequest.Builder.() -> Unit): BatchUpdateAutomationRulesResponse = batchUpdateAutomationRules(BatchUpdateAutomationRulesRequest.Builder().apply(block).build())

/**
 * Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.
 *
 * Updates from `BatchUpdateFindings` do not affect the value of `UpdatedAt` for a finding.
 *
 * Administrator and member accounts can use `BatchUpdateFindings` to update the following finding fields and objects.
 * + `Confidence`
 * + `Criticality`
 * + `Note`
 * + `RelatedFindings`
 * + `Severity`
 * + `Types`
 * + `UserDefinedFields`
 * + `VerificationState`
 * + `Workflow`
 *
 * You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See [Configuring access to BatchUpdateFindings](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access) in the *Security Hub User Guide*.
 */
public suspend inline fun SecurityHubClient.batchUpdateFindings(crossinline block: BatchUpdateFindingsRequest.Builder.() -> Unit): BatchUpdateFindingsResponse = batchUpdateFindings(BatchUpdateFindingsRequest.Builder().apply(block).build())

/**
 * For a batch of security controls and standards, this operation updates the enablement status of a control in a standard.
 */
public suspend inline fun SecurityHubClient.batchUpdateStandardsControlAssociations(crossinline block: BatchUpdateStandardsControlAssociationsRequest.Builder.() -> Unit): BatchUpdateStandardsControlAssociationsResponse = batchUpdateStandardsControlAssociations(BatchUpdateStandardsControlAssociationsRequest.Builder().apply(block).build())

/**
 * Creates a custom action target in Security Hub.
 *
 * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon CloudWatch Events.
 */
public suspend inline fun SecurityHubClient.createActionTarget(crossinline block: CreateActionTargetRequest.Builder.() -> Unit): CreateActionTargetResponse = createActionTarget(CreateActionTargetRequest.Builder().apply(block).build())

/**
 * Creates an automation rule based on input parameters.
 */
public suspend inline fun SecurityHubClient.createAutomationRule(crossinline block: CreateAutomationRuleRequest.Builder.() -> Unit): CreateAutomationRuleResponse = createAutomationRule(CreateAutomationRuleRequest.Builder().apply(block).build())

/**
 * Used to enable finding aggregation. Must be called from the aggregation Region.
 *
 * For more details about cross-Region replication, see [Configuring finding aggregation](https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html) in the *Security Hub User Guide*.
 */
public suspend inline fun SecurityHubClient.createFindingAggregator(crossinline block: CreateFindingAggregatorRequest.Builder.() -> Unit): CreateFindingAggregatorResponse = createFindingAggregator(CreateFindingAggregatorRequest.Builder().apply(block).build())

/**
 * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.
 *
 * To group the related findings in the insight, use the `GroupByAttribute`.
 */
public suspend inline fun SecurityHubClient.createInsight(crossinline block: CreateInsightRequest.Builder.() -> Unit): CreateInsightResponse = createInsight(CreateInsightRequest.Builder().apply(block).build())

/**
 * Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.
 *
 * `CreateMembers` is always used to add accounts that are not organization members.
 *
 * For accounts that are managed using Organizations, `CreateMembers` is only used in the following cases:
 * + Security Hub is not configured to automatically add new organization accounts.
 * + The account was disassociated or deleted in Security Hub.
 *
 * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the `EnableSecurityHub` operation.
 *
 * For accounts that are not organization members, you create the account association and then send an invitation to the member account. To send the invitation, you use the `InviteMembers` operation. If the account owner accepts the invitation, the account becomes a member account in Security Hub.
 *
 * Accounts that are managed using Organizations do not receive an invitation. They automatically become a member account in Security Hub.
 * + If the organization account does not have Security Hub enabled, then Security Hub and the default standards are automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management account. The organization management account must enable Security Hub before the administrator account enables it as a member account.
 * + For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to those accounts. It does not change their enabled standards or controls.
 *
 * A permissions policy is added that permits the administrator account to view the findings generated in the member account.
 *
 * To remove the association between the administrator and member accounts, use the `DisassociateFromMasterAccount` or `DisassociateMembers` operation.
 */
public suspend inline fun SecurityHubClient.createMembers(crossinline block: CreateMembersRequest.Builder.() -> Unit): CreateMembersResponse = createMembers(CreateMembersRequest.Builder().apply(block).build())

/**
 * Declines invitations to become a member account.
 *
 * A prospective member account uses this operation to decline an invitation to become a member.
 *
 * This operation is only called by member accounts that aren't part of an organization. Organization accounts don't receive invitations.
 */
public suspend inline fun SecurityHubClient.declineInvitations(crossinline block: DeclineInvitationsRequest.Builder.() -> Unit): DeclineInvitationsResponse = declineInvitations(DeclineInvitationsRequest.Builder().apply(block).build())

/**
 * Deletes a custom action target from Security Hub.
 *
 * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon CloudWatch Events using the custom action.
 */
public suspend inline fun SecurityHubClient.deleteActionTarget(crossinline block: DeleteActionTargetRequest.Builder.() -> Unit): DeleteActionTargetResponse = deleteActionTarget(DeleteActionTargetRequest.Builder().apply(block).build())

/**
 * Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
 *
 * When you stop finding aggregation, findings that were already aggregated to the aggregation Region are still visible from the aggregation Region. New findings and finding updates are not aggregated.
 */
public suspend inline fun SecurityHubClient.deleteFindingAggregator(crossinline block: DeleteFindingAggregatorRequest.Builder.() -> Unit): DeleteFindingAggregatorResponse = deleteFindingAggregator(DeleteFindingAggregatorRequest.Builder().apply(block).build())

/**
 * Deletes the insight specified by the `InsightArn`.
 */
public suspend inline fun SecurityHubClient.deleteInsight(crossinline block: DeleteInsightRequest.Builder.() -> Unit): DeleteInsightResponse = deleteInsight(DeleteInsightRequest.Builder().apply(block).build())

/**
 * Deletes invitations received by the Amazon Web Services account to become a member account.
 *
 * A Security Hub administrator account can use this operation to delete invitations sent to one or more member accounts.
 *
 * This operation is only used to delete invitations that are sent to member accounts that aren't part of an organization. Organization accounts don't receive invitations.
 */
public suspend inline fun SecurityHubClient.deleteInvitations(crossinline block: DeleteInvitationsRequest.Builder.() -> Unit): DeleteInvitationsResponse = deleteInvitations(DeleteInvitationsRequest.Builder().apply(block).build())

/**
 * Deletes the specified member accounts from Security Hub.
 *
 * You can invoke this API only to delete accounts that became members through invitation. You can't invoke this API to delete accounts that belong to an Organizations organization.
 */
public suspend inline fun SecurityHubClient.deleteMembers(crossinline block: DeleteMembersRequest.Builder.() -> Unit): DeleteMembersResponse = deleteMembers(DeleteMembersRequest.Builder().apply(block).build())

/**
 * Returns a list of the custom action targets in Security Hub in your account.
 */
public suspend inline fun SecurityHubClient.describeActionTargets(crossinline block: DescribeActionTargetsRequest.Builder.() -> Unit): DescribeActionTargetsResponse = describeActionTargets(DescribeActionTargetsRequest.Builder().apply(block).build())

/**
 * Returns details about the Hub resource in your account, including the `HubArn` and the time when you enabled Security Hub.
 */
public suspend inline fun SecurityHubClient.describeHub(crossinline block: DescribeHubRequest.Builder.() -> Unit): DescribeHubResponse = describeHub(DescribeHubRequest.Builder().apply(block).build())

/**
 * Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.
 */
public suspend inline fun SecurityHubClient.describeOrganizationConfiguration(crossinline block: DescribeOrganizationConfigurationRequest.Builder.() -> Unit): DescribeOrganizationConfigurationResponse = describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Returns information about product integrations in Security Hub.
 *
 * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include that integration.
 *
 * If you do not provide an integration ARN, then the results include all of the available product integrations.
 */
public suspend inline fun SecurityHubClient.describeProducts(crossinline block: DescribeProductsRequest.Builder.() -> Unit): DescribeProductsResponse = describeProducts(DescribeProductsRequest.Builder().apply(block).build())

/**
 * Returns a list of the available standards in Security Hub.
 *
 * For each standard, the results include the standard ARN, the name, and a description.
 */
public suspend inline fun SecurityHubClient.describeStandards(crossinline block: DescribeStandardsRequest.Builder.() -> Unit): DescribeStandardsResponse = describeStandards(DescribeStandardsRequest.Builder().apply(block).build())

/**
 * Returns a list of security standards controls.
 *
 * For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.
 */
public suspend inline fun SecurityHubClient.describeStandardsControls(crossinline block: DescribeStandardsControlsRequest.Builder.() -> Unit): DescribeStandardsControlsResponse = describeStandardsControls(DescribeStandardsControlsRequest.Builder().apply(block).build())

/**
 * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.
 */
public suspend inline fun SecurityHubClient.disableImportFindingsForProduct(crossinline block: DisableImportFindingsForProductRequest.Builder.() -> Unit): DisableImportFindingsForProductResponse = disableImportFindingsForProduct(DisableImportFindingsForProductRequest.Builder().apply(block).build())

/**
 * Disables a Security Hub administrator account. Can only be called by the organization management account.
 */
public suspend inline fun SecurityHubClient.disableOrganizationAdminAccount(crossinline block: DisableOrganizationAdminAccountRequest.Builder.() -> Unit): DisableOrganizationAdminAccountResponse = disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Disables Security Hub in your account only in the current Amazon Web Services Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.
 *
 * You can't disable Security Hub in an account that is currently the Security Hub administrator.
 *
 * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed.
 *
 * If you want to save your existing findings, you must export them before you disable Security Hub.
 */
public suspend inline fun SecurityHubClient.disableSecurityHub(crossinline block: DisableSecurityHubRequest.Builder.() -> Unit): DisableSecurityHubResponse = disableSecurityHub(DisableSecurityHubRequest.Builder().apply(block).build())

/**
 * Disassociates the current Security Hub member account from the associated administrator account.
 *
 * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
 */
public suspend inline fun SecurityHubClient.disassociateFromAdministratorAccount(crossinline block: DisassociateFromAdministratorAccountRequest.Builder.() -> Unit): DisassociateFromAdministratorAccountResponse = disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.Builder().apply(block).build())

/**
 * This method is deprecated. Instead, use `DisassociateFromAdministratorAccount`.
 *
 * The Security Hub console continues to use `DisassociateFromMasterAccount`. It will eventually change to use `DisassociateFromAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `DisassociateFromMasterAccount`. You should also add `DisassociateFromAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `DisassociateFromAdministratorAccount`.
 *
 * Disassociates the current Security Hub member account from the associated administrator account.
 *
 * This operation is only used by accounts that are not part of an organization. For organization accounts, only the administrator account can disassociate a member account.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun SecurityHubClient.disassociateFromMasterAccount(crossinline block: DisassociateFromMasterAccountRequest.Builder.() -> Unit): DisassociateFromMasterAccountResponse = disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.Builder().apply(block).build())

/**
 * Disassociates the specified member accounts from the associated administrator account.
 *
 * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited manually.
 */
public suspend inline fun SecurityHubClient.disassociateMembers(crossinline block: DisassociateMembersRequest.Builder.() -> Unit): DisassociateMembersResponse = disassociateMembers(DisassociateMembersRequest.Builder().apply(block).build())

/**
 * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.
 *
 * When you enable a product integration, a permissions policy that grants permission for the product to send findings to Security Hub is applied.
 */
public suspend inline fun SecurityHubClient.enableImportFindingsForProduct(crossinline block: EnableImportFindingsForProductRequest.Builder.() -> Unit): EnableImportFindingsForProductResponse = enableImportFindingsForProduct(EnableImportFindingsForProductRequest.Builder().apply(block).build())

/**
 * Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.
 */
public suspend inline fun SecurityHubClient.enableOrganizationAdminAccount(crossinline block: EnableOrganizationAdminAccountRequest.Builder.() -> Unit): EnableOrganizationAdminAccountResponse = enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Enables Security Hub for your account in the current Region or the Region you specify in the request.
 *
 * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub.
 *
 * When you use the `EnableSecurityHub` operation to enable Security Hub, you also automatically enable the following standards:
 * + Center for Internet Security (CIS) Amazon Web Services Foundations Benchmark v1.2.0
 * + Amazon Web Services Foundational Security Best Practices
 *
 * Other standards are not automatically enabled.
 *
 * To opt out of automatically enabled standards, set `EnableDefaultStandards` to `false`.
 *
 * After you enable Security Hub, to enable a standard, use the `BatchEnableStandards` operation. To disable a standard, use the `BatchDisableStandards` operation.
 *
 * To learn more, see the [setup information](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html) in the *Security Hub User Guide*.
 */
public suspend inline fun SecurityHubClient.enableSecurityHub(crossinline block: EnableSecurityHubRequest.Builder.() -> Unit): EnableSecurityHubResponse = enableSecurityHub(EnableSecurityHubRequest.Builder().apply(block).build())

/**
 * Provides the details for the Security Hub administrator account for the current member account.
 *
 * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
 */
public suspend inline fun SecurityHubClient.getAdministratorAccount(crossinline block: GetAdministratorAccountRequest.Builder.() -> Unit): GetAdministratorAccountResponse = getAdministratorAccount(GetAdministratorAccountRequest.Builder().apply(block).build())

/**
 * Returns a list of the standards that are currently enabled.
 */
public suspend inline fun SecurityHubClient.getEnabledStandards(crossinline block: GetEnabledStandardsRequest.Builder.() -> Unit): GetEnabledStandardsResponse = getEnabledStandards(GetEnabledStandardsRequest.Builder().apply(block).build())

/**
 * Returns the current finding aggregation configuration.
 */
public suspend inline fun SecurityHubClient.getFindingAggregator(crossinline block: GetFindingAggregatorRequest.Builder.() -> Unit): GetFindingAggregatorResponse = getFindingAggregator(GetFindingAggregatorRequest.Builder().apply(block).build())

/**
 * Returns history for a Security Hub finding in the last 90 days. The history includes changes made to any fields in the Amazon Web Services Security Finding Format (ASFF).
 */
public suspend inline fun SecurityHubClient.getFindingHistory(crossinline block: GetFindingHistoryRequest.Builder.() -> Unit): GetFindingHistoryResponse = getFindingHistory(GetFindingHistoryRequest.Builder().apply(block).build())

/**
 * Returns a list of findings that match the specified criteria.
 *
 * If finding aggregation is enabled, then when you call `GetFindings` from the aggregation Region, the results include all of the matching findings from both the aggregation Region and the linked Regions.
 */
public suspend inline fun SecurityHubClient.getFindings(crossinline block: GetFindingsRequest.Builder.() -> Unit): GetFindingsResponse = getFindings(GetFindingsRequest.Builder().apply(block).build())

/**
 * Lists the results of the Security Hub insight specified by the insight ARN.
 */
public suspend inline fun SecurityHubClient.getInsightResults(crossinline block: GetInsightResultsRequest.Builder.() -> Unit): GetInsightResultsResponse = getInsightResults(GetInsightResultsRequest.Builder().apply(block).build())

/**
 * Lists and describes insights for the specified insight ARNs.
 */
public suspend inline fun SecurityHubClient.getInsights(crossinline block: GetInsightsRequest.Builder.() -> Unit): GetInsightsResponse = getInsights(GetInsightsRequest.Builder().apply(block).build())

/**
 * Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation.
 */
public suspend inline fun SecurityHubClient.getInvitationsCount(crossinline block: GetInvitationsCountRequest.Builder.() -> Unit): GetInvitationsCountResponse = getInvitationsCount(GetInvitationsCountRequest.Builder().apply(block).build())

/**
 * This method is deprecated. Instead, use `GetAdministratorAccount`.
 *
 * The Security Hub console continues to use `GetMasterAccount`. It will eventually change to use `GetAdministratorAccount`. Any IAM policies that specifically control access to this function must continue to use `GetMasterAccount`. You should also add `GetAdministratorAccount` to your policies to ensure that the correct permissions are in place after the console begins to use `GetAdministratorAccount`.
 *
 * Provides the details for the Security Hub administrator account for the current member account.
 *
 * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun SecurityHubClient.getMasterAccount(crossinline block: GetMasterAccountRequest.Builder.() -> Unit): GetMasterAccountResponse = getMasterAccount(GetMasterAccountRequest.Builder().apply(block).build())

/**
 * Returns the details for the Security Hub member accounts for the specified account IDs.
 *
 * An administrator account can be either the delegated Security Hub administrator account for an organization or an administrator account that enabled Security Hub manually.
 *
 * The results include both member accounts that are managed using Organizations and accounts that were invited manually.
 */
public suspend inline fun SecurityHubClient.getMembers(crossinline block: GetMembersRequest.Builder.() -> Unit): GetMembersResponse = getMembers(GetMembersRequest.Builder().apply(block).build())

/**
 * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.
 *
 * This operation is only used to invite accounts that do not belong to an organization. Organization accounts do not receive invitations.
 *
 * Before you can use this action to invite a member, you must first use the `CreateMembers` action to create the member account in Security Hub.
 *
 * When the account owner enables Security Hub and accepts the invitation to become a member account, the administrator account can view the findings generated from the member account.
 */
public suspend inline fun SecurityHubClient.inviteMembers(crossinline block: InviteMembersRequest.Builder.() -> Unit): InviteMembersResponse = inviteMembers(InviteMembersRequest.Builder().apply(block).build())

/**
 * A list of automation rules and their metadata for the calling account.
 */
public suspend inline fun SecurityHubClient.listAutomationRules(crossinline block: ListAutomationRulesRequest.Builder.() -> Unit): ListAutomationRulesResponse = listAutomationRules(ListAutomationRulesRequest.Builder().apply(block).build())

/**
 * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.
 */
public suspend inline fun SecurityHubClient.listEnabledProductsForImport(crossinline block: ListEnabledProductsForImportRequest.Builder.() -> Unit): ListEnabledProductsForImportResponse = listEnabledProductsForImport(ListEnabledProductsForImportRequest.Builder().apply(block).build())

/**
 * If finding aggregation is enabled, then `ListFindingAggregators` returns the ARN of the finding aggregator. You can run this operation from any Region.
 */
public suspend inline fun SecurityHubClient.listFindingAggregators(crossinline block: ListFindingAggregatorsRequest.Builder.() -> Unit): ListFindingAggregatorsResponse = listFindingAggregators(ListFindingAggregatorsRequest.Builder().apply(block).build())

/**
 * Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
 *
 * This operation is only used by accounts that are managed by invitation. Accounts that are managed using the integration with Organizations do not receive invitations.
 */
public suspend inline fun SecurityHubClient.listInvitations(crossinline block: ListInvitationsRequest.Builder.() -> Unit): ListInvitationsResponse = listInvitations(ListInvitationsRequest.Builder().apply(block).build())

/**
 * Lists details about all member accounts for the current Security Hub administrator account.
 *
 * The results include both member accounts that belong to an organization and member accounts that were invited manually.
 */
public suspend inline fun SecurityHubClient.listMembers(crossinline block: ListMembersRequest.Builder.() -> Unit): ListMembersResponse = listMembers(ListMembersRequest.Builder().apply(block).build())

/**
 * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
 */
public suspend inline fun SecurityHubClient.listOrganizationAdminAccounts(crossinline block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit): ListOrganizationAdminAccountsResponse = listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())

/**
 * Lists all of the security controls that apply to a specified standard.
 */
public suspend inline fun SecurityHubClient.listSecurityControlDefinitions(crossinline block: ListSecurityControlDefinitionsRequest.Builder.() -> Unit): ListSecurityControlDefinitionsResponse = listSecurityControlDefinitions(ListSecurityControlDefinitionsRequest.Builder().apply(block).build())

/**
 * Specifies whether a control is currently enabled or disabled in each enabled standard in the calling account.
 */
public suspend inline fun SecurityHubClient.listStandardsControlAssociations(crossinline block: ListStandardsControlAssociationsRequest.Builder.() -> Unit): ListStandardsControlAssociationsResponse = listStandardsControlAssociations(ListStandardsControlAssociationsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags associated with a resource.
 */
public suspend inline fun SecurityHubClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to a resource.
 */
public suspend inline fun SecurityHubClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a resource.
 */
public suspend inline fun SecurityHubClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the name and description of a custom action target in Security Hub.
 */
public suspend inline fun SecurityHubClient.updateActionTarget(crossinline block: UpdateActionTargetRequest.Builder.() -> Unit): UpdateActionTargetResponse = updateActionTarget(UpdateActionTargetRequest.Builder().apply(block).build())

/**
 * Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use `UpdateFindingAggregator` to change the aggregation Region.
 *
 * You must run `UpdateFindingAggregator` from the current aggregation Region.
 */
public suspend inline fun SecurityHubClient.updateFindingAggregator(crossinline block: UpdateFindingAggregatorRequest.Builder.() -> Unit): UpdateFindingAggregatorResponse = updateFindingAggregator(UpdateFindingAggregatorRequest.Builder().apply(block).build())

/**
 * `UpdateFindings` is deprecated. Instead of `UpdateFindings`, use `BatchUpdateFindings`.
 *
 * Updates the `Note` and `RecordState` of the Security Hub-aggregated findings that the filter attributes specify. Any member account that can view the finding also sees the update to the finding.
 */
public suspend inline fun SecurityHubClient.updateFindings(crossinline block: UpdateFindingsRequest.Builder.() -> Unit): UpdateFindingsResponse = updateFindings(UpdateFindingsRequest.Builder().apply(block).build())

/**
 * Updates the Security Hub insight identified by the specified insight ARN.
 */
public suspend inline fun SecurityHubClient.updateInsight(crossinline block: UpdateInsightRequest.Builder.() -> Unit): UpdateInsightResponse = updateInsight(UpdateInsightRequest.Builder().apply(block).build())

/**
 * Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.
 */
public suspend inline fun SecurityHubClient.updateOrganizationConfiguration(crossinline block: UpdateOrganizationConfigurationRequest.Builder.() -> Unit): UpdateOrganizationConfigurationResponse = updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Updates configuration options for Security Hub.
 */
public suspend inline fun SecurityHubClient.updateSecurityHubConfiguration(crossinline block: UpdateSecurityHubConfigurationRequest.Builder.() -> Unit): UpdateSecurityHubConfigurationResponse = updateSecurityHubConfiguration(UpdateSecurityHubConfigurationRequest.Builder().apply(block).build())

/**
 * Used to control whether an individual security standard control is enabled or disabled.
 */
public suspend inline fun SecurityHubClient.updateStandardsControl(crossinline block: UpdateStandardsControlRequest.Builder.() -> Unit): UpdateStandardsControlResponse = updateStandardsControl(UpdateStandardsControlRequest.Builder().apply(block).build())
