// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.services.securityhub.model.DisableOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DisableOrganizationAdminAccountOperationDeserializer: HttpDeserialize<DisableOrganizationAdminAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DisableOrganizationAdminAccountResponse {
        if (!response.status.isSuccess()) {
            throwDisableOrganizationAdminAccountError(context, response)
        }
        val builder = DisableOrganizationAdminAccountResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDisableOrganizationAdminAccountError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
