// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.transform

import aws.sdk.kotlin.services.securityhub.model.BatchGetSecurityControlsResponse
import aws.sdk.kotlin.services.securityhub.model.SecurityControl
import aws.sdk.kotlin.services.securityhub.model.SecurityHubException
import aws.sdk.kotlin.services.securityhub.model.UnprocessedSecurityControl
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetSecurityControlsOperationDeserializer: HttpDeserialize<BatchGetSecurityControlsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetSecurityControlsResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetSecurityControlsError(context, response)
        }
        val builder = BatchGetSecurityControlsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetSecurityControlsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetSecurityControlsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalException" -> InternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAccessException" -> InvalidAccessExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SecurityHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetSecurityControlsOperationBody(builder: BatchGetSecurityControlsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SECURITYCONTROLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityControls"))
    val UNPROCESSEDIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SECURITYCONTROLS_DESCRIPTOR)
        field(UNPROCESSEDIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SECURITYCONTROLS_DESCRIPTOR.index -> builder.securityControls =
                    deserializer.deserializeList(SECURITYCONTROLS_DESCRIPTOR) {
                        val col0 = mutableListOf<SecurityControl>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSecurityControlDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDIDS_DESCRIPTOR.index -> builder.unprocessedIds =
                    deserializer.deserializeList(UNPROCESSEDIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedSecurityControl>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedSecurityControlDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
