// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * A vulnerability associated with a finding.
 */
public class Vulnerability private constructor(builder: Builder) {
    /**
     * CVSS scores from the advisory related to the vulnerability.
     */
    public val cvss: List<Cvss>? = builder.cvss
    /**
     * Specifies if all vulnerable packages in a finding have a value for `FixedInVersion` and `Remediation`. This field is evaluated for each vulnerability `Id` based on the number of vulnerable packages that have a value for both `FixedInVersion` and `Remediation`. Valid values are as follows:
     * + `YES` if all vulnerable packages have a value for both `FixedInVersion` and `Remediation`
     * + `NO` if no vulnerable packages have a value for `FixedInVersion` and `Remediation`
     * + `PARTIAL` otherwise
     */
    public val fixAvailable: aws.sdk.kotlin.services.securityhub.model.VulnerabilityFixAvailable? = builder.fixAvailable
    /**
     * The identifier of the vulnerability.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A list of URLs that provide additional information about the vulnerability.
     */
    public val referenceUrls: List<String>? = builder.referenceUrls
    /**
     * List of vulnerabilities that are related to this vulnerability.
     */
    public val relatedVulnerabilities: List<String>? = builder.relatedVulnerabilities
    /**
     * Information about the vendor that generates the vulnerability report.
     */
    public val vendor: aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor? = builder.vendor
    /**
     * List of software packages that have the vulnerability.
     */
    public val vulnerablePackages: List<SoftwarePackage>? = builder.vulnerablePackages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Vulnerability = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Vulnerability(")
        append("cvss=$cvss,")
        append("fixAvailable=$fixAvailable,")
        append("id=$id,")
        append("referenceUrls=$referenceUrls,")
        append("relatedVulnerabilities=$relatedVulnerabilities,")
        append("vendor=$vendor,")
        append("vulnerablePackages=$vulnerablePackages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cvss?.hashCode() ?: 0
        result = 31 * result + (fixAvailable?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (referenceUrls?.hashCode() ?: 0)
        result = 31 * result + (relatedVulnerabilities?.hashCode() ?: 0)
        result = 31 * result + (vendor?.hashCode() ?: 0)
        result = 31 * result + (vulnerablePackages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Vulnerability

        if (cvss != other.cvss) return false
        if (fixAvailable != other.fixAvailable) return false
        if (id != other.id) return false
        if (referenceUrls != other.referenceUrls) return false
        if (relatedVulnerabilities != other.relatedVulnerabilities) return false
        if (vendor != other.vendor) return false
        if (vulnerablePackages != other.vulnerablePackages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Vulnerability = Builder(this).apply(block).build()

    public class Builder {
        /**
         * CVSS scores from the advisory related to the vulnerability.
         */
        public var cvss: List<Cvss>? = null
        /**
         * Specifies if all vulnerable packages in a finding have a value for `FixedInVersion` and `Remediation`. This field is evaluated for each vulnerability `Id` based on the number of vulnerable packages that have a value for both `FixedInVersion` and `Remediation`. Valid values are as follows:
         * + `YES` if all vulnerable packages have a value for both `FixedInVersion` and `Remediation`
         * + `NO` if no vulnerable packages have a value for `FixedInVersion` and `Remediation`
         * + `PARTIAL` otherwise
         */
        public var fixAvailable: aws.sdk.kotlin.services.securityhub.model.VulnerabilityFixAvailable? = null
        /**
         * The identifier of the vulnerability.
         */
        public var id: kotlin.String? = null
        /**
         * A list of URLs that provide additional information about the vulnerability.
         */
        public var referenceUrls: List<String>? = null
        /**
         * List of vulnerabilities that are related to this vulnerability.
         */
        public var relatedVulnerabilities: List<String>? = null
        /**
         * Information about the vendor that generates the vulnerability report.
         */
        public var vendor: aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor? = null
        /**
         * List of software packages that have the vulnerability.
         */
        public var vulnerablePackages: List<SoftwarePackage>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Vulnerability) : this() {
            this.cvss = x.cvss
            this.fixAvailable = x.fixAvailable
            this.id = x.id
            this.referenceUrls = x.referenceUrls
            this.relatedVulnerabilities = x.relatedVulnerabilities
            this.vendor = x.vendor
            this.vulnerablePackages = x.vulnerablePackages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Vulnerability = Vulnerability(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor] inside the given [block]
         */
        public fun vendor(block: aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor.Builder.() -> kotlin.Unit) {
            this.vendor = aws.sdk.kotlin.services.securityhub.model.VulnerabilityVendor.invoke(block)
        }
    }
}
