// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



public class UpdateFindingAggregatorRequest private constructor(builder: Builder) {
    /**
     * The ARN of the finding aggregator. To obtain the ARN, use `ListFindingAggregators`.
     */
    public val findingAggregatorArn: kotlin.String? = builder.findingAggregatorArn
    /**
     * Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
     *
     * The selected option also determines how to use the Regions provided in the Regions list.
     *
     * The options are as follows:
     * + `ALL_REGIONS` - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
     * + `ALL_REGIONS_EXCEPT_SPECIFIED` - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the `Regions` parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
     * + `SPECIFIED_REGIONS` - Indicates to aggregate findings only from the Regions listed in the `Regions` parameter. Security Hub does not automatically aggregate findings from new Regions.
     */
    public val regionLinkingMode: kotlin.String? = builder.regionLinkingMode
    /**
     * If `RegionLinkingMode` is `ALL_REGIONS_EXCEPT_SPECIFIED`, then this is a space-separated list of Regions that do not aggregate findings to the aggregation Region.
     *
     * If `RegionLinkingMode` is `SPECIFIED_REGIONS`, then this is a space-separated list of Regions that do aggregate findings to the aggregation Region.
     */
    public val regions: List<String>? = builder.regions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.UpdateFindingAggregatorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFindingAggregatorRequest(")
        append("findingAggregatorArn=$findingAggregatorArn,")
        append("regionLinkingMode=$regionLinkingMode,")
        append("regions=$regions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = findingAggregatorArn?.hashCode() ?: 0
        result = 31 * result + (regionLinkingMode?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFindingAggregatorRequest

        if (findingAggregatorArn != other.findingAggregatorArn) return false
        if (regionLinkingMode != other.regionLinkingMode) return false
        if (regions != other.regions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.UpdateFindingAggregatorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the finding aggregator. To obtain the ARN, use `ListFindingAggregators`.
         */
        public var findingAggregatorArn: kotlin.String? = null
        /**
         * Indicates whether to aggregate findings from all of the available Regions in the current partition. Also determines whether to automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
         *
         * The selected option also determines how to use the Regions provided in the Regions list.
         *
         * The options are as follows:
         * + `ALL_REGIONS` - Indicates to aggregate findings from all of the Regions where Security Hub is enabled. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
         * + `ALL_REGIONS_EXCEPT_SPECIFIED` - Indicates to aggregate findings from all of the Regions where Security Hub is enabled, except for the Regions listed in the `Regions` parameter. When you choose this option, Security Hub also automatically aggregates findings from new Regions as Security Hub supports them and you opt into them.
         * + `SPECIFIED_REGIONS` - Indicates to aggregate findings only from the Regions listed in the `Regions` parameter. Security Hub does not automatically aggregate findings from new Regions.
         */
        public var regionLinkingMode: kotlin.String? = null
        /**
         * If `RegionLinkingMode` is `ALL_REGIONS_EXCEPT_SPECIFIED`, then this is a space-separated list of Regions that do not aggregate findings to the aggregation Region.
         *
         * If `RegionLinkingMode` is `SPECIFIED_REGIONS`, then this is a space-separated list of Regions that do aggregate findings to the aggregation Region.
         */
        public var regions: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.UpdateFindingAggregatorRequest) : this() {
            this.findingAggregatorArn = x.findingAggregatorArn
            this.regionLinkingMode = x.regionLinkingMode
            this.regions = x.regions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.UpdateFindingAggregatorRequest = UpdateFindingAggregatorRequest(this)
    }
}
