// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides details about a control's enablement status in a specified standard.
 */
public class StandardsControlAssociationDetail private constructor(builder: Builder) {
    /**
     * Specifies whether a control is enabled or disabled in a specified standard.
     */
    public val associationStatus: aws.sdk.kotlin.services.securityhub.model.AssociationStatus? = builder.associationStatus
    /**
     * The requirement that underlies a control in the compliance framework related to the standard.
     */
    public val relatedRequirements: List<String>? = builder.relatedRequirements
    /**
     * The ARN of a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
     */
    public val securityControlArn: kotlin.String? = builder.securityControlArn
    /**
     * The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Service name and a number, such as APIGateway.3.
     */
    public val securityControlId: kotlin.String? = builder.securityControlId
    /**
     * The Amazon Resource Name (ARN) of a security standard.
     */
    public val standardsArn: kotlin.String? = builder.standardsArn
    /**
     * Provides the input parameter that Security Hub uses to call the [UpdateStandardsControl](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateStandardsControl.html) API. This API can be used to enable or disable a control in a specified standard.
     */
    public val standardsControlArns: List<String>? = builder.standardsControlArns
    /**
     * The description of a control. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter may reference a specific standard.
     */
    public val standardsControlDescription: kotlin.String? = builder.standardsControlDescription
    /**
     * The title of a control. This field may reference a specific standard.
     */
    public val standardsControlTitle: kotlin.String? = builder.standardsControlTitle
    /**
     * The time at which the enablement status of the control in the specified standard was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The reason for updating the enablement status of a control in a specified standard.
     */
    public val updatedReason: kotlin.String? = builder.updatedReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StandardsControlAssociationDetail(")
        append("associationStatus=$associationStatus,")
        append("relatedRequirements=$relatedRequirements,")
        append("securityControlArn=$securityControlArn,")
        append("securityControlId=$securityControlId,")
        append("standardsArn=$standardsArn,")
        append("standardsControlArns=$standardsControlArns,")
        append("standardsControlDescription=$standardsControlDescription,")
        append("standardsControlTitle=$standardsControlTitle,")
        append("updatedAt=$updatedAt,")
        append("updatedReason=$updatedReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationStatus?.hashCode() ?: 0
        result = 31 * result + (relatedRequirements?.hashCode() ?: 0)
        result = 31 * result + (securityControlArn?.hashCode() ?: 0)
        result = 31 * result + (securityControlId?.hashCode() ?: 0)
        result = 31 * result + (standardsArn?.hashCode() ?: 0)
        result = 31 * result + (standardsControlArns?.hashCode() ?: 0)
        result = 31 * result + (standardsControlDescription?.hashCode() ?: 0)
        result = 31 * result + (standardsControlTitle?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (updatedReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StandardsControlAssociationDetail

        if (associationStatus != other.associationStatus) return false
        if (relatedRequirements != other.relatedRequirements) return false
        if (securityControlArn != other.securityControlArn) return false
        if (securityControlId != other.securityControlId) return false
        if (standardsArn != other.standardsArn) return false
        if (standardsControlArns != other.standardsControlArns) return false
        if (standardsControlDescription != other.standardsControlDescription) return false
        if (standardsControlTitle != other.standardsControlTitle) return false
        if (updatedAt != other.updatedAt) return false
        if (updatedReason != other.updatedReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether a control is enabled or disabled in a specified standard.
         */
        public var associationStatus: aws.sdk.kotlin.services.securityhub.model.AssociationStatus? = null
        /**
         * The requirement that underlies a control in the compliance framework related to the standard.
         */
        public var relatedRequirements: List<String>? = null
        /**
         * The ARN of a security control across standards, such as `arn:aws:securityhub:eu-central-1:123456789012:security-control/S3.1`. This parameter doesn't mention a specific standard.
         */
        public var securityControlArn: kotlin.String? = null
        /**
         * The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Service name and a number, such as APIGateway.3.
         */
        public var securityControlId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a security standard.
         */
        public var standardsArn: kotlin.String? = null
        /**
         * Provides the input parameter that Security Hub uses to call the [UpdateStandardsControl](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_UpdateStandardsControl.html) API. This API can be used to enable or disable a control in a specified standard.
         */
        public var standardsControlArns: List<String>? = null
        /**
         * The description of a control. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter may reference a specific standard.
         */
        public var standardsControlDescription: kotlin.String? = null
        /**
         * The title of a control. This field may reference a specific standard.
         */
        public var standardsControlTitle: kotlin.String? = null
        /**
         * The time at which the enablement status of the control in the specified standard was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The reason for updating the enablement status of a control in a specified standard.
         */
        public var updatedReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationDetail) : this() {
            this.associationStatus = x.associationStatus
            this.relatedRequirements = x.relatedRequirements
            this.securityControlArn = x.securityControlArn
            this.securityControlId = x.securityControlId
            this.standardsArn = x.standardsArn
            this.standardsControlArns = x.standardsControlArns
            this.standardsControlDescription = x.standardsControlDescription
            this.standardsControlTitle = x.standardsControlTitle
            this.updatedAt = x.updatedAt
            this.updatedReason = x.updatedReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.StandardsControlAssociationDetail = StandardsControlAssociationDetail(this)
    }
}
