// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides metadata for a security control, including its unique standard-agnostic identifier, title, description, severity, availability in Amazon Web Services Regions, and a link to remediation steps.
 */
public class SecurityControlDefinition private constructor(builder: Builder) {
    /**
     * Specifies whether a security control is available in the current Amazon Web Services Region.
     */
    public val currentRegionAvailability: aws.sdk.kotlin.services.securityhub.model.RegionAvailabilityStatus? = builder.currentRegionAvailability
    /**
     * The description of a security control across standards. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter doesn't reference a specific standard.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A link to Security Hub documentation that explains how to remediate a failed finding for a security control.
     */
    public val remediationUrl: kotlin.String? = builder.remediationUrl
    /**
     * The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Service name and a number (for example, APIGateway.3). This parameter differs from `SecurityControlArn`, which is a unique Amazon Resource Name (ARN) assigned to a control. The ARN references the security control ID (for example, arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3).
     */
    public val securityControlId: kotlin.String? = builder.securityControlId
    /**
     * The severity of a security control. For more information about how Security Hub determines control severity, see [Assigning severity to control findings](https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity) in the *Security Hub User Guide*.
     */
    public val severityRating: aws.sdk.kotlin.services.securityhub.model.SeverityRating? = builder.severityRating
    /**
     * The title of a security control.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.SecurityControlDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityControlDefinition(")
        append("currentRegionAvailability=$currentRegionAvailability,")
        append("description=$description,")
        append("remediationUrl=$remediationUrl,")
        append("securityControlId=$securityControlId,")
        append("severityRating=$severityRating,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentRegionAvailability?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (remediationUrl?.hashCode() ?: 0)
        result = 31 * result + (securityControlId?.hashCode() ?: 0)
        result = 31 * result + (severityRating?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityControlDefinition

        if (currentRegionAvailability != other.currentRegionAvailability) return false
        if (description != other.description) return false
        if (remediationUrl != other.remediationUrl) return false
        if (securityControlId != other.securityControlId) return false
        if (severityRating != other.severityRating) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.SecurityControlDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether a security control is available in the current Amazon Web Services Region.
         */
        public var currentRegionAvailability: aws.sdk.kotlin.services.securityhub.model.RegionAvailabilityStatus? = null
        /**
         * The description of a security control across standards. This typically summarizes how Security Hub evaluates the control and the conditions under which it produces a failed finding. This parameter doesn't reference a specific standard.
         */
        public var description: kotlin.String? = null
        /**
         * A link to Security Hub documentation that explains how to remediate a failed finding for a security control.
         */
        public var remediationUrl: kotlin.String? = null
        /**
         * The unique identifier of a security control across standards. Values for this field typically consist of an Amazon Web Service name and a number (for example, APIGateway.3). This parameter differs from `SecurityControlArn`, which is a unique Amazon Resource Name (ARN) assigned to a control. The ARN references the security control ID (for example, arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3).
         */
        public var securityControlId: kotlin.String? = null
        /**
         * The severity of a security control. For more information about how Security Hub determines control severity, see [Assigning severity to control findings](https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity) in the *Security Hub User Guide*.
         */
        public var severityRating: aws.sdk.kotlin.services.securityhub.model.SeverityRating? = null
        /**
         * The title of a security control.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.SecurityControlDefinition) : this() {
            this.currentRegionAvailability = x.currentRegionAvailability
            this.description = x.description
            this.remediationUrl = x.remediationUrl
            this.securityControlId = x.securityControlId
            this.severityRating = x.severityRating
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.SecurityControlDefinition = SecurityControlDefinition(this)
    }
}
