// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Additional details about a resource related to a finding.
 *
 * To provide the details, use the object that corresponds to the resource type. For example, if the resource type is `AwsEc2Instance`, then you use the `AwsEc2Instance` object to provide the details.
 *
 * If the type-specific object does not contain all of the fields you want to populate, then you use the `Other` object to populate those additional fields.
 *
 * You also use the `Other` object to populate the details when the selected type does not have a corresponding object.
 */
public class ResourceDetails private constructor(builder: Builder) {
    /**
     * Provides information about a REST API in version 1 of Amazon API Gateway.
     */
    public val awsApiGatewayRestApi: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails? = builder.awsApiGatewayRestApi
    /**
     * Provides information about a version 1 Amazon API Gateway stage.
     */
    public val awsApiGatewayStage: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails? = builder.awsApiGatewayStage
    /**
     * Provides information about a version 2 API in Amazon API Gateway.
     */
    public val awsApiGatewayV2Api: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails? = builder.awsApiGatewayV2Api
    /**
     * Provides information about a version 2 stage for Amazon API Gateway.
     */
    public val awsApiGatewayV2Stage: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails? = builder.awsApiGatewayV2Stage
    /**
     * Details for an autoscaling group.
     */
    public val awsAutoScalingAutoScalingGroup: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails? = builder.awsAutoScalingAutoScalingGroup
    /**
     * Provides details about a launch configuration.
     */
    public val awsAutoScalingLaunchConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails? = builder.awsAutoScalingLaunchConfiguration
    /**
     * Provides details about an Backup backup plan.
     */
    public val awsBackupBackupPlan: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanDetails? = builder.awsBackupBackupPlan
    /**
     * Provides details about an Backup backup vault.
     */
    public val awsBackupBackupVault: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails? = builder.awsBackupBackupVault
    /**
     * Provides details about an Backup backup, or recovery point.
     */
    public val awsBackupRecoveryPoint: aws.sdk.kotlin.services.securityhub.model.AwsBackupRecoveryPointDetails? = builder.awsBackupRecoveryPoint
    /**
     * Provides details about an Certificate Manager certificate.
     */
    public val awsCertificateManagerCertificate: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails? = builder.awsCertificateManagerCertificate
    /**
     * Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that you can manage as a single unit.
     */
    public val awsCloudFormationStack: aws.sdk.kotlin.services.securityhub.model.AwsCloudFormationStackDetails? = builder.awsCloudFormationStack
    /**
     * Details about a CloudFront distribution.
     */
    public val awsCloudFrontDistribution: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionDetails? = builder.awsCloudFrontDistribution
    /**
     * Provides details about a CloudTrail trail.
     */
    public val awsCloudTrailTrail: aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails? = builder.awsCloudTrailTrail
    /**
     * Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your Amazon Web Services resources and applications across multiple Regions.
     */
    public val awsCloudWatchAlarm: aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails? = builder.awsCloudWatchAlarm
    /**
     * Details for an CodeBuild project.
     */
    public val awsCodeBuildProject: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails? = builder.awsCodeBuildProject
    /**
     * Details about a DynamoDB table.
     */
    public val awsDynamoDbTable: aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableDetails? = builder.awsDynamoDbTable
    /**
     * Details about an Elastic IP address.
     */
    public val awsEc2Eip: aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails? = builder.awsEc2Eip
    /**
     * Details about an EC2 instance related to a finding.
     */
    public val awsEc2Instance: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails? = builder.awsEc2Instance
    /**
     * Specifies the properties for creating an Amazon Elastic Compute Cloud (Amazon EC2) launch template.
     */
    public val awsEc2LaunchTemplate: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDetails? = builder.awsEc2LaunchTemplate
    /**
     * Details about an EC2 network access control list (ACL).
     */
    public val awsEc2NetworkAcl: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails? = builder.awsEc2NetworkAcl
    /**
     * Details for an EC2 network interface.
     */
    public val awsEc2NetworkInterface: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceDetails? = builder.awsEc2NetworkInterface
    /**
     * Provides details about a route table. A route table contains a set of rules, called routes, that determine where to direct network traffic from your subnet or gateway.
     */
    public val awsEc2RouteTable: aws.sdk.kotlin.services.securityhub.model.AwsEc2RouteTableDetails? = builder.awsEc2RouteTable
    /**
     * Details for an EC2 security group.
     */
    public val awsEc2SecurityGroup: aws.sdk.kotlin.services.securityhub.model.AwsEc2SecurityGroupDetails? = builder.awsEc2SecurityGroup
    /**
     * Details about a subnet in Amazon EC2.
     */
    public val awsEc2Subnet: aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails? = builder.awsEc2Subnet
    /**
     * Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and on-premises networks.
     */
    public val awsEc2TransitGateway: aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails? = builder.awsEc2TransitGateway
    /**
     * Details for an Amazon EC2 volume.
     */
    public val awsEc2Volume: aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails? = builder.awsEc2Volume
    /**
     * Details for an Amazon EC2 VPC.
     */
    public val awsEc2Vpc: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcDetails? = builder.awsEc2Vpc
    /**
     * Details about the service configuration for a VPC endpoint service.
     */
    public val awsEc2VpcEndpointService: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails? = builder.awsEc2VpcEndpointService
    /**
     * Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking connection between two VPCs that enables you to route traffic between them privately.
     */
    public val awsEc2VpcPeeringConnection: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails? = builder.awsEc2VpcPeeringConnection
    /**
     * Details about an Amazon EC2 VPN connection.
     */
    public val awsEc2VpnConnection: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails? = builder.awsEc2VpnConnection
    /**
     * Information about an Amazon ECR image.
     */
    public val awsEcrContainerImage: aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails? = builder.awsEcrContainerImage
    /**
     * Information about an Amazon Elastic Container Registry repository.
     */
    public val awsEcrRepository: aws.sdk.kotlin.services.securityhub.model.AwsEcrRepositoryDetails? = builder.awsEcrRepository
    /**
     * Details about an Amazon ECS cluster.
     */
    public val awsEcsCluster: aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails? = builder.awsEcsCluster
    /**
     * Provides information about a Docker container that's part of a task.
     */
    public val awsEcsContainer: aws.sdk.kotlin.services.securityhub.model.AwsEcsContainerDetails? = builder.awsEcsContainer
    /**
     * Details about a service within an ECS cluster.
     */
    public val awsEcsService: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails? = builder.awsEcsService
    /**
     * Details about a task in a cluster.
     */
    public val awsEcsTask: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails? = builder.awsEcsTask
    /**
     * Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.
     */
    public val awsEcsTaskDefinition: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails? = builder.awsEcsTaskDefinition
    /**
     * Details about an Amazon EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point.
     */
    public val awsEfsAccessPoint: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails? = builder.awsEfsAccessPoint
    /**
     * Details about an Amazon EKS cluster.
     */
    public val awsEksCluster: aws.sdk.kotlin.services.securityhub.model.AwsEksClusterDetails? = builder.awsEksCluster
    /**
     * Details about an Elastic Beanstalk environment.
     */
    public val awsElasticBeanstalkEnvironment: aws.sdk.kotlin.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails? = builder.awsElasticBeanstalkEnvironment
    /**
     * Details for an Elasticsearch domain.
     */
    public val awsElasticsearchDomain: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails? = builder.awsElasticsearchDomain
    /**
     * Contains details about a Classic Load Balancer.
     */
    public val awsElbLoadBalancer: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails? = builder.awsElbLoadBalancer
    /**
     * Details about a load balancer.
     */
    public val awsElbv2LoadBalancer: aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails? = builder.awsElbv2LoadBalancer
    /**
     * Details about an IAM access key related to a finding.
     */
    public val awsIamAccessKey: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails? = builder.awsIamAccessKey
    /**
     * Contains details about an IAM group.
     */
    public val awsIamGroup: aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails? = builder.awsIamGroup
    /**
     * Details about an IAM permissions policy.
     */
    public val awsIamPolicy: aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails? = builder.awsIamPolicy
    /**
     * Details about an IAM role.
     */
    public val awsIamRole: aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails? = builder.awsIamRole
    /**
     * Details about an IAM user.
     */
    public val awsIamUser: aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails? = builder.awsIamUser
    /**
     * Details about an Amazon Kinesis data stream.
     */
    public val awsKinesisStream: aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails? = builder.awsKinesisStream
    /**
     * Details about an KMS key.
     */
    public val awsKmsKey: aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails? = builder.awsKmsKey
    /**
     * Details about a Lambda function.
     */
    public val awsLambdaFunction: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails? = builder.awsLambdaFunction
    /**
     * Details for a Lambda layer version.
     */
    public val awsLambdaLayerVersion: aws.sdk.kotlin.services.securityhub.model.AwsLambdaLayerVersionDetails? = builder.awsLambdaLayerVersion
    /**
     * Details about an Network Firewall firewall.
     */
    public val awsNetworkFirewallFirewall: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallDetails? = builder.awsNetworkFirewallFirewall
    /**
     * Details about an Network Firewall firewall policy.
     */
    public val awsNetworkFirewallFirewallPolicy: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails? = builder.awsNetworkFirewallFirewallPolicy
    /**
     * Details about an Network Firewall rule group.
     */
    public val awsNetworkFirewallRuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails? = builder.awsNetworkFirewallRuleGroup
    /**
     * Details about an Amazon OpenSearch Service domain.
     */
    public val awsOpenSearchServiceDomain: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails? = builder.awsOpenSearchServiceDomain
    /**
     * Details about an Amazon RDS database cluster.
     */
    public val awsRdsDbCluster: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails? = builder.awsRdsDbCluster
    /**
     * Details about an Amazon RDS database cluster snapshot.
     */
    public val awsRdsDbClusterSnapshot: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails? = builder.awsRdsDbClusterSnapshot
    /**
     * Details about an Amazon RDS database instance.
     */
    public val awsRdsDbInstance: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails? = builder.awsRdsDbInstance
    /**
     * Details about an Amazon RDS DB security group.
     */
    public val awsRdsDbSecurityGroup: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSecurityGroupDetails? = builder.awsRdsDbSecurityGroup
    /**
     * Details about an Amazon RDS database snapshot.
     */
    public val awsRdsDbSnapshot: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails? = builder.awsRdsDbSnapshot
    /**
     * Details about an RDS event notification subscription.
     */
    public val awsRdsEventSubscription: aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails? = builder.awsRdsEventSubscription
    /**
     * Contains details about an Amazon Redshift cluster.
     */
    public val awsRedshiftCluster: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails? = builder.awsRedshiftCluster
    /**
     * Details about the Amazon S3 Public Access Block configuration for an account.
     */
    public val awsS3AccountPublicAccessBlock: aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails? = builder.awsS3AccountPublicAccessBlock
    /**
     * Details about an S3 bucket related to a finding.
     */
    public val awsS3Bucket: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketDetails? = builder.awsS3Bucket
    /**
     * Details about an S3 object related to a finding.
     */
    public val awsS3Object: aws.sdk.kotlin.services.securityhub.model.AwsS3ObjectDetails? = builder.awsS3Object
    /**
     * Provides details about an Amazon SageMaker notebook instance.
     */
    public val awsSageMakerNotebookInstance: aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails? = builder.awsSageMakerNotebookInstance
    /**
     * Details about a Secrets Manager secret.
     */
    public val awsSecretsManagerSecret: aws.sdk.kotlin.services.securityhub.model.AwsSecretsManagerSecretDetails? = builder.awsSecretsManagerSecret
    /**
     * Details about an SNS topic.
     */
    public val awsSnsTopic: aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails? = builder.awsSnsTopic
    /**
     * Details about an SQS queue.
     */
    public val awsSqsQueue: aws.sdk.kotlin.services.securityhub.model.AwsSqsQueueDetails? = builder.awsSqsQueue
    /**
     * Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the instance.
     */
    public val awsSsmPatchCompliance: aws.sdk.kotlin.services.securityhub.model.AwsSsmPatchComplianceDetails? = builder.awsSsmPatchCompliance
    /**
     * Details about a rate-based rule for global resources.
     */
    public val awsWafRateBasedRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails? = builder.awsWafRateBasedRule
    /**
     * Details about a rate-based rule for Regional resources.
     */
    public val awsWafRegionalRateBasedRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails? = builder.awsWafRegionalRateBasedRule
    /**
     * Details about an WAF rule for Regional resources.
     */
    public val awsWafRegionalRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleDetails? = builder.awsWafRegionalRule
    /**
     * Details about an WAF rule group for Regional resources.
     */
    public val awsWafRegionalRuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleGroupDetails? = builder.awsWafRegionalRuleGroup
    /**
     * Details about an WAF web access control list (web ACL) for Regional resources.
     */
    public val awsWafRegionalWebAcl: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails? = builder.awsWafRegionalWebAcl
    /**
     * Details about an WAF rule for global resources.
     */
    public val awsWafRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRuleDetails? = builder.awsWafRule
    /**
     * Details about an WAF rule group for global resources.
     */
    public val awsWafRuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsWafRuleGroupDetails? = builder.awsWafRuleGroup
    /**
     * Details for an WAF web ACL.
     */
    public val awsWafWebAcl: aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclDetails? = builder.awsWafWebAcl
    /**
     * Details about an WAFv2 rule group.
     */
    public val awsWafv2RuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails? = builder.awsWafv2RuleGroup
    /**
     * Details about an WAFv2 web Access Control List (ACL).
     */
    public val awsWafv2WebAcl: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails? = builder.awsWafv2WebAcl
    /**
     * Information about the encryption configuration for X-Ray.
     */
    public val awsXrayEncryptionConfig: aws.sdk.kotlin.services.securityhub.model.AwsXrayEncryptionConfigDetails? = builder.awsXrayEncryptionConfig
    /**
     * Details about a container resource related to a finding.
     */
    public val container: aws.sdk.kotlin.services.securityhub.model.ContainerDetails? = builder.container
    /**
     * Details about a resource that are not available in a type-specific details object. Use the `Other` object in the following cases.
     * + The type-specific object does not contain all of the fields that you want to populate. In this case, first use the type-specific object to populate those fields. Use the `Other` object to populate the fields that are missing from the type-specific object.
     * + The resource type does not have a corresponding object. This includes resources for which the type is `Other`.
     */
    public val other: Map<String, String>? = builder.other

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.ResourceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDetails(")
        append("awsApiGatewayRestApi=$awsApiGatewayRestApi,")
        append("awsApiGatewayStage=$awsApiGatewayStage,")
        append("awsApiGatewayV2Api=$awsApiGatewayV2Api,")
        append("awsApiGatewayV2Stage=$awsApiGatewayV2Stage,")
        append("awsAutoScalingAutoScalingGroup=$awsAutoScalingAutoScalingGroup,")
        append("awsAutoScalingLaunchConfiguration=$awsAutoScalingLaunchConfiguration,")
        append("awsBackupBackupPlan=$awsBackupBackupPlan,")
        append("awsBackupBackupVault=$awsBackupBackupVault,")
        append("awsBackupRecoveryPoint=$awsBackupRecoveryPoint,")
        append("awsCertificateManagerCertificate=$awsCertificateManagerCertificate,")
        append("awsCloudFormationStack=$awsCloudFormationStack,")
        append("awsCloudFrontDistribution=$awsCloudFrontDistribution,")
        append("awsCloudTrailTrail=$awsCloudTrailTrail,")
        append("awsCloudWatchAlarm=$awsCloudWatchAlarm,")
        append("awsCodeBuildProject=$awsCodeBuildProject,")
        append("awsDynamoDbTable=$awsDynamoDbTable,")
        append("awsEc2Eip=$awsEc2Eip,")
        append("awsEc2Instance=$awsEc2Instance,")
        append("awsEc2LaunchTemplate=$awsEc2LaunchTemplate,")
        append("awsEc2NetworkAcl=$awsEc2NetworkAcl,")
        append("awsEc2NetworkInterface=$awsEc2NetworkInterface,")
        append("awsEc2RouteTable=$awsEc2RouteTable,")
        append("awsEc2SecurityGroup=$awsEc2SecurityGroup,")
        append("awsEc2Subnet=$awsEc2Subnet,")
        append("awsEc2TransitGateway=$awsEc2TransitGateway,")
        append("awsEc2Volume=$awsEc2Volume,")
        append("awsEc2Vpc=$awsEc2Vpc,")
        append("awsEc2VpcEndpointService=$awsEc2VpcEndpointService,")
        append("awsEc2VpcPeeringConnection=$awsEc2VpcPeeringConnection,")
        append("awsEc2VpnConnection=$awsEc2VpnConnection,")
        append("awsEcrContainerImage=$awsEcrContainerImage,")
        append("awsEcrRepository=$awsEcrRepository,")
        append("awsEcsCluster=$awsEcsCluster,")
        append("awsEcsContainer=$awsEcsContainer,")
        append("awsEcsService=$awsEcsService,")
        append("awsEcsTask=$awsEcsTask,")
        append("awsEcsTaskDefinition=$awsEcsTaskDefinition,")
        append("awsEfsAccessPoint=$awsEfsAccessPoint,")
        append("awsEksCluster=$awsEksCluster,")
        append("awsElasticBeanstalkEnvironment=$awsElasticBeanstalkEnvironment,")
        append("awsElasticsearchDomain=$awsElasticsearchDomain,")
        append("awsElbLoadBalancer=$awsElbLoadBalancer,")
        append("awsElbv2LoadBalancer=$awsElbv2LoadBalancer,")
        append("awsIamAccessKey=$awsIamAccessKey,")
        append("awsIamGroup=$awsIamGroup,")
        append("awsIamPolicy=$awsIamPolicy,")
        append("awsIamRole=$awsIamRole,")
        append("awsIamUser=$awsIamUser,")
        append("awsKinesisStream=$awsKinesisStream,")
        append("awsKmsKey=$awsKmsKey,")
        append("awsLambdaFunction=$awsLambdaFunction,")
        append("awsLambdaLayerVersion=$awsLambdaLayerVersion,")
        append("awsNetworkFirewallFirewall=$awsNetworkFirewallFirewall,")
        append("awsNetworkFirewallFirewallPolicy=$awsNetworkFirewallFirewallPolicy,")
        append("awsNetworkFirewallRuleGroup=$awsNetworkFirewallRuleGroup,")
        append("awsOpenSearchServiceDomain=$awsOpenSearchServiceDomain,")
        append("awsRdsDbCluster=$awsRdsDbCluster,")
        append("awsRdsDbClusterSnapshot=$awsRdsDbClusterSnapshot,")
        append("awsRdsDbInstance=$awsRdsDbInstance,")
        append("awsRdsDbSecurityGroup=$awsRdsDbSecurityGroup,")
        append("awsRdsDbSnapshot=$awsRdsDbSnapshot,")
        append("awsRdsEventSubscription=$awsRdsEventSubscription,")
        append("awsRedshiftCluster=$awsRedshiftCluster,")
        append("awsS3AccountPublicAccessBlock=$awsS3AccountPublicAccessBlock,")
        append("awsS3Bucket=$awsS3Bucket,")
        append("awsS3Object=$awsS3Object,")
        append("awsSageMakerNotebookInstance=$awsSageMakerNotebookInstance,")
        append("awsSecretsManagerSecret=$awsSecretsManagerSecret,")
        append("awsSnsTopic=$awsSnsTopic,")
        append("awsSqsQueue=$awsSqsQueue,")
        append("awsSsmPatchCompliance=$awsSsmPatchCompliance,")
        append("awsWafRateBasedRule=$awsWafRateBasedRule,")
        append("awsWafRegionalRateBasedRule=$awsWafRegionalRateBasedRule,")
        append("awsWafRegionalRule=$awsWafRegionalRule,")
        append("awsWafRegionalRuleGroup=$awsWafRegionalRuleGroup,")
        append("awsWafRegionalWebAcl=$awsWafRegionalWebAcl,")
        append("awsWafRule=$awsWafRule,")
        append("awsWafRuleGroup=$awsWafRuleGroup,")
        append("awsWafWebAcl=$awsWafWebAcl,")
        append("awsWafv2RuleGroup=$awsWafv2RuleGroup,")
        append("awsWafv2WebAcl=$awsWafv2WebAcl,")
        append("awsXrayEncryptionConfig=$awsXrayEncryptionConfig,")
        append("container=$container,")
        append("other=$other")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsApiGatewayRestApi?.hashCode() ?: 0
        result = 31 * result + (awsApiGatewayStage?.hashCode() ?: 0)
        result = 31 * result + (awsApiGatewayV2Api?.hashCode() ?: 0)
        result = 31 * result + (awsApiGatewayV2Stage?.hashCode() ?: 0)
        result = 31 * result + (awsAutoScalingAutoScalingGroup?.hashCode() ?: 0)
        result = 31 * result + (awsAutoScalingLaunchConfiguration?.hashCode() ?: 0)
        result = 31 * result + (awsBackupBackupPlan?.hashCode() ?: 0)
        result = 31 * result + (awsBackupBackupVault?.hashCode() ?: 0)
        result = 31 * result + (awsBackupRecoveryPoint?.hashCode() ?: 0)
        result = 31 * result + (awsCertificateManagerCertificate?.hashCode() ?: 0)
        result = 31 * result + (awsCloudFormationStack?.hashCode() ?: 0)
        result = 31 * result + (awsCloudFrontDistribution?.hashCode() ?: 0)
        result = 31 * result + (awsCloudTrailTrail?.hashCode() ?: 0)
        result = 31 * result + (awsCloudWatchAlarm?.hashCode() ?: 0)
        result = 31 * result + (awsCodeBuildProject?.hashCode() ?: 0)
        result = 31 * result + (awsDynamoDbTable?.hashCode() ?: 0)
        result = 31 * result + (awsEc2Eip?.hashCode() ?: 0)
        result = 31 * result + (awsEc2Instance?.hashCode() ?: 0)
        result = 31 * result + (awsEc2LaunchTemplate?.hashCode() ?: 0)
        result = 31 * result + (awsEc2NetworkAcl?.hashCode() ?: 0)
        result = 31 * result + (awsEc2NetworkInterface?.hashCode() ?: 0)
        result = 31 * result + (awsEc2RouteTable?.hashCode() ?: 0)
        result = 31 * result + (awsEc2SecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (awsEc2Subnet?.hashCode() ?: 0)
        result = 31 * result + (awsEc2TransitGateway?.hashCode() ?: 0)
        result = 31 * result + (awsEc2Volume?.hashCode() ?: 0)
        result = 31 * result + (awsEc2Vpc?.hashCode() ?: 0)
        result = 31 * result + (awsEc2VpcEndpointService?.hashCode() ?: 0)
        result = 31 * result + (awsEc2VpcPeeringConnection?.hashCode() ?: 0)
        result = 31 * result + (awsEc2VpnConnection?.hashCode() ?: 0)
        result = 31 * result + (awsEcrContainerImage?.hashCode() ?: 0)
        result = 31 * result + (awsEcrRepository?.hashCode() ?: 0)
        result = 31 * result + (awsEcsCluster?.hashCode() ?: 0)
        result = 31 * result + (awsEcsContainer?.hashCode() ?: 0)
        result = 31 * result + (awsEcsService?.hashCode() ?: 0)
        result = 31 * result + (awsEcsTask?.hashCode() ?: 0)
        result = 31 * result + (awsEcsTaskDefinition?.hashCode() ?: 0)
        result = 31 * result + (awsEfsAccessPoint?.hashCode() ?: 0)
        result = 31 * result + (awsEksCluster?.hashCode() ?: 0)
        result = 31 * result + (awsElasticBeanstalkEnvironment?.hashCode() ?: 0)
        result = 31 * result + (awsElasticsearchDomain?.hashCode() ?: 0)
        result = 31 * result + (awsElbLoadBalancer?.hashCode() ?: 0)
        result = 31 * result + (awsElbv2LoadBalancer?.hashCode() ?: 0)
        result = 31 * result + (awsIamAccessKey?.hashCode() ?: 0)
        result = 31 * result + (awsIamGroup?.hashCode() ?: 0)
        result = 31 * result + (awsIamPolicy?.hashCode() ?: 0)
        result = 31 * result + (awsIamRole?.hashCode() ?: 0)
        result = 31 * result + (awsIamUser?.hashCode() ?: 0)
        result = 31 * result + (awsKinesisStream?.hashCode() ?: 0)
        result = 31 * result + (awsKmsKey?.hashCode() ?: 0)
        result = 31 * result + (awsLambdaFunction?.hashCode() ?: 0)
        result = 31 * result + (awsLambdaLayerVersion?.hashCode() ?: 0)
        result = 31 * result + (awsNetworkFirewallFirewall?.hashCode() ?: 0)
        result = 31 * result + (awsNetworkFirewallFirewallPolicy?.hashCode() ?: 0)
        result = 31 * result + (awsNetworkFirewallRuleGroup?.hashCode() ?: 0)
        result = 31 * result + (awsOpenSearchServiceDomain?.hashCode() ?: 0)
        result = 31 * result + (awsRdsDbCluster?.hashCode() ?: 0)
        result = 31 * result + (awsRdsDbClusterSnapshot?.hashCode() ?: 0)
        result = 31 * result + (awsRdsDbInstance?.hashCode() ?: 0)
        result = 31 * result + (awsRdsDbSecurityGroup?.hashCode() ?: 0)
        result = 31 * result + (awsRdsDbSnapshot?.hashCode() ?: 0)
        result = 31 * result + (awsRdsEventSubscription?.hashCode() ?: 0)
        result = 31 * result + (awsRedshiftCluster?.hashCode() ?: 0)
        result = 31 * result + (awsS3AccountPublicAccessBlock?.hashCode() ?: 0)
        result = 31 * result + (awsS3Bucket?.hashCode() ?: 0)
        result = 31 * result + (awsS3Object?.hashCode() ?: 0)
        result = 31 * result + (awsSageMakerNotebookInstance?.hashCode() ?: 0)
        result = 31 * result + (awsSecretsManagerSecret?.hashCode() ?: 0)
        result = 31 * result + (awsSnsTopic?.hashCode() ?: 0)
        result = 31 * result + (awsSqsQueue?.hashCode() ?: 0)
        result = 31 * result + (awsSsmPatchCompliance?.hashCode() ?: 0)
        result = 31 * result + (awsWafRateBasedRule?.hashCode() ?: 0)
        result = 31 * result + (awsWafRegionalRateBasedRule?.hashCode() ?: 0)
        result = 31 * result + (awsWafRegionalRule?.hashCode() ?: 0)
        result = 31 * result + (awsWafRegionalRuleGroup?.hashCode() ?: 0)
        result = 31 * result + (awsWafRegionalWebAcl?.hashCode() ?: 0)
        result = 31 * result + (awsWafRule?.hashCode() ?: 0)
        result = 31 * result + (awsWafRuleGroup?.hashCode() ?: 0)
        result = 31 * result + (awsWafWebAcl?.hashCode() ?: 0)
        result = 31 * result + (awsWafv2RuleGroup?.hashCode() ?: 0)
        result = 31 * result + (awsWafv2WebAcl?.hashCode() ?: 0)
        result = 31 * result + (awsXrayEncryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (other?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDetails

        if (awsApiGatewayRestApi != other.awsApiGatewayRestApi) return false
        if (awsApiGatewayStage != other.awsApiGatewayStage) return false
        if (awsApiGatewayV2Api != other.awsApiGatewayV2Api) return false
        if (awsApiGatewayV2Stage != other.awsApiGatewayV2Stage) return false
        if (awsAutoScalingAutoScalingGroup != other.awsAutoScalingAutoScalingGroup) return false
        if (awsAutoScalingLaunchConfiguration != other.awsAutoScalingLaunchConfiguration) return false
        if (awsBackupBackupPlan != other.awsBackupBackupPlan) return false
        if (awsBackupBackupVault != other.awsBackupBackupVault) return false
        if (awsBackupRecoveryPoint != other.awsBackupRecoveryPoint) return false
        if (awsCertificateManagerCertificate != other.awsCertificateManagerCertificate) return false
        if (awsCloudFormationStack != other.awsCloudFormationStack) return false
        if (awsCloudFrontDistribution != other.awsCloudFrontDistribution) return false
        if (awsCloudTrailTrail != other.awsCloudTrailTrail) return false
        if (awsCloudWatchAlarm != other.awsCloudWatchAlarm) return false
        if (awsCodeBuildProject != other.awsCodeBuildProject) return false
        if (awsDynamoDbTable != other.awsDynamoDbTable) return false
        if (awsEc2Eip != other.awsEc2Eip) return false
        if (awsEc2Instance != other.awsEc2Instance) return false
        if (awsEc2LaunchTemplate != other.awsEc2LaunchTemplate) return false
        if (awsEc2NetworkAcl != other.awsEc2NetworkAcl) return false
        if (awsEc2NetworkInterface != other.awsEc2NetworkInterface) return false
        if (awsEc2RouteTable != other.awsEc2RouteTable) return false
        if (awsEc2SecurityGroup != other.awsEc2SecurityGroup) return false
        if (awsEc2Subnet != other.awsEc2Subnet) return false
        if (awsEc2TransitGateway != other.awsEc2TransitGateway) return false
        if (awsEc2Volume != other.awsEc2Volume) return false
        if (awsEc2Vpc != other.awsEc2Vpc) return false
        if (awsEc2VpcEndpointService != other.awsEc2VpcEndpointService) return false
        if (awsEc2VpcPeeringConnection != other.awsEc2VpcPeeringConnection) return false
        if (awsEc2VpnConnection != other.awsEc2VpnConnection) return false
        if (awsEcrContainerImage != other.awsEcrContainerImage) return false
        if (awsEcrRepository != other.awsEcrRepository) return false
        if (awsEcsCluster != other.awsEcsCluster) return false
        if (awsEcsContainer != other.awsEcsContainer) return false
        if (awsEcsService != other.awsEcsService) return false
        if (awsEcsTask != other.awsEcsTask) return false
        if (awsEcsTaskDefinition != other.awsEcsTaskDefinition) return false
        if (awsEfsAccessPoint != other.awsEfsAccessPoint) return false
        if (awsEksCluster != other.awsEksCluster) return false
        if (awsElasticBeanstalkEnvironment != other.awsElasticBeanstalkEnvironment) return false
        if (awsElasticsearchDomain != other.awsElasticsearchDomain) return false
        if (awsElbLoadBalancer != other.awsElbLoadBalancer) return false
        if (awsElbv2LoadBalancer != other.awsElbv2LoadBalancer) return false
        if (awsIamAccessKey != other.awsIamAccessKey) return false
        if (awsIamGroup != other.awsIamGroup) return false
        if (awsIamPolicy != other.awsIamPolicy) return false
        if (awsIamRole != other.awsIamRole) return false
        if (awsIamUser != other.awsIamUser) return false
        if (awsKinesisStream != other.awsKinesisStream) return false
        if (awsKmsKey != other.awsKmsKey) return false
        if (awsLambdaFunction != other.awsLambdaFunction) return false
        if (awsLambdaLayerVersion != other.awsLambdaLayerVersion) return false
        if (awsNetworkFirewallFirewall != other.awsNetworkFirewallFirewall) return false
        if (awsNetworkFirewallFirewallPolicy != other.awsNetworkFirewallFirewallPolicy) return false
        if (awsNetworkFirewallRuleGroup != other.awsNetworkFirewallRuleGroup) return false
        if (awsOpenSearchServiceDomain != other.awsOpenSearchServiceDomain) return false
        if (awsRdsDbCluster != other.awsRdsDbCluster) return false
        if (awsRdsDbClusterSnapshot != other.awsRdsDbClusterSnapshot) return false
        if (awsRdsDbInstance != other.awsRdsDbInstance) return false
        if (awsRdsDbSecurityGroup != other.awsRdsDbSecurityGroup) return false
        if (awsRdsDbSnapshot != other.awsRdsDbSnapshot) return false
        if (awsRdsEventSubscription != other.awsRdsEventSubscription) return false
        if (awsRedshiftCluster != other.awsRedshiftCluster) return false
        if (awsS3AccountPublicAccessBlock != other.awsS3AccountPublicAccessBlock) return false
        if (awsS3Bucket != other.awsS3Bucket) return false
        if (awsS3Object != other.awsS3Object) return false
        if (awsSageMakerNotebookInstance != other.awsSageMakerNotebookInstance) return false
        if (awsSecretsManagerSecret != other.awsSecretsManagerSecret) return false
        if (awsSnsTopic != other.awsSnsTopic) return false
        if (awsSqsQueue != other.awsSqsQueue) return false
        if (awsSsmPatchCompliance != other.awsSsmPatchCompliance) return false
        if (awsWafRateBasedRule != other.awsWafRateBasedRule) return false
        if (awsWafRegionalRateBasedRule != other.awsWafRegionalRateBasedRule) return false
        if (awsWafRegionalRule != other.awsWafRegionalRule) return false
        if (awsWafRegionalRuleGroup != other.awsWafRegionalRuleGroup) return false
        if (awsWafRegionalWebAcl != other.awsWafRegionalWebAcl) return false
        if (awsWafRule != other.awsWafRule) return false
        if (awsWafRuleGroup != other.awsWafRuleGroup) return false
        if (awsWafWebAcl != other.awsWafWebAcl) return false
        if (awsWafv2RuleGroup != other.awsWafv2RuleGroup) return false
        if (awsWafv2WebAcl != other.awsWafv2WebAcl) return false
        if (awsXrayEncryptionConfig != other.awsXrayEncryptionConfig) return false
        if (container != other.container) return false
        if (other != other.other) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.ResourceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides information about a REST API in version 1 of Amazon API Gateway.
         */
        public var awsApiGatewayRestApi: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails? = null
        /**
         * Provides information about a version 1 Amazon API Gateway stage.
         */
        public var awsApiGatewayStage: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails? = null
        /**
         * Provides information about a version 2 API in Amazon API Gateway.
         */
        public var awsApiGatewayV2Api: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails? = null
        /**
         * Provides information about a version 2 stage for Amazon API Gateway.
         */
        public var awsApiGatewayV2Stage: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails? = null
        /**
         * Details for an autoscaling group.
         */
        public var awsAutoScalingAutoScalingGroup: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails? = null
        /**
         * Provides details about a launch configuration.
         */
        public var awsAutoScalingLaunchConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails? = null
        /**
         * Provides details about an Backup backup plan.
         */
        public var awsBackupBackupPlan: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanDetails? = null
        /**
         * Provides details about an Backup backup vault.
         */
        public var awsBackupBackupVault: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails? = null
        /**
         * Provides details about an Backup backup, or recovery point.
         */
        public var awsBackupRecoveryPoint: aws.sdk.kotlin.services.securityhub.model.AwsBackupRecoveryPointDetails? = null
        /**
         * Provides details about an Certificate Manager certificate.
         */
        public var awsCertificateManagerCertificate: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails? = null
        /**
         * Details about an CloudFormation stack. A stack is a collection of Amazon Web Services resources that you can manage as a single unit.
         */
        public var awsCloudFormationStack: aws.sdk.kotlin.services.securityhub.model.AwsCloudFormationStackDetails? = null
        /**
         * Details about a CloudFront distribution.
         */
        public var awsCloudFrontDistribution: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionDetails? = null
        /**
         * Provides details about a CloudTrail trail.
         */
        public var awsCloudTrailTrail: aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails? = null
        /**
         * Details about an Amazon CloudWatch alarm. An alarm allows you to monitor and receive alerts about your Amazon Web Services resources and applications across multiple Regions.
         */
        public var awsCloudWatchAlarm: aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails? = null
        /**
         * Details for an CodeBuild project.
         */
        public var awsCodeBuildProject: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails? = null
        /**
         * Details about a DynamoDB table.
         */
        public var awsDynamoDbTable: aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableDetails? = null
        /**
         * Details about an Elastic IP address.
         */
        public var awsEc2Eip: aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails? = null
        /**
         * Details about an EC2 instance related to a finding.
         */
        public var awsEc2Instance: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails? = null
        /**
         * Specifies the properties for creating an Amazon Elastic Compute Cloud (Amazon EC2) launch template.
         */
        public var awsEc2LaunchTemplate: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDetails? = null
        /**
         * Details about an EC2 network access control list (ACL).
         */
        public var awsEc2NetworkAcl: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails? = null
        /**
         * Details for an EC2 network interface.
         */
        public var awsEc2NetworkInterface: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceDetails? = null
        /**
         * Provides details about a route table. A route table contains a set of rules, called routes, that determine where to direct network traffic from your subnet or gateway.
         */
        public var awsEc2RouteTable: aws.sdk.kotlin.services.securityhub.model.AwsEc2RouteTableDetails? = null
        /**
         * Details for an EC2 security group.
         */
        public var awsEc2SecurityGroup: aws.sdk.kotlin.services.securityhub.model.AwsEc2SecurityGroupDetails? = null
        /**
         * Details about a subnet in Amazon EC2.
         */
        public var awsEc2Subnet: aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails? = null
        /**
         * Details about an Amazon EC2 transit gateway that interconnects your virtual private clouds (VPC) and on-premises networks.
         */
        public var awsEc2TransitGateway: aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails? = null
        /**
         * Details for an Amazon EC2 volume.
         */
        public var awsEc2Volume: aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails? = null
        /**
         * Details for an Amazon EC2 VPC.
         */
        public var awsEc2Vpc: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcDetails? = null
        /**
         * Details about the service configuration for a VPC endpoint service.
         */
        public var awsEc2VpcEndpointService: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails? = null
        /**
         * Details about an Amazon EC2 VPC peering connection. A VPC peering connection is a networking connection between two VPCs that enables you to route traffic between them privately.
         */
        public var awsEc2VpcPeeringConnection: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails? = null
        /**
         * Details about an Amazon EC2 VPN connection.
         */
        public var awsEc2VpnConnection: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails? = null
        /**
         * Information about an Amazon ECR image.
         */
        public var awsEcrContainerImage: aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails? = null
        /**
         * Information about an Amazon Elastic Container Registry repository.
         */
        public var awsEcrRepository: aws.sdk.kotlin.services.securityhub.model.AwsEcrRepositoryDetails? = null
        /**
         * Details about an Amazon ECS cluster.
         */
        public var awsEcsCluster: aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails? = null
        /**
         * Provides information about a Docker container that's part of a task.
         */
        public var awsEcsContainer: aws.sdk.kotlin.services.securityhub.model.AwsEcsContainerDetails? = null
        /**
         * Details about a service within an ECS cluster.
         */
        public var awsEcsService: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails? = null
        /**
         * Details about a task in a cluster.
         */
        public var awsEcsTask: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails? = null
        /**
         * Details about a task definition. A task definition describes the container and volume definitions of an Amazon Elastic Container Service task.
         */
        public var awsEcsTaskDefinition: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails? = null
        /**
         * Details about an Amazon EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point.
         */
        public var awsEfsAccessPoint: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails? = null
        /**
         * Details about an Amazon EKS cluster.
         */
        public var awsEksCluster: aws.sdk.kotlin.services.securityhub.model.AwsEksClusterDetails? = null
        /**
         * Details about an Elastic Beanstalk environment.
         */
        public var awsElasticBeanstalkEnvironment: aws.sdk.kotlin.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails? = null
        /**
         * Details for an Elasticsearch domain.
         */
        public var awsElasticsearchDomain: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails? = null
        /**
         * Contains details about a Classic Load Balancer.
         */
        public var awsElbLoadBalancer: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails? = null
        /**
         * Details about a load balancer.
         */
        public var awsElbv2LoadBalancer: aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails? = null
        /**
         * Details about an IAM access key related to a finding.
         */
        public var awsIamAccessKey: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails? = null
        /**
         * Contains details about an IAM group.
         */
        public var awsIamGroup: aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails? = null
        /**
         * Details about an IAM permissions policy.
         */
        public var awsIamPolicy: aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails? = null
        /**
         * Details about an IAM role.
         */
        public var awsIamRole: aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails? = null
        /**
         * Details about an IAM user.
         */
        public var awsIamUser: aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails? = null
        /**
         * Details about an Amazon Kinesis data stream.
         */
        public var awsKinesisStream: aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails? = null
        /**
         * Details about an KMS key.
         */
        public var awsKmsKey: aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails? = null
        /**
         * Details about a Lambda function.
         */
        public var awsLambdaFunction: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails? = null
        /**
         * Details for a Lambda layer version.
         */
        public var awsLambdaLayerVersion: aws.sdk.kotlin.services.securityhub.model.AwsLambdaLayerVersionDetails? = null
        /**
         * Details about an Network Firewall firewall.
         */
        public var awsNetworkFirewallFirewall: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallDetails? = null
        /**
         * Details about an Network Firewall firewall policy.
         */
        public var awsNetworkFirewallFirewallPolicy: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails? = null
        /**
         * Details about an Network Firewall rule group.
         */
        public var awsNetworkFirewallRuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails? = null
        /**
         * Details about an Amazon OpenSearch Service domain.
         */
        public var awsOpenSearchServiceDomain: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails? = null
        /**
         * Details about an Amazon RDS database cluster.
         */
        public var awsRdsDbCluster: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails? = null
        /**
         * Details about an Amazon RDS database cluster snapshot.
         */
        public var awsRdsDbClusterSnapshot: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails? = null
        /**
         * Details about an Amazon RDS database instance.
         */
        public var awsRdsDbInstance: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails? = null
        /**
         * Details about an Amazon RDS DB security group.
         */
        public var awsRdsDbSecurityGroup: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSecurityGroupDetails? = null
        /**
         * Details about an Amazon RDS database snapshot.
         */
        public var awsRdsDbSnapshot: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails? = null
        /**
         * Details about an RDS event notification subscription.
         */
        public var awsRdsEventSubscription: aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails? = null
        /**
         * Contains details about an Amazon Redshift cluster.
         */
        public var awsRedshiftCluster: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails? = null
        /**
         * Details about the Amazon S3 Public Access Block configuration for an account.
         */
        public var awsS3AccountPublicAccessBlock: aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails? = null
        /**
         * Details about an S3 bucket related to a finding.
         */
        public var awsS3Bucket: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketDetails? = null
        /**
         * Details about an S3 object related to a finding.
         */
        public var awsS3Object: aws.sdk.kotlin.services.securityhub.model.AwsS3ObjectDetails? = null
        /**
         * Provides details about an Amazon SageMaker notebook instance.
         */
        public var awsSageMakerNotebookInstance: aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails? = null
        /**
         * Details about a Secrets Manager secret.
         */
        public var awsSecretsManagerSecret: aws.sdk.kotlin.services.securityhub.model.AwsSecretsManagerSecretDetails? = null
        /**
         * Details about an SNS topic.
         */
        public var awsSnsTopic: aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails? = null
        /**
         * Details about an SQS queue.
         */
        public var awsSqsQueue: aws.sdk.kotlin.services.securityhub.model.AwsSqsQueueDetails? = null
        /**
         * Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the instance.
         */
        public var awsSsmPatchCompliance: aws.sdk.kotlin.services.securityhub.model.AwsSsmPatchComplianceDetails? = null
        /**
         * Details about a rate-based rule for global resources.
         */
        public var awsWafRateBasedRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails? = null
        /**
         * Details about a rate-based rule for Regional resources.
         */
        public var awsWafRegionalRateBasedRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails? = null
        /**
         * Details about an WAF rule for Regional resources.
         */
        public var awsWafRegionalRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleDetails? = null
        /**
         * Details about an WAF rule group for Regional resources.
         */
        public var awsWafRegionalRuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleGroupDetails? = null
        /**
         * Details about an WAF web access control list (web ACL) for Regional resources.
         */
        public var awsWafRegionalWebAcl: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails? = null
        /**
         * Details about an WAF rule for global resources.
         */
        public var awsWafRule: aws.sdk.kotlin.services.securityhub.model.AwsWafRuleDetails? = null
        /**
         * Details about an WAF rule group for global resources.
         */
        public var awsWafRuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsWafRuleGroupDetails? = null
        /**
         * Details for an WAF web ACL.
         */
        public var awsWafWebAcl: aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclDetails? = null
        /**
         * Details about an WAFv2 rule group.
         */
        public var awsWafv2RuleGroup: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails? = null
        /**
         * Details about an WAFv2 web Access Control List (ACL).
         */
        public var awsWafv2WebAcl: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails? = null
        /**
         * Information about the encryption configuration for X-Ray.
         */
        public var awsXrayEncryptionConfig: aws.sdk.kotlin.services.securityhub.model.AwsXrayEncryptionConfigDetails? = null
        /**
         * Details about a container resource related to a finding.
         */
        public var container: aws.sdk.kotlin.services.securityhub.model.ContainerDetails? = null
        /**
         * Details about a resource that are not available in a type-specific details object. Use the `Other` object in the following cases.
         * + The type-specific object does not contain all of the fields that you want to populate. In this case, first use the type-specific object to populate those fields. Use the `Other` object to populate the fields that are missing from the type-specific object.
         * + The resource type does not have a corresponding object. This includes resources for which the type is `Other`.
         */
        public var other: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.ResourceDetails) : this() {
            this.awsApiGatewayRestApi = x.awsApiGatewayRestApi
            this.awsApiGatewayStage = x.awsApiGatewayStage
            this.awsApiGatewayV2Api = x.awsApiGatewayV2Api
            this.awsApiGatewayV2Stage = x.awsApiGatewayV2Stage
            this.awsAutoScalingAutoScalingGroup = x.awsAutoScalingAutoScalingGroup
            this.awsAutoScalingLaunchConfiguration = x.awsAutoScalingLaunchConfiguration
            this.awsBackupBackupPlan = x.awsBackupBackupPlan
            this.awsBackupBackupVault = x.awsBackupBackupVault
            this.awsBackupRecoveryPoint = x.awsBackupRecoveryPoint
            this.awsCertificateManagerCertificate = x.awsCertificateManagerCertificate
            this.awsCloudFormationStack = x.awsCloudFormationStack
            this.awsCloudFrontDistribution = x.awsCloudFrontDistribution
            this.awsCloudTrailTrail = x.awsCloudTrailTrail
            this.awsCloudWatchAlarm = x.awsCloudWatchAlarm
            this.awsCodeBuildProject = x.awsCodeBuildProject
            this.awsDynamoDbTable = x.awsDynamoDbTable
            this.awsEc2Eip = x.awsEc2Eip
            this.awsEc2Instance = x.awsEc2Instance
            this.awsEc2LaunchTemplate = x.awsEc2LaunchTemplate
            this.awsEc2NetworkAcl = x.awsEc2NetworkAcl
            this.awsEc2NetworkInterface = x.awsEc2NetworkInterface
            this.awsEc2RouteTable = x.awsEc2RouteTable
            this.awsEc2SecurityGroup = x.awsEc2SecurityGroup
            this.awsEc2Subnet = x.awsEc2Subnet
            this.awsEc2TransitGateway = x.awsEc2TransitGateway
            this.awsEc2Volume = x.awsEc2Volume
            this.awsEc2Vpc = x.awsEc2Vpc
            this.awsEc2VpcEndpointService = x.awsEc2VpcEndpointService
            this.awsEc2VpcPeeringConnection = x.awsEc2VpcPeeringConnection
            this.awsEc2VpnConnection = x.awsEc2VpnConnection
            this.awsEcrContainerImage = x.awsEcrContainerImage
            this.awsEcrRepository = x.awsEcrRepository
            this.awsEcsCluster = x.awsEcsCluster
            this.awsEcsContainer = x.awsEcsContainer
            this.awsEcsService = x.awsEcsService
            this.awsEcsTask = x.awsEcsTask
            this.awsEcsTaskDefinition = x.awsEcsTaskDefinition
            this.awsEfsAccessPoint = x.awsEfsAccessPoint
            this.awsEksCluster = x.awsEksCluster
            this.awsElasticBeanstalkEnvironment = x.awsElasticBeanstalkEnvironment
            this.awsElasticsearchDomain = x.awsElasticsearchDomain
            this.awsElbLoadBalancer = x.awsElbLoadBalancer
            this.awsElbv2LoadBalancer = x.awsElbv2LoadBalancer
            this.awsIamAccessKey = x.awsIamAccessKey
            this.awsIamGroup = x.awsIamGroup
            this.awsIamPolicy = x.awsIamPolicy
            this.awsIamRole = x.awsIamRole
            this.awsIamUser = x.awsIamUser
            this.awsKinesisStream = x.awsKinesisStream
            this.awsKmsKey = x.awsKmsKey
            this.awsLambdaFunction = x.awsLambdaFunction
            this.awsLambdaLayerVersion = x.awsLambdaLayerVersion
            this.awsNetworkFirewallFirewall = x.awsNetworkFirewallFirewall
            this.awsNetworkFirewallFirewallPolicy = x.awsNetworkFirewallFirewallPolicy
            this.awsNetworkFirewallRuleGroup = x.awsNetworkFirewallRuleGroup
            this.awsOpenSearchServiceDomain = x.awsOpenSearchServiceDomain
            this.awsRdsDbCluster = x.awsRdsDbCluster
            this.awsRdsDbClusterSnapshot = x.awsRdsDbClusterSnapshot
            this.awsRdsDbInstance = x.awsRdsDbInstance
            this.awsRdsDbSecurityGroup = x.awsRdsDbSecurityGroup
            this.awsRdsDbSnapshot = x.awsRdsDbSnapshot
            this.awsRdsEventSubscription = x.awsRdsEventSubscription
            this.awsRedshiftCluster = x.awsRedshiftCluster
            this.awsS3AccountPublicAccessBlock = x.awsS3AccountPublicAccessBlock
            this.awsS3Bucket = x.awsS3Bucket
            this.awsS3Object = x.awsS3Object
            this.awsSageMakerNotebookInstance = x.awsSageMakerNotebookInstance
            this.awsSecretsManagerSecret = x.awsSecretsManagerSecret
            this.awsSnsTopic = x.awsSnsTopic
            this.awsSqsQueue = x.awsSqsQueue
            this.awsSsmPatchCompliance = x.awsSsmPatchCompliance
            this.awsWafRateBasedRule = x.awsWafRateBasedRule
            this.awsWafRegionalRateBasedRule = x.awsWafRegionalRateBasedRule
            this.awsWafRegionalRule = x.awsWafRegionalRule
            this.awsWafRegionalRuleGroup = x.awsWafRegionalRuleGroup
            this.awsWafRegionalWebAcl = x.awsWafRegionalWebAcl
            this.awsWafRule = x.awsWafRule
            this.awsWafRuleGroup = x.awsWafRuleGroup
            this.awsWafWebAcl = x.awsWafWebAcl
            this.awsWafv2RuleGroup = x.awsWafv2RuleGroup
            this.awsWafv2WebAcl = x.awsWafv2WebAcl
            this.awsXrayEncryptionConfig = x.awsXrayEncryptionConfig
            this.container = x.container
            this.other = x.other
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.ResourceDetails = ResourceDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails] inside the given [block]
         */
        public fun awsApiGatewayRestApi(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails.Builder.() -> kotlin.Unit) {
            this.awsApiGatewayRestApi = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayRestApiDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails] inside the given [block]
         */
        public fun awsApiGatewayStage(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails.Builder.() -> kotlin.Unit) {
            this.awsApiGatewayStage = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayStageDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails] inside the given [block]
         */
        public fun awsApiGatewayV2Api(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails.Builder.() -> kotlin.Unit) {
            this.awsApiGatewayV2Api = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2ApiDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails] inside the given [block]
         */
        public fun awsApiGatewayV2Stage(block: aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails.Builder.() -> kotlin.Unit) {
            this.awsApiGatewayV2Stage = aws.sdk.kotlin.services.securityhub.model.AwsApiGatewayV2StageDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails] inside the given [block]
         */
        public fun awsAutoScalingAutoScalingGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsAutoScalingAutoScalingGroup = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails] inside the given [block]
         */
        public fun awsAutoScalingLaunchConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.awsAutoScalingLaunchConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsAutoScalingLaunchConfigurationDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanDetails] inside the given [block]
         */
        public fun awsBackupBackupPlan(block: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanDetails.Builder.() -> kotlin.Unit) {
            this.awsBackupBackupPlan = aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupPlanDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails] inside the given [block]
         */
        public fun awsBackupBackupVault(block: aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails.Builder.() -> kotlin.Unit) {
            this.awsBackupBackupVault = aws.sdk.kotlin.services.securityhub.model.AwsBackupBackupVaultDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsBackupRecoveryPointDetails] inside the given [block]
         */
        public fun awsBackupRecoveryPoint(block: aws.sdk.kotlin.services.securityhub.model.AwsBackupRecoveryPointDetails.Builder.() -> kotlin.Unit) {
            this.awsBackupRecoveryPoint = aws.sdk.kotlin.services.securityhub.model.AwsBackupRecoveryPointDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails] inside the given [block]
         */
        public fun awsCertificateManagerCertificate(block: aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails.Builder.() -> kotlin.Unit) {
            this.awsCertificateManagerCertificate = aws.sdk.kotlin.services.securityhub.model.AwsCertificateManagerCertificateDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCloudFormationStackDetails] inside the given [block]
         */
        public fun awsCloudFormationStack(block: aws.sdk.kotlin.services.securityhub.model.AwsCloudFormationStackDetails.Builder.() -> kotlin.Unit) {
            this.awsCloudFormationStack = aws.sdk.kotlin.services.securityhub.model.AwsCloudFormationStackDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionDetails] inside the given [block]
         */
        public fun awsCloudFrontDistribution(block: aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionDetails.Builder.() -> kotlin.Unit) {
            this.awsCloudFrontDistribution = aws.sdk.kotlin.services.securityhub.model.AwsCloudFrontDistributionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails] inside the given [block]
         */
        public fun awsCloudTrailTrail(block: aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails.Builder.() -> kotlin.Unit) {
            this.awsCloudTrailTrail = aws.sdk.kotlin.services.securityhub.model.AwsCloudTrailTrailDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails] inside the given [block]
         */
        public fun awsCloudWatchAlarm(block: aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails.Builder.() -> kotlin.Unit) {
            this.awsCloudWatchAlarm = aws.sdk.kotlin.services.securityhub.model.AwsCloudWatchAlarmDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails] inside the given [block]
         */
        public fun awsCodeBuildProject(block: aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails.Builder.() -> kotlin.Unit) {
            this.awsCodeBuildProject = aws.sdk.kotlin.services.securityhub.model.AwsCodeBuildProjectDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableDetails] inside the given [block]
         */
        public fun awsDynamoDbTable(block: aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableDetails.Builder.() -> kotlin.Unit) {
            this.awsDynamoDbTable = aws.sdk.kotlin.services.securityhub.model.AwsDynamoDbTableDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails] inside the given [block]
         */
        public fun awsEc2Eip(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2Eip = aws.sdk.kotlin.services.securityhub.model.AwsEc2EipDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails] inside the given [block]
         */
        public fun awsEc2Instance(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2Instance = aws.sdk.kotlin.services.securityhub.model.AwsEc2InstanceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDetails] inside the given [block]
         */
        public fun awsEc2LaunchTemplate(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2LaunchTemplate = aws.sdk.kotlin.services.securityhub.model.AwsEc2LaunchTemplateDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails] inside the given [block]
         */
        public fun awsEc2NetworkAcl(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2NetworkAcl = aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkAclDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceDetails] inside the given [block]
         */
        public fun awsEc2NetworkInterface(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2NetworkInterface = aws.sdk.kotlin.services.securityhub.model.AwsEc2NetworkInterfaceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2RouteTableDetails] inside the given [block]
         */
        public fun awsEc2RouteTable(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2RouteTableDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2RouteTable = aws.sdk.kotlin.services.securityhub.model.AwsEc2RouteTableDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2SecurityGroupDetails] inside the given [block]
         */
        public fun awsEc2SecurityGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2SecurityGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2SecurityGroup = aws.sdk.kotlin.services.securityhub.model.AwsEc2SecurityGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails] inside the given [block]
         */
        public fun awsEc2Subnet(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2Subnet = aws.sdk.kotlin.services.securityhub.model.AwsEc2SubnetDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails] inside the given [block]
         */
        public fun awsEc2TransitGateway(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2TransitGateway = aws.sdk.kotlin.services.securityhub.model.AwsEc2TransitGatewayDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails] inside the given [block]
         */
        public fun awsEc2Volume(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2Volume = aws.sdk.kotlin.services.securityhub.model.AwsEc2VolumeDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcDetails] inside the given [block]
         */
        public fun awsEc2Vpc(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2Vpc = aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails] inside the given [block]
         */
        public fun awsEc2VpcEndpointService(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2VpcEndpointService = aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcEndpointServiceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails] inside the given [block]
         */
        public fun awsEc2VpcPeeringConnection(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2VpcPeeringConnection = aws.sdk.kotlin.services.securityhub.model.AwsEc2VpcPeeringConnectionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails] inside the given [block]
         */
        public fun awsEc2VpnConnection(block: aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails.Builder.() -> kotlin.Unit) {
            this.awsEc2VpnConnection = aws.sdk.kotlin.services.securityhub.model.AwsEc2VpnConnectionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails] inside the given [block]
         */
        public fun awsEcrContainerImage(block: aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails.Builder.() -> kotlin.Unit) {
            this.awsEcrContainerImage = aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcrRepositoryDetails] inside the given [block]
         */
        public fun awsEcrRepository(block: aws.sdk.kotlin.services.securityhub.model.AwsEcrRepositoryDetails.Builder.() -> kotlin.Unit) {
            this.awsEcrRepository = aws.sdk.kotlin.services.securityhub.model.AwsEcrRepositoryDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails] inside the given [block]
         */
        public fun awsEcsCluster(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails.Builder.() -> kotlin.Unit) {
            this.awsEcsCluster = aws.sdk.kotlin.services.securityhub.model.AwsEcsClusterDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsContainerDetails] inside the given [block]
         */
        public fun awsEcsContainer(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsContainerDetails.Builder.() -> kotlin.Unit) {
            this.awsEcsContainer = aws.sdk.kotlin.services.securityhub.model.AwsEcsContainerDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails] inside the given [block]
         */
        public fun awsEcsService(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails.Builder.() -> kotlin.Unit) {
            this.awsEcsService = aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails] inside the given [block]
         */
        public fun awsEcsTask(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails.Builder.() -> kotlin.Unit) {
            this.awsEcsTask = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails] inside the given [block]
         */
        public fun awsEcsTaskDefinition(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails.Builder.() -> kotlin.Unit) {
            this.awsEcsTaskDefinition = aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDefinitionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails] inside the given [block]
         */
        public fun awsEfsAccessPoint(block: aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails.Builder.() -> kotlin.Unit) {
            this.awsEfsAccessPoint = aws.sdk.kotlin.services.securityhub.model.AwsEfsAccessPointDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEksClusterDetails] inside the given [block]
         */
        public fun awsEksCluster(block: aws.sdk.kotlin.services.securityhub.model.AwsEksClusterDetails.Builder.() -> kotlin.Unit) {
            this.awsEksCluster = aws.sdk.kotlin.services.securityhub.model.AwsEksClusterDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails] inside the given [block]
         */
        public fun awsElasticBeanstalkEnvironment(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.Builder.() -> kotlin.Unit) {
            this.awsElasticBeanstalkEnvironment = aws.sdk.kotlin.services.securityhub.model.AwsElasticBeanstalkEnvironmentDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails] inside the given [block]
         */
        public fun awsElasticsearchDomain(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails.Builder.() -> kotlin.Unit) {
            this.awsElasticsearchDomain = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails] inside the given [block]
         */
        public fun awsElbLoadBalancer(block: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails.Builder.() -> kotlin.Unit) {
            this.awsElbLoadBalancer = aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails] inside the given [block]
         */
        public fun awsElbv2LoadBalancer(block: aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails.Builder.() -> kotlin.Unit) {
            this.awsElbv2LoadBalancer = aws.sdk.kotlin.services.securityhub.model.AwsElbv2LoadBalancerDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails] inside the given [block]
         */
        public fun awsIamAccessKey(block: aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails.Builder.() -> kotlin.Unit) {
            this.awsIamAccessKey = aws.sdk.kotlin.services.securityhub.model.AwsIamAccessKeyDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails] inside the given [block]
         */
        public fun awsIamGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsIamGroup = aws.sdk.kotlin.services.securityhub.model.AwsIamGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails] inside the given [block]
         */
        public fun awsIamPolicy(block: aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails.Builder.() -> kotlin.Unit) {
            this.awsIamPolicy = aws.sdk.kotlin.services.securityhub.model.AwsIamPolicyDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails] inside the given [block]
         */
        public fun awsIamRole(block: aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails.Builder.() -> kotlin.Unit) {
            this.awsIamRole = aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails] inside the given [block]
         */
        public fun awsIamUser(block: aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails.Builder.() -> kotlin.Unit) {
            this.awsIamUser = aws.sdk.kotlin.services.securityhub.model.AwsIamUserDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails] inside the given [block]
         */
        public fun awsKinesisStream(block: aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails.Builder.() -> kotlin.Unit) {
            this.awsKinesisStream = aws.sdk.kotlin.services.securityhub.model.AwsKinesisStreamDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails] inside the given [block]
         */
        public fun awsKmsKey(block: aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails.Builder.() -> kotlin.Unit) {
            this.awsKmsKey = aws.sdk.kotlin.services.securityhub.model.AwsKmsKeyDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails] inside the given [block]
         */
        public fun awsLambdaFunction(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails.Builder.() -> kotlin.Unit) {
            this.awsLambdaFunction = aws.sdk.kotlin.services.securityhub.model.AwsLambdaFunctionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsLambdaLayerVersionDetails] inside the given [block]
         */
        public fun awsLambdaLayerVersion(block: aws.sdk.kotlin.services.securityhub.model.AwsLambdaLayerVersionDetails.Builder.() -> kotlin.Unit) {
            this.awsLambdaLayerVersion = aws.sdk.kotlin.services.securityhub.model.AwsLambdaLayerVersionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallDetails] inside the given [block]
         */
        public fun awsNetworkFirewallFirewall(block: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallDetails.Builder.() -> kotlin.Unit) {
            this.awsNetworkFirewallFirewall = aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails] inside the given [block]
         */
        public fun awsNetworkFirewallFirewallPolicy(block: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.Builder.() -> kotlin.Unit) {
            this.awsNetworkFirewallFirewallPolicy = aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails] inside the given [block]
         */
        public fun awsNetworkFirewallRuleGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsNetworkFirewallRuleGroup = aws.sdk.kotlin.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails] inside the given [block]
         */
        public fun awsOpenSearchServiceDomain(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails.Builder.() -> kotlin.Unit) {
            this.awsOpenSearchServiceDomain = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails] inside the given [block]
         */
        public fun awsRdsDbCluster(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails.Builder.() -> kotlin.Unit) {
            this.awsRdsDbCluster = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails] inside the given [block]
         */
        public fun awsRdsDbClusterSnapshot(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails.Builder.() -> kotlin.Unit) {
            this.awsRdsDbClusterSnapshot = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbClusterSnapshotDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails] inside the given [block]
         */
        public fun awsRdsDbInstance(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails.Builder.() -> kotlin.Unit) {
            this.awsRdsDbInstance = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbInstanceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSecurityGroupDetails] inside the given [block]
         */
        public fun awsRdsDbSecurityGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSecurityGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsRdsDbSecurityGroup = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSecurityGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails] inside the given [block]
         */
        public fun awsRdsDbSnapshot(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails.Builder.() -> kotlin.Unit) {
            this.awsRdsDbSnapshot = aws.sdk.kotlin.services.securityhub.model.AwsRdsDbSnapshotDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails] inside the given [block]
         */
        public fun awsRdsEventSubscription(block: aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails.Builder.() -> kotlin.Unit) {
            this.awsRdsEventSubscription = aws.sdk.kotlin.services.securityhub.model.AwsRdsEventSubscriptionDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails] inside the given [block]
         */
        public fun awsRedshiftCluster(block: aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails.Builder.() -> kotlin.Unit) {
            this.awsRedshiftCluster = aws.sdk.kotlin.services.securityhub.model.AwsRedshiftClusterDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails] inside the given [block]
         */
        public fun awsS3AccountPublicAccessBlock(block: aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails.Builder.() -> kotlin.Unit) {
            this.awsS3AccountPublicAccessBlock = aws.sdk.kotlin.services.securityhub.model.AwsS3AccountPublicAccessBlockDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsS3BucketDetails] inside the given [block]
         */
        public fun awsS3Bucket(block: aws.sdk.kotlin.services.securityhub.model.AwsS3BucketDetails.Builder.() -> kotlin.Unit) {
            this.awsS3Bucket = aws.sdk.kotlin.services.securityhub.model.AwsS3BucketDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsS3ObjectDetails] inside the given [block]
         */
        public fun awsS3Object(block: aws.sdk.kotlin.services.securityhub.model.AwsS3ObjectDetails.Builder.() -> kotlin.Unit) {
            this.awsS3Object = aws.sdk.kotlin.services.securityhub.model.AwsS3ObjectDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails] inside the given [block]
         */
        public fun awsSageMakerNotebookInstance(block: aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails.Builder.() -> kotlin.Unit) {
            this.awsSageMakerNotebookInstance = aws.sdk.kotlin.services.securityhub.model.AwsSageMakerNotebookInstanceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSecretsManagerSecretDetails] inside the given [block]
         */
        public fun awsSecretsManagerSecret(block: aws.sdk.kotlin.services.securityhub.model.AwsSecretsManagerSecretDetails.Builder.() -> kotlin.Unit) {
            this.awsSecretsManagerSecret = aws.sdk.kotlin.services.securityhub.model.AwsSecretsManagerSecretDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails] inside the given [block]
         */
        public fun awsSnsTopic(block: aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails.Builder.() -> kotlin.Unit) {
            this.awsSnsTopic = aws.sdk.kotlin.services.securityhub.model.AwsSnsTopicDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSqsQueueDetails] inside the given [block]
         */
        public fun awsSqsQueue(block: aws.sdk.kotlin.services.securityhub.model.AwsSqsQueueDetails.Builder.() -> kotlin.Unit) {
            this.awsSqsQueue = aws.sdk.kotlin.services.securityhub.model.AwsSqsQueueDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsSsmPatchComplianceDetails] inside the given [block]
         */
        public fun awsSsmPatchCompliance(block: aws.sdk.kotlin.services.securityhub.model.AwsSsmPatchComplianceDetails.Builder.() -> kotlin.Unit) {
            this.awsSsmPatchCompliance = aws.sdk.kotlin.services.securityhub.model.AwsSsmPatchComplianceDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails] inside the given [block]
         */
        public fun awsWafRateBasedRule(block: aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails.Builder.() -> kotlin.Unit) {
            this.awsWafRateBasedRule = aws.sdk.kotlin.services.securityhub.model.AwsWafRateBasedRuleDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails] inside the given [block]
         */
        public fun awsWafRegionalRateBasedRule(block: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails.Builder.() -> kotlin.Unit) {
            this.awsWafRegionalRateBasedRule = aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRateBasedRuleDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleDetails] inside the given [block]
         */
        public fun awsWafRegionalRule(block: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleDetails.Builder.() -> kotlin.Unit) {
            this.awsWafRegionalRule = aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleGroupDetails] inside the given [block]
         */
        public fun awsWafRegionalRuleGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsWafRegionalRuleGroup = aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalRuleGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails] inside the given [block]
         */
        public fun awsWafRegionalWebAcl(block: aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails.Builder.() -> kotlin.Unit) {
            this.awsWafRegionalWebAcl = aws.sdk.kotlin.services.securityhub.model.AwsWafRegionalWebAclDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafRuleDetails] inside the given [block]
         */
        public fun awsWafRule(block: aws.sdk.kotlin.services.securityhub.model.AwsWafRuleDetails.Builder.() -> kotlin.Unit) {
            this.awsWafRule = aws.sdk.kotlin.services.securityhub.model.AwsWafRuleDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafRuleGroupDetails] inside the given [block]
         */
        public fun awsWafRuleGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsWafRuleGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsWafRuleGroup = aws.sdk.kotlin.services.securityhub.model.AwsWafRuleGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclDetails] inside the given [block]
         */
        public fun awsWafWebAcl(block: aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclDetails.Builder.() -> kotlin.Unit) {
            this.awsWafWebAcl = aws.sdk.kotlin.services.securityhub.model.AwsWafWebAclDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails] inside the given [block]
         */
        public fun awsWafv2RuleGroup(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails.Builder.() -> kotlin.Unit) {
            this.awsWafv2RuleGroup = aws.sdk.kotlin.services.securityhub.model.AwsWafv2RuleGroupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails] inside the given [block]
         */
        public fun awsWafv2WebAcl(block: aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails.Builder.() -> kotlin.Unit) {
            this.awsWafv2WebAcl = aws.sdk.kotlin.services.securityhub.model.AwsWafv2WebAclDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsXrayEncryptionConfigDetails] inside the given [block]
         */
        public fun awsXrayEncryptionConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsXrayEncryptionConfigDetails.Builder.() -> kotlin.Unit) {
            this.awsXrayEncryptionConfig = aws.sdk.kotlin.services.securityhub.model.AwsXrayEncryptionConfigDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.ContainerDetails] inside the given [block]
         */
        public fun container(block: aws.sdk.kotlin.services.securityhub.model.ContainerDetails.Builder.() -> kotlin.Unit) {
            this.container = aws.sdk.kotlin.services.securityhub.model.ContainerDetails.invoke(block)
        }
    }
}
