// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides information about the file paths that were affected by the threat.
 */
public class FilePaths private constructor(builder: Builder) {
    /**
     * The name of the infected or suspicious file corresponding to the hash.
     */
    public val fileName: kotlin.String? = builder.fileName
    /**
     * Path to the infected or suspicious file on the resource it was detected on.
     */
    public val filePath: kotlin.String? = builder.filePath
    /**
     * The hash value for the infected or suspicious file.
     */
    public val hash: kotlin.String? = builder.hash
    /**
     * The Amazon Resource Name (ARN) of the resource on which the threat was detected.
     */
    public val resourceId: kotlin.String? = builder.resourceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.FilePaths = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FilePaths(")
        append("fileName=$fileName,")
        append("filePath=$filePath,")
        append("hash=$hash,")
        append("resourceId=$resourceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileName?.hashCode() ?: 0
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (hash?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FilePaths

        if (fileName != other.fileName) return false
        if (filePath != other.filePath) return false
        if (hash != other.hash) return false
        if (resourceId != other.resourceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.FilePaths = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the infected or suspicious file corresponding to the hash.
         */
        public var fileName: kotlin.String? = null
        /**
         * Path to the infected or suspicious file on the resource it was detected on.
         */
        public var filePath: kotlin.String? = null
        /**
         * The hash value for the infected or suspicious file.
         */
        public var hash: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the resource on which the threat was detected.
         */
        public var resourceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.FilePaths) : this() {
            this.fileName = x.fileName
            this.filePath = x.filePath
            this.hash = x.hash
            this.resourceId = x.resourceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.FilePaths = FilePaths(this)
    }
}
