// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * An occurrence of sensitive data detected in a Microsoft Excel workbook, comma-separated value (CSV) file, or tab-separated value (TSV) file.
 */
public class Cell private constructor(builder: Builder) {
    /**
     * For a Microsoft Excel workbook, provides the location of the cell, as an absolute cell reference, that contains the data. For example, Sheet2!C5 for cell C5 on Sheet2.
     */
    public val cellReference: kotlin.String? = builder.cellReference
    /**
     * The column number of the column that contains the data. For a Microsoft Excel workbook, the column number corresponds to the alphabetical column identifiers. For example, a value of 1 for Column corresponds to the A column in the workbook.
     */
    public val column: kotlin.Long = builder.column
    /**
     * The name of the column that contains the data.
     */
    public val columnName: kotlin.String? = builder.columnName
    /**
     * The row number of the row that contains the data.
     */
    public val row: kotlin.Long = builder.row

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.Cell = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cell(")
        append("cellReference=$cellReference,")
        append("column=$column,")
        append("columnName=$columnName,")
        append("row=$row")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cellReference?.hashCode() ?: 0
        result = 31 * result + (column.hashCode())
        result = 31 * result + (columnName?.hashCode() ?: 0)
        result = 31 * result + (row.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cell

        if (cellReference != other.cellReference) return false
        if (column != other.column) return false
        if (columnName != other.columnName) return false
        if (row != other.row) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.Cell = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For a Microsoft Excel workbook, provides the location of the cell, as an absolute cell reference, that contains the data. For example, Sheet2!C5 for cell C5 on Sheet2.
         */
        public var cellReference: kotlin.String? = null
        /**
         * The column number of the column that contains the data. For a Microsoft Excel workbook, the column number corresponds to the alphabetical column identifiers. For example, a value of 1 for Column corresponds to the A column in the workbook.
         */
        public var column: kotlin.Long = 0L
        /**
         * The name of the column that contains the data.
         */
        public var columnName: kotlin.String? = null
        /**
         * The row number of the row that contains the data.
         */
        public var row: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.Cell) : this() {
            this.cellReference = x.cellReference
            this.column = x.column
            this.columnName = x.columnName
            this.row = x.row
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.Cell = Cell(this)
    }
}
