// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an Amazon OpenSearch Service domain.
 */
public class AwsOpenSearchServiceDomainDetails private constructor(builder: Builder) {
    /**
     * IAM policy document that specifies the access policies for the OpenSearch Service domain.
     */
    public val accessPolicies: kotlin.String? = builder.accessPolicies
    /**
     * Specifies options for fine-grained access control.
     */
    public val advancedSecurityOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails? = builder.advancedSecurityOptions
    /**
     * The ARN of the OpenSearch Service domain.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Details about the configuration of an OpenSearch cluster.
     */
    public val clusterConfig: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails? = builder.clusterConfig
    /**
     * The domain endpoint.
     */
    public val domainEndpoint: kotlin.String? = builder.domainEndpoint
    /**
     * Additional options for the domain endpoint.
     */
    public val domainEndpointOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails? = builder.domainEndpointOptions
    /**
     * The domain endpoints. Used if the OpenSearch domain resides in a VPC.
     *
     * This is a map of key-value pairs. The key is always `vpc`. The value is the endpoint.
     */
    public val domainEndpoints: Map<String, String>? = builder.domainEndpoints
    /**
     * The name of the endpoint.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Details about the configuration for encryption at rest.
     */
    public val encryptionAtRestOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails? = builder.encryptionAtRestOptions
    /**
     * The version of the domain engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The identifier of the domain.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Configures the CloudWatch Logs to publish for the OpenSearch domain.
     */
    public val logPublishingOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails? = builder.logPublishingOptions
    /**
     * Details about the configuration for node-to-node encryption.
     */
    public val nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails? = builder.nodeToNodeEncryptionOptions
    /**
     * Information about the status of a domain relative to the latest service software.
     */
    public val serviceSoftwareOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails? = builder.serviceSoftwareOptions
    /**
     * Information that OpenSearch Service derives based on `VPCOptions` for the domain.
     */
    public val vpcOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails? = builder.vpcOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsOpenSearchServiceDomainDetails(")
        append("accessPolicies=$accessPolicies,")
        append("advancedSecurityOptions=$advancedSecurityOptions,")
        append("arn=$arn,")
        append("clusterConfig=$clusterConfig,")
        append("domainEndpoint=$domainEndpoint,")
        append("domainEndpointOptions=$domainEndpointOptions,")
        append("domainEndpoints=$domainEndpoints,")
        append("domainName=$domainName,")
        append("encryptionAtRestOptions=$encryptionAtRestOptions,")
        append("engineVersion=$engineVersion,")
        append("id=$id,")
        append("logPublishingOptions=$logPublishingOptions,")
        append("nodeToNodeEncryptionOptions=$nodeToNodeEncryptionOptions,")
        append("serviceSoftwareOptions=$serviceSoftwareOptions,")
        append("vpcOptions=$vpcOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicies?.hashCode() ?: 0
        result = 31 * result + (advancedSecurityOptions?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (clusterConfig?.hashCode() ?: 0)
        result = 31 * result + (domainEndpoint?.hashCode() ?: 0)
        result = 31 * result + (domainEndpointOptions?.hashCode() ?: 0)
        result = 31 * result + (domainEndpoints?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (encryptionAtRestOptions?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (logPublishingOptions?.hashCode() ?: 0)
        result = 31 * result + (nodeToNodeEncryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (serviceSoftwareOptions?.hashCode() ?: 0)
        result = 31 * result + (vpcOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsOpenSearchServiceDomainDetails

        if (accessPolicies != other.accessPolicies) return false
        if (advancedSecurityOptions != other.advancedSecurityOptions) return false
        if (arn != other.arn) return false
        if (clusterConfig != other.clusterConfig) return false
        if (domainEndpoint != other.domainEndpoint) return false
        if (domainEndpointOptions != other.domainEndpointOptions) return false
        if (domainEndpoints != other.domainEndpoints) return false
        if (domainName != other.domainName) return false
        if (encryptionAtRestOptions != other.encryptionAtRestOptions) return false
        if (engineVersion != other.engineVersion) return false
        if (id != other.id) return false
        if (logPublishingOptions != other.logPublishingOptions) return false
        if (nodeToNodeEncryptionOptions != other.nodeToNodeEncryptionOptions) return false
        if (serviceSoftwareOptions != other.serviceSoftwareOptions) return false
        if (vpcOptions != other.vpcOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * IAM policy document that specifies the access policies for the OpenSearch Service domain.
         */
        public var accessPolicies: kotlin.String? = null
        /**
         * Specifies options for fine-grained access control.
         */
        public var advancedSecurityOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails? = null
        /**
         * The ARN of the OpenSearch Service domain.
         */
        public var arn: kotlin.String? = null
        /**
         * Details about the configuration of an OpenSearch cluster.
         */
        public var clusterConfig: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails? = null
        /**
         * The domain endpoint.
         */
        public var domainEndpoint: kotlin.String? = null
        /**
         * Additional options for the domain endpoint.
         */
        public var domainEndpointOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails? = null
        /**
         * The domain endpoints. Used if the OpenSearch domain resides in a VPC.
         *
         * This is a map of key-value pairs. The key is always `vpc`. The value is the endpoint.
         */
        public var domainEndpoints: Map<String, String>? = null
        /**
         * The name of the endpoint.
         */
        public var domainName: kotlin.String? = null
        /**
         * Details about the configuration for encryption at rest.
         */
        public var encryptionAtRestOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails? = null
        /**
         * The version of the domain engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The identifier of the domain.
         */
        public var id: kotlin.String? = null
        /**
         * Configures the CloudWatch Logs to publish for the OpenSearch domain.
         */
        public var logPublishingOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails? = null
        /**
         * Details about the configuration for node-to-node encryption.
         */
        public var nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails? = null
        /**
         * Information about the status of a domain relative to the latest service software.
         */
        public var serviceSoftwareOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails? = null
        /**
         * Information that OpenSearch Service derives based on `VPCOptions` for the domain.
         */
        public var vpcOptions: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails) : this() {
            this.accessPolicies = x.accessPolicies
            this.advancedSecurityOptions = x.advancedSecurityOptions
            this.arn = x.arn
            this.clusterConfig = x.clusterConfig
            this.domainEndpoint = x.domainEndpoint
            this.domainEndpointOptions = x.domainEndpointOptions
            this.domainEndpoints = x.domainEndpoints
            this.domainName = x.domainName
            this.encryptionAtRestOptions = x.encryptionAtRestOptions
            this.engineVersion = x.engineVersion
            this.id = x.id
            this.logPublishingOptions = x.logPublishingOptions
            this.nodeToNodeEncryptionOptions = x.nodeToNodeEncryptionOptions
            this.serviceSoftwareOptions = x.serviceSoftwareOptions
            this.vpcOptions = x.vpcOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDetails = AwsOpenSearchServiceDomainDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails] inside the given [block]
         */
        public fun advancedSecurityOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.Builder.() -> kotlin.Unit) {
            this.advancedSecurityOptions = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainAdvancedSecurityOptionsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails] inside the given [block]
         */
        public fun clusterConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.Builder.() -> kotlin.Unit) {
            this.clusterConfig = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainClusterConfigDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails] inside the given [block]
         */
        public fun domainEndpointOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.Builder.() -> kotlin.Unit) {
            this.domainEndpointOptions = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainDomainEndpointOptionsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails] inside the given [block]
         */
        public fun encryptionAtRestOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.Builder.() -> kotlin.Unit) {
            this.encryptionAtRestOptions = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainEncryptionAtRestOptionsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails] inside the given [block]
         */
        public fun logPublishingOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder.() -> kotlin.Unit) {
            this.logPublishingOptions = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainLogPublishingOptionsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails] inside the given [block]
         */
        public fun nodeToNodeEncryptionOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.Builder.() -> kotlin.Unit) {
            this.nodeToNodeEncryptionOptions = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainNodeToNodeEncryptionOptionsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails] inside the given [block]
         */
        public fun serviceSoftwareOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.Builder.() -> kotlin.Unit) {
            this.serviceSoftwareOptions = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainServiceSoftwareOptionsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails] inside the given [block]
         */
        public fun vpcOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.Builder.() -> kotlin.Unit) {
            this.vpcOptions = aws.sdk.kotlin.services.securityhub.model.AwsOpenSearchServiceDomainVpcOptionsDetails.invoke(block)
        }
    }
}
