// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Contains information about an IAM role, including all of the role's policies.
 */
public class AwsIamRoleDetails private constructor(builder: Builder) {
    /**
     * The trust policy that grants permission to assume the role.
     */
    public val assumeRolePolicyDocument: kotlin.String? = builder.assumeRolePolicyDocument
    /**
     * The list of the managed policies that are attached to the role.
     */
    public val attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = builder.attachedManagedPolicies
    /**
     * Indicates when the role was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val createDate: kotlin.String? = builder.createDate
    /**
     * The list of instance profiles that contain this role.
     */
    public val instanceProfileList: List<AwsIamInstanceProfile>? = builder.instanceProfileList
    /**
     * The maximum session duration (in seconds) that you want to set for the specified role.
     */
    public val maxSessionDuration: kotlin.Int = builder.maxSessionDuration
    /**
     * The path to the role.
     */
    public val path: kotlin.String? = builder.path
    /**
     * Information about the policy used to set the permissions boundary for an IAM principal.
     */
    public val permissionsBoundary: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary? = builder.permissionsBoundary
    /**
     * The stable and unique string identifying the role.
     */
    public val roleId: kotlin.String? = builder.roleId
    /**
     * The friendly name that identifies the role.
     */
    public val roleName: kotlin.String? = builder.roleName
    /**
     * The list of inline policies that are embedded in the role.
     */
    public val rolePolicyList: List<AwsIamRolePolicy>? = builder.rolePolicyList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsIamRoleDetails(")
        append("assumeRolePolicyDocument=$assumeRolePolicyDocument,")
        append("attachedManagedPolicies=$attachedManagedPolicies,")
        append("createDate=$createDate,")
        append("instanceProfileList=$instanceProfileList,")
        append("maxSessionDuration=$maxSessionDuration,")
        append("path=$path,")
        append("permissionsBoundary=$permissionsBoundary,")
        append("roleId=$roleId,")
        append("roleName=$roleName,")
        append("rolePolicyList=$rolePolicyList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumeRolePolicyDocument?.hashCode() ?: 0
        result = 31 * result + (attachedManagedPolicies?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (instanceProfileList?.hashCode() ?: 0)
        result = 31 * result + (maxSessionDuration)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (permissionsBoundary?.hashCode() ?: 0)
        result = 31 * result + (roleId?.hashCode() ?: 0)
        result = 31 * result + (roleName?.hashCode() ?: 0)
        result = 31 * result + (rolePolicyList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsIamRoleDetails

        if (assumeRolePolicyDocument != other.assumeRolePolicyDocument) return false
        if (attachedManagedPolicies != other.attachedManagedPolicies) return false
        if (createDate != other.createDate) return false
        if (instanceProfileList != other.instanceProfileList) return false
        if (maxSessionDuration != other.maxSessionDuration) return false
        if (path != other.path) return false
        if (permissionsBoundary != other.permissionsBoundary) return false
        if (roleId != other.roleId) return false
        if (roleName != other.roleName) return false
        if (rolePolicyList != other.rolePolicyList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The trust policy that grants permission to assume the role.
         */
        public var assumeRolePolicyDocument: kotlin.String? = null
        /**
         * The list of the managed policies that are attached to the role.
         */
        public var attachedManagedPolicies: List<AwsIamAttachedManagedPolicy>? = null
        /**
         * Indicates when the role was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var createDate: kotlin.String? = null
        /**
         * The list of instance profiles that contain this role.
         */
        public var instanceProfileList: List<AwsIamInstanceProfile>? = null
        /**
         * The maximum session duration (in seconds) that you want to set for the specified role.
         */
        public var maxSessionDuration: kotlin.Int = 0
        /**
         * The path to the role.
         */
        public var path: kotlin.String? = null
        /**
         * Information about the policy used to set the permissions boundary for an IAM principal.
         */
        public var permissionsBoundary: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary? = null
        /**
         * The stable and unique string identifying the role.
         */
        public var roleId: kotlin.String? = null
        /**
         * The friendly name that identifies the role.
         */
        public var roleName: kotlin.String? = null
        /**
         * The list of inline policies that are embedded in the role.
         */
        public var rolePolicyList: List<AwsIamRolePolicy>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails) : this() {
            this.assumeRolePolicyDocument = x.assumeRolePolicyDocument
            this.attachedManagedPolicies = x.attachedManagedPolicies
            this.createDate = x.createDate
            this.instanceProfileList = x.instanceProfileList
            this.maxSessionDuration = x.maxSessionDuration
            this.path = x.path
            this.permissionsBoundary = x.permissionsBoundary
            this.roleId = x.roleId
            this.roleName = x.roleName
            this.rolePolicyList = x.rolePolicyList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsIamRoleDetails = AwsIamRoleDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary] inside the given [block]
         */
        public fun permissionsBoundary(block: aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary.Builder.() -> kotlin.Unit) {
            this.permissionsBoundary = aws.sdk.kotlin.services.securityhub.model.AwsIamPermissionsBoundary.invoke(block)
        }
    }
}
