// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about a load balancer listener.
 */
public class AwsElbLoadBalancerListener private constructor(builder: Builder) {
    /**
     * The port on which the instance is listening.
     */
    public val instancePort: kotlin.Int = builder.instancePort
    /**
     * The protocol to use to route traffic to instances.
     *
     * Valid values: `HTTP` | `HTTPS` | `TCP` | `SSL`
     */
    public val instanceProtocol: kotlin.String? = builder.instanceProtocol
    /**
     * The port on which the load balancer is listening.
     *
     * On EC2-VPC, you can specify any port from the range 1-65535.
     *
     * On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
     */
    public val loadBalancerPort: kotlin.Int = builder.loadBalancerPort
    /**
     * The load balancer transport protocol to use for routing.
     *
     * Valid values: `HTTP` | `HTTPS` | `TCP` | `SSL`
     */
    public val protocol: kotlin.String? = builder.protocol
    /**
     * The ARN of the server certificate.
     */
    public val sslCertificateId: kotlin.String? = builder.sslCertificateId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerListener = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElbLoadBalancerListener(")
        append("instancePort=$instancePort,")
        append("instanceProtocol=$instanceProtocol,")
        append("loadBalancerPort=$loadBalancerPort,")
        append("protocol=$protocol,")
        append("sslCertificateId=$sslCertificateId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instancePort
        result = 31 * result + (instanceProtocol?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerPort)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (sslCertificateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElbLoadBalancerListener

        if (instancePort != other.instancePort) return false
        if (instanceProtocol != other.instanceProtocol) return false
        if (loadBalancerPort != other.loadBalancerPort) return false
        if (protocol != other.protocol) return false
        if (sslCertificateId != other.sslCertificateId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerListener = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The port on which the instance is listening.
         */
        public var instancePort: kotlin.Int = 0
        /**
         * The protocol to use to route traffic to instances.
         *
         * Valid values: `HTTP` | `HTTPS` | `TCP` | `SSL`
         */
        public var instanceProtocol: kotlin.String? = null
        /**
         * The port on which the load balancer is listening.
         *
         * On EC2-VPC, you can specify any port from the range 1-65535.
         *
         * On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
         */
        public var loadBalancerPort: kotlin.Int = 0
        /**
         * The load balancer transport protocol to use for routing.
         *
         * Valid values: `HTTP` | `HTTPS` | `TCP` | `SSL`
         */
        public var protocol: kotlin.String? = null
        /**
         * The ARN of the server certificate.
         */
        public var sslCertificateId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerListener) : this() {
            this.instancePort = x.instancePort
            this.instanceProtocol = x.instanceProtocol
            this.loadBalancerPort = x.loadBalancerPort
            this.protocol = x.protocol
            this.sslCertificateId = x.sslCertificateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElbLoadBalancerListener = AwsElbLoadBalancerListener(this)
    }
}
