// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * details about the configuration of an OpenSearch cluster.
 */
public class AwsElasticsearchDomainElasticsearchClusterConfigDetails private constructor(builder: Builder) {
    /**
     * The number of instances to use for the master node. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
     */
    public val dedicatedMasterCount: kotlin.Int = builder.dedicatedMasterCount
    /**
     * Whether to use a dedicated master node for the Elasticsearch domain. A dedicated master node performs cluster management tasks, but doesn't hold data or respond to data upload requests.
     */
    public val dedicatedMasterEnabled: kotlin.Boolean = builder.dedicatedMasterEnabled
    /**
     * The hardware configuration of the computer that hosts the dedicated master node. A sample value is `m3.medium.elasticsearch`. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
     *
     * For a list of valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) in the *Amazon OpenSearch Service Developer Guide*.
     */
    public val dedicatedMasterType: kotlin.String? = builder.dedicatedMasterType
    /**
     * The number of data nodes to use in the Elasticsearch domain.
     */
    public val instanceCount: kotlin.Int = builder.instanceCount
    /**
     * The instance type for your data nodes. For example, `m3.medium.elasticsearch`.
     *
     * For a list of valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) in the *Amazon OpenSearch Service Developer Guide*.
     */
    public val instanceType: kotlin.String? = builder.instanceType
    /**
     * Configuration options for zone awareness. Provided if `ZoneAwarenessEnabled` is `true`.
     */
    public val zoneAwarenessConfig: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails? = builder.zoneAwarenessConfig
    /**
     * Whether to enable zone awareness for the Elasticsearch domain. When zone awareness is enabled, OpenSearch allocates the cluster's nodes and replica index shards across Availability Zones in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.
     */
    public val zoneAwarenessEnabled: kotlin.Boolean = builder.zoneAwarenessEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElasticsearchDomainElasticsearchClusterConfigDetails(")
        append("dedicatedMasterCount=$dedicatedMasterCount,")
        append("dedicatedMasterEnabled=$dedicatedMasterEnabled,")
        append("dedicatedMasterType=$dedicatedMasterType,")
        append("instanceCount=$instanceCount,")
        append("instanceType=$instanceType,")
        append("zoneAwarenessConfig=$zoneAwarenessConfig,")
        append("zoneAwarenessEnabled=$zoneAwarenessEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dedicatedMasterCount
        result = 31 * result + (dedicatedMasterEnabled.hashCode())
        result = 31 * result + (dedicatedMasterType?.hashCode() ?: 0)
        result = 31 * result + (instanceCount)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessConfig?.hashCode() ?: 0)
        result = 31 * result + (zoneAwarenessEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElasticsearchDomainElasticsearchClusterConfigDetails

        if (dedicatedMasterCount != other.dedicatedMasterCount) return false
        if (dedicatedMasterEnabled != other.dedicatedMasterEnabled) return false
        if (dedicatedMasterType != other.dedicatedMasterType) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceType != other.instanceType) return false
        if (zoneAwarenessConfig != other.zoneAwarenessConfig) return false
        if (zoneAwarenessEnabled != other.zoneAwarenessEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of instances to use for the master node. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
         */
        public var dedicatedMasterCount: kotlin.Int = 0
        /**
         * Whether to use a dedicated master node for the Elasticsearch domain. A dedicated master node performs cluster management tasks, but doesn't hold data or respond to data upload requests.
         */
        public var dedicatedMasterEnabled: kotlin.Boolean = false
        /**
         * The hardware configuration of the computer that hosts the dedicated master node. A sample value is `m3.medium.elasticsearch`. If this attribute is specified, then `DedicatedMasterEnabled` must be `true`.
         *
         * For a list of valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) in the *Amazon OpenSearch Service Developer Guide*.
         */
        public var dedicatedMasterType: kotlin.String? = null
        /**
         * The number of data nodes to use in the Elasticsearch domain.
         */
        public var instanceCount: kotlin.Int = 0
        /**
         * The instance type for your data nodes. For example, `m3.medium.elasticsearch`.
         *
         * For a list of valid values, see [Supported instance types in Amazon OpenSearch Service](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html) in the *Amazon OpenSearch Service Developer Guide*.
         */
        public var instanceType: kotlin.String? = null
        /**
         * Configuration options for zone awareness. Provided if `ZoneAwarenessEnabled` is `true`.
         */
        public var zoneAwarenessConfig: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails? = null
        /**
         * Whether to enable zone awareness for the Elasticsearch domain. When zone awareness is enabled, OpenSearch allocates the cluster's nodes and replica index shards across Availability Zones in the same Region. This prevents data loss and minimizes downtime if a node or data center fails.
         */
        public var zoneAwarenessEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails) : this() {
            this.dedicatedMasterCount = x.dedicatedMasterCount
            this.dedicatedMasterEnabled = x.dedicatedMasterEnabled
            this.dedicatedMasterType = x.dedicatedMasterType
            this.instanceCount = x.instanceCount
            this.instanceType = x.instanceType
            this.zoneAwarenessConfig = x.zoneAwarenessConfig
            this.zoneAwarenessEnabled = x.zoneAwarenessEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails = AwsElasticsearchDomainElasticsearchClusterConfigDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails] inside the given [block]
         */
        public fun zoneAwarenessConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.Builder.() -> kotlin.Unit) {
            this.zoneAwarenessConfig = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.invoke(block)
        }
    }
}
