// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an Elasticsearch domain.
 */
public class AwsElasticsearchDomainDetails private constructor(builder: Builder) {
    /**
     * IAM policy document specifying the access policies for the new Elasticsearch domain.
     */
    public val accessPolicies: kotlin.String? = builder.accessPolicies
    /**
     * Additional options for the domain endpoint.
     */
    public val domainEndpointOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions? = builder.domainEndpointOptions
    /**
     * Unique identifier for an Elasticsearch domain.
     */
    public val domainId: kotlin.String? = builder.domainId
    /**
     * Name of an Elasticsearch domain.
     *
     * Domain names are unique across all domains owned by the same account within an Amazon Web Services Region.
     *
     * Domain names must start with a lowercase letter and must be between 3 and 28 characters.
     *
     * Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * Information about an OpenSearch cluster configuration.
     */
    public val elasticsearchClusterConfig: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails? = builder.elasticsearchClusterConfig
    /**
     * OpenSearch version.
     */
    public val elasticsearchVersion: kotlin.String? = builder.elasticsearchVersion
    /**
     * Details about the configuration for encryption at rest.
     */
    public val encryptionAtRestOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions? = builder.encryptionAtRestOptions
    /**
     * Domain-specific endpoint used to submit index, search, and data upload requests to an Elasticsearch domain.
     *
     * The endpoint is a service URL.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
     */
    public val endpoints: Map<String, String>? = builder.endpoints
    /**
     * Configures the CloudWatch Logs to publish for the Elasticsearch domain.
     */
    public val logPublishingOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions? = builder.logPublishingOptions
    /**
     * Details about the configuration for node-to-node encryption.
     */
    public val nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions? = builder.nodeToNodeEncryptionOptions
    /**
     * Information about the status of a domain relative to the latest service software.
     */
    public val serviceSoftwareOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions? = builder.serviceSoftwareOptions
    /**
     * Information that OpenSearch derives based on `VPCOptions` for the domain.
     */
    public val vpcOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainVpcOptions? = builder.vpcOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsElasticsearchDomainDetails(")
        append("accessPolicies=$accessPolicies,")
        append("domainEndpointOptions=$domainEndpointOptions,")
        append("domainId=$domainId,")
        append("domainName=$domainName,")
        append("elasticsearchClusterConfig=$elasticsearchClusterConfig,")
        append("elasticsearchVersion=$elasticsearchVersion,")
        append("encryptionAtRestOptions=$encryptionAtRestOptions,")
        append("endpoint=$endpoint,")
        append("endpoints=$endpoints,")
        append("logPublishingOptions=$logPublishingOptions,")
        append("nodeToNodeEncryptionOptions=$nodeToNodeEncryptionOptions,")
        append("serviceSoftwareOptions=$serviceSoftwareOptions,")
        append("vpcOptions=$vpcOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPolicies?.hashCode() ?: 0
        result = 31 * result + (domainEndpointOptions?.hashCode() ?: 0)
        result = 31 * result + (domainId?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchClusterConfig?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchVersion?.hashCode() ?: 0)
        result = 31 * result + (encryptionAtRestOptions?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (endpoints?.hashCode() ?: 0)
        result = 31 * result + (logPublishingOptions?.hashCode() ?: 0)
        result = 31 * result + (nodeToNodeEncryptionOptions?.hashCode() ?: 0)
        result = 31 * result + (serviceSoftwareOptions?.hashCode() ?: 0)
        result = 31 * result + (vpcOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsElasticsearchDomainDetails

        if (accessPolicies != other.accessPolicies) return false
        if (domainEndpointOptions != other.domainEndpointOptions) return false
        if (domainId != other.domainId) return false
        if (domainName != other.domainName) return false
        if (elasticsearchClusterConfig != other.elasticsearchClusterConfig) return false
        if (elasticsearchVersion != other.elasticsearchVersion) return false
        if (encryptionAtRestOptions != other.encryptionAtRestOptions) return false
        if (endpoint != other.endpoint) return false
        if (endpoints != other.endpoints) return false
        if (logPublishingOptions != other.logPublishingOptions) return false
        if (nodeToNodeEncryptionOptions != other.nodeToNodeEncryptionOptions) return false
        if (serviceSoftwareOptions != other.serviceSoftwareOptions) return false
        if (vpcOptions != other.vpcOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * IAM policy document specifying the access policies for the new Elasticsearch domain.
         */
        public var accessPolicies: kotlin.String? = null
        /**
         * Additional options for the domain endpoint.
         */
        public var domainEndpointOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions? = null
        /**
         * Unique identifier for an Elasticsearch domain.
         */
        public var domainId: kotlin.String? = null
        /**
         * Name of an Elasticsearch domain.
         *
         * Domain names are unique across all domains owned by the same account within an Amazon Web Services Region.
         *
         * Domain names must start with a lowercase letter and must be between 3 and 28 characters.
         *
         * Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
         */
        public var domainName: kotlin.String? = null
        /**
         * Information about an OpenSearch cluster configuration.
         */
        public var elasticsearchClusterConfig: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails? = null
        /**
         * OpenSearch version.
         */
        public var elasticsearchVersion: kotlin.String? = null
        /**
         * Details about the configuration for encryption at rest.
         */
        public var encryptionAtRestOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions? = null
        /**
         * Domain-specific endpoint used to submit index, search, and data upload requests to an Elasticsearch domain.
         *
         * The endpoint is a service URL.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
         */
        public var endpoints: Map<String, String>? = null
        /**
         * Configures the CloudWatch Logs to publish for the Elasticsearch domain.
         */
        public var logPublishingOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions? = null
        /**
         * Details about the configuration for node-to-node encryption.
         */
        public var nodeToNodeEncryptionOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions? = null
        /**
         * Information about the status of a domain relative to the latest service software.
         */
        public var serviceSoftwareOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions? = null
        /**
         * Information that OpenSearch derives based on `VPCOptions` for the domain.
         */
        public var vpcOptions: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainVpcOptions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails) : this() {
            this.accessPolicies = x.accessPolicies
            this.domainEndpointOptions = x.domainEndpointOptions
            this.domainId = x.domainId
            this.domainName = x.domainName
            this.elasticsearchClusterConfig = x.elasticsearchClusterConfig
            this.elasticsearchVersion = x.elasticsearchVersion
            this.encryptionAtRestOptions = x.encryptionAtRestOptions
            this.endpoint = x.endpoint
            this.endpoints = x.endpoints
            this.logPublishingOptions = x.logPublishingOptions
            this.nodeToNodeEncryptionOptions = x.nodeToNodeEncryptionOptions
            this.serviceSoftwareOptions = x.serviceSoftwareOptions
            this.vpcOptions = x.vpcOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDetails = AwsElasticsearchDomainDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions] inside the given [block]
         */
        public fun domainEndpointOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.Builder.() -> kotlin.Unit) {
            this.domainEndpointOptions = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails] inside the given [block]
         */
        public fun elasticsearchClusterConfig(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder.() -> kotlin.Unit) {
            this.elasticsearchClusterConfig = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions] inside the given [block]
         */
        public fun encryptionAtRestOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.Builder.() -> kotlin.Unit) {
            this.encryptionAtRestOptions = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions] inside the given [block]
         */
        public fun logPublishingOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.Builder.() -> kotlin.Unit) {
            this.logPublishingOptions = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions] inside the given [block]
         */
        public fun nodeToNodeEncryptionOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder.() -> kotlin.Unit) {
            this.nodeToNodeEncryptionOptions = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions] inside the given [block]
         */
        public fun serviceSoftwareOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.Builder.() -> kotlin.Unit) {
            this.serviceSoftwareOptions = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainVpcOptions] inside the given [block]
         */
        public fun vpcOptions(block: aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainVpcOptions.Builder.() -> kotlin.Unit) {
            this.vpcOptions = aws.sdk.kotlin.services.securityhub.model.AwsElasticsearchDomainVpcOptions.invoke(block)
        }
    }
}
