// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about a task in a cluster.
 */
public class AwsEcsTaskDetails private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cluster that hosts the task.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * The containers that are associated with the task.
     */
    public val containers: List<AwsEcsContainerDetails>? = builder.containers
    /**
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task entered the `PENDING` state.
     */
    public val createdAt: kotlin.String? = builder.createdAt
    /**
     * The name of the task group that's associated with the task.
     */
    public val group: kotlin.String? = builder.group
    /**
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task transitioned from the `PENDING` state to the `RUNNING` state.
     */
    public val startedAt: kotlin.String? = builder.startedAt
    /**
     * The tag specified when a task is started. If an Amazon ECS service started the task, the `startedBy` parameter contains the deployment ID of that service.
     */
    public val startedBy: kotlin.String? = builder.startedBy
    /**
     * The ARN of the task definition that creates the task.
     */
    public val taskDefinitionArn: kotlin.String? = builder.taskDefinitionArn
    /**
     * The version counter for the task.
     */
    public val version: kotlin.String? = builder.version
    /**
     * Details about the data volume that is used in a task definition.
     */
    public val volumes: List<AwsEcsTaskVolumeDetails>? = builder.volumes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsTaskDetails(")
        append("clusterArn=$clusterArn,")
        append("containers=$containers,")
        append("createdAt=$createdAt,")
        append("group=$group,")
        append("startedAt=$startedAt,")
        append("startedBy=$startedBy,")
        append("taskDefinitionArn=$taskDefinitionArn,")
        append("version=$version,")
        append("volumes=$volumes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterArn?.hashCode() ?: 0
        result = 31 * result + (containers?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        result = 31 * result + (taskDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (volumes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsTaskDetails

        if (clusterArn != other.clusterArn) return false
        if (containers != other.containers) return false
        if (createdAt != other.createdAt) return false
        if (group != other.group) return false
        if (startedAt != other.startedAt) return false
        if (startedBy != other.startedBy) return false
        if (taskDefinitionArn != other.taskDefinitionArn) return false
        if (version != other.version) return false
        if (volumes != other.volumes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cluster that hosts the task.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * The containers that are associated with the task.
         */
        public var containers: List<AwsEcsContainerDetails>? = null
        /**
         * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task entered the `PENDING` state.
         */
        public var createdAt: kotlin.String? = null
        /**
         * The name of the task group that's associated with the task.
         */
        public var group: kotlin.String? = null
        /**
         * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task transitioned from the `PENDING` state to the `RUNNING` state.
         */
        public var startedAt: kotlin.String? = null
        /**
         * The tag specified when a task is started. If an Amazon ECS service started the task, the `startedBy` parameter contains the deployment ID of that service.
         */
        public var startedBy: kotlin.String? = null
        /**
         * The ARN of the task definition that creates the task.
         */
        public var taskDefinitionArn: kotlin.String? = null
        /**
         * The version counter for the task.
         */
        public var version: kotlin.String? = null
        /**
         * Details about the data volume that is used in a task definition.
         */
        public var volumes: List<AwsEcsTaskVolumeDetails>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails) : this() {
            this.clusterArn = x.clusterArn
            this.containers = x.containers
            this.createdAt = x.createdAt
            this.group = x.group
            this.startedAt = x.startedAt
            this.startedBy = x.startedBy
            this.taskDefinitionArn = x.taskDefinitionArn
            this.version = x.version
            this.volumes = x.volumes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsTaskDetails = AwsEcsTaskDetails(this)
    }
}
