// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Provides details about a service within an ECS cluster.
 */
public class AwsEcsServiceDetails private constructor(builder: Builder) {
    /**
     * The capacity provider strategy that the service uses.
     */
    public val capacityProviderStrategy: List<AwsEcsServiceCapacityProviderStrategyDetails>? = builder.capacityProviderStrategy
    /**
     * The ARN of the cluster that hosts the service.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * Deployment parameters for the service. Includes the number of tasks that run and the order in which to start and stop tasks.
     */
    public val deploymentConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails? = builder.deploymentConfiguration
    /**
     * Contains the deployment controller type that the service uses.
     */
    public val deploymentController: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails? = builder.deploymentController
    /**
     * The number of instantiations of the task definition to run on the service.
     */
    public val desiredCount: kotlin.Int = builder.desiredCount
    /**
     * Whether to enable Amazon ECS managed tags for the tasks in the service.
     */
    public val enableEcsManagedTags: kotlin.Boolean = builder.enableEcsManagedTags
    /**
     * Whether the execute command functionality is enabled for the service.
     */
    public val enableExecuteCommand: kotlin.Boolean = builder.enableExecuteCommand
    /**
     * After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks.
     */
    public val healthCheckGracePeriodSeconds: kotlin.Int = builder.healthCheckGracePeriodSeconds
    /**
     * The launch type that the service uses.
     *
     * Valid values: `EC2` | `FARGATE` | `EXTERNAL`
     */
    public val launchType: kotlin.String? = builder.launchType
    /**
     * Information about the load balancers that the service uses.
     */
    public val loadBalancers: List<AwsEcsServiceLoadBalancersDetails>? = builder.loadBalancers
    /**
     * The name of the service.
     */
    public val name: kotlin.String? = builder.name
    /**
     * For tasks that use the `awsvpc` networking mode, the VPC subnet and security group configuration.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails? = builder.networkConfiguration
    /**
     * The placement constraints for the tasks in the service.
     */
    public val placementConstraints: List<AwsEcsServicePlacementConstraintsDetails>? = builder.placementConstraints
    /**
     * Information about how tasks for the service are placed.
     */
    public val placementStrategies: List<AwsEcsServicePlacementStrategiesDetails>? = builder.placementStrategies
    /**
     * The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a platform version is not specified, the `LATEST` platform version is used by default.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * Indicates whether to propagate the tags from the task definition to the task or from the service to the task. If no value is provided, then tags are not propagated.
     *
     * Valid values: `TASK_DEFINITION` | `SERVICE`
     */
    public val propagateTags: kotlin.String? = builder.propagateTags
    /**
     * The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The scheduling strategy to use for the service.
     *
     * The `REPLICA` scheduling strategy places and maintains the desired number of tasks across the cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies and constraints are used to customize task placement decisions.
     *
     * The `DAEMON` scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that are specified in the cluster. The service scheduler also evaluates the task placement constraints for running tasks and stops tasks that do not meet the placement constraints.
     *
     * Valid values: `REPLICA` | `DAEMON`
     */
    public val schedulingStrategy: kotlin.String? = builder.schedulingStrategy
    /**
     * The ARN of the service.
     */
    public val serviceArn: kotlin.String? = builder.serviceArn
    /**
     * The name of the service.
     *
     * The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * Information about the service discovery registries to assign to the service.
     */
    public val serviceRegistries: List<AwsEcsServiceServiceRegistriesDetails>? = builder.serviceRegistries
    /**
     * The task definition to use for tasks in the service.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcsServiceDetails(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("cluster=$cluster,")
        append("deploymentConfiguration=$deploymentConfiguration,")
        append("deploymentController=$deploymentController,")
        append("desiredCount=$desiredCount,")
        append("enableEcsManagedTags=$enableEcsManagedTags,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("healthCheckGracePeriodSeconds=$healthCheckGracePeriodSeconds,")
        append("launchType=$launchType,")
        append("loadBalancers=$loadBalancers,")
        append("name=$name,")
        append("networkConfiguration=$networkConfiguration,")
        append("placementConstraints=$placementConstraints,")
        append("placementStrategies=$placementStrategies,")
        append("platformVersion=$platformVersion,")
        append("propagateTags=$propagateTags,")
        append("role=$role,")
        append("schedulingStrategy=$schedulingStrategy,")
        append("serviceArn=$serviceArn,")
        append("serviceName=$serviceName,")
        append("serviceRegistries=$serviceRegistries,")
        append("taskDefinition=$taskDefinition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentController?.hashCode() ?: 0)
        result = 31 * result + (desiredCount)
        result = 31 * result + (enableEcsManagedTags.hashCode())
        result = 31 * result + (enableExecuteCommand.hashCode())
        result = 31 * result + (healthCheckGracePeriodSeconds)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancers?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (placementStrategies?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (schedulingStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceArn?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (serviceRegistries?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcsServiceDetails

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (cluster != other.cluster) return false
        if (deploymentConfiguration != other.deploymentConfiguration) return false
        if (deploymentController != other.deploymentController) return false
        if (desiredCount != other.desiredCount) return false
        if (enableEcsManagedTags != other.enableEcsManagedTags) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (healthCheckGracePeriodSeconds != other.healthCheckGracePeriodSeconds) return false
        if (launchType != other.launchType) return false
        if (loadBalancers != other.loadBalancers) return false
        if (name != other.name) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (placementConstraints != other.placementConstraints) return false
        if (placementStrategies != other.placementStrategies) return false
        if (platformVersion != other.platformVersion) return false
        if (propagateTags != other.propagateTags) return false
        if (role != other.role) return false
        if (schedulingStrategy != other.schedulingStrategy) return false
        if (serviceArn != other.serviceArn) return false
        if (serviceName != other.serviceName) return false
        if (serviceRegistries != other.serviceRegistries) return false
        if (taskDefinition != other.taskDefinition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capacity provider strategy that the service uses.
         */
        public var capacityProviderStrategy: List<AwsEcsServiceCapacityProviderStrategyDetails>? = null
        /**
         * The ARN of the cluster that hosts the service.
         */
        public var cluster: kotlin.String? = null
        /**
         * Deployment parameters for the service. Includes the number of tasks that run and the order in which to start and stop tasks.
         */
        public var deploymentConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails? = null
        /**
         * Contains the deployment controller type that the service uses.
         */
        public var deploymentController: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails? = null
        /**
         * The number of instantiations of the task definition to run on the service.
         */
        public var desiredCount: kotlin.Int = 0
        /**
         * Whether to enable Amazon ECS managed tags for the tasks in the service.
         */
        public var enableEcsManagedTags: kotlin.Boolean = false
        /**
         * Whether the execute command functionality is enabled for the service.
         */
        public var enableExecuteCommand: kotlin.Boolean = false
        /**
         * After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks.
         */
        public var healthCheckGracePeriodSeconds: kotlin.Int = 0
        /**
         * The launch type that the service uses.
         *
         * Valid values: `EC2` | `FARGATE` | `EXTERNAL`
         */
        public var launchType: kotlin.String? = null
        /**
         * Information about the load balancers that the service uses.
         */
        public var loadBalancers: List<AwsEcsServiceLoadBalancersDetails>? = null
        /**
         * The name of the service.
         */
        public var name: kotlin.String? = null
        /**
         * For tasks that use the `awsvpc` networking mode, the VPC subnet and security group configuration.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails? = null
        /**
         * The placement constraints for the tasks in the service.
         */
        public var placementConstraints: List<AwsEcsServicePlacementConstraintsDetails>? = null
        /**
         * Information about how tasks for the service are placed.
         */
        public var placementStrategies: List<AwsEcsServicePlacementStrategiesDetails>? = null
        /**
         * The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a platform version is not specified, the `LATEST` platform version is used by default.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * Indicates whether to propagate the tags from the task definition to the task or from the service to the task. If no value is provided, then tags are not propagated.
         *
         * Valid values: `TASK_DEFINITION` | `SERVICE`
         */
        public var propagateTags: kotlin.String? = null
        /**
         * The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent to register container instances with an Elastic Load Balancing load balancer.
         */
        public var role: kotlin.String? = null
        /**
         * The scheduling strategy to use for the service.
         *
         * The `REPLICA` scheduling strategy places and maintains the desired number of tasks across the cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies and constraints are used to customize task placement decisions.
         *
         * The `DAEMON` scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that are specified in the cluster. The service scheduler also evaluates the task placement constraints for running tasks and stops tasks that do not meet the placement constraints.
         *
         * Valid values: `REPLICA` | `DAEMON`
         */
        public var schedulingStrategy: kotlin.String? = null
        /**
         * The ARN of the service.
         */
        public var serviceArn: kotlin.String? = null
        /**
         * The name of the service.
         *
         * The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.
         */
        public var serviceName: kotlin.String? = null
        /**
         * Information about the service discovery registries to assign to the service.
         */
        public var serviceRegistries: List<AwsEcsServiceServiceRegistriesDetails>? = null
        /**
         * The task definition to use for tasks in the service.
         */
        public var taskDefinition: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.cluster = x.cluster
            this.deploymentConfiguration = x.deploymentConfiguration
            this.deploymentController = x.deploymentController
            this.desiredCount = x.desiredCount
            this.enableEcsManagedTags = x.enableEcsManagedTags
            this.enableExecuteCommand = x.enableExecuteCommand
            this.healthCheckGracePeriodSeconds = x.healthCheckGracePeriodSeconds
            this.launchType = x.launchType
            this.loadBalancers = x.loadBalancers
            this.name = x.name
            this.networkConfiguration = x.networkConfiguration
            this.placementConstraints = x.placementConstraints
            this.placementStrategies = x.placementStrategies
            this.platformVersion = x.platformVersion
            this.propagateTags = x.propagateTags
            this.role = x.role
            this.schedulingStrategy = x.schedulingStrategy
            this.serviceArn = x.serviceArn
            this.serviceName = x.serviceName
            this.serviceRegistries = x.serviceRegistries
            this.taskDefinition = x.taskDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDetails = AwsEcsServiceDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails] inside the given [block]
         */
        public fun deploymentConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.deploymentConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails] inside the given [block]
         */
        public fun deploymentController(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails.Builder.() -> kotlin.Unit) {
            this.deploymentController = aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceDeploymentControllerDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.invoke(block)
        }
    }
}
