// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securityhub.model



/**
 * Information about an Amazon ECR image.
 */
public class AwsEcrContainerImageDetails private constructor(builder: Builder) {
    /**
     * The architecture of the image. Valid values are as follows:
     * + `arm64`
     * + `i386`
     * + `x86_64`
     */
    public val architecture: kotlin.String? = builder.architecture
    /**
     * The sha256 digest of the image manifest.
     */
    public val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The date and time when the image was pushed to the repository.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
     */
    public val imagePublishedAt: kotlin.String? = builder.imagePublishedAt
    /**
     * The list of tags that are associated with the image.
     */
    public val imageTags: List<String>? = builder.imageTags
    /**
     * The Amazon Web Services account identifier that is associated with the registry that the image belongs to.
     */
    public val registryId: kotlin.String? = builder.registryId
    /**
     * The name of the repository that the image belongs to.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcrContainerImageDetails(")
        append("architecture=$architecture,")
        append("imageDigest=$imageDigest,")
        append("imagePublishedAt=$imagePublishedAt,")
        append("imageTags=$imageTags,")
        append("registryId=$registryId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = architecture?.hashCode() ?: 0
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (imagePublishedAt?.hashCode() ?: 0)
        result = 31 * result + (imageTags?.hashCode() ?: 0)
        result = 31 * result + (registryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcrContainerImageDetails

        if (architecture != other.architecture) return false
        if (imageDigest != other.imageDigest) return false
        if (imagePublishedAt != other.imagePublishedAt) return false
        if (imageTags != other.imageTags) return false
        if (registryId != other.registryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The architecture of the image. Valid values are as follows:
         * + `arm64`
         * + `i386`
         * + `x86_64`
         */
        public var architecture: kotlin.String? = null
        /**
         * The sha256 digest of the image manifest.
         */
        public var imageDigest: kotlin.String? = null
        /**
         * The date and time when the image was pushed to the repository.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot contain spaces, and date and time should be separated by `T`. For example, `2020-03-22T13:22:13.933Z`.
         */
        public var imagePublishedAt: kotlin.String? = null
        /**
         * The list of tags that are associated with the image.
         */
        public var imageTags: List<String>? = null
        /**
         * The Amazon Web Services account identifier that is associated with the registry that the image belongs to.
         */
        public var registryId: kotlin.String? = null
        /**
         * The name of the repository that the image belongs to.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails) : this() {
            this.architecture = x.architecture
            this.imageDigest = x.imageDigest
            this.imagePublishedAt = x.imagePublishedAt
            this.imageTags = x.imageTags
            this.registryId = x.registryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securityhub.model.AwsEcrContainerImageDetails = AwsEcrContainerImageDetails(this)
    }
}
